#ifndef HAVE_DUMPSTR
#define HAVE_DUMPSTR

/* ________________________________________________________________
**|                                                                |
**| DUMP PARSE STRUCTURES                                          |
**|________________________________________________________________|
*/

#define UNKNOWN  0
#define LAND    'L'
#define PLANE   'P'
#define SHIP    'V'
#define SPY     'S'
#define ARMY	'A'

typedef struct comstr {
    int		c;		/* CIVIL */
    int		m;		/* MILIT */
    int		s;		/* SHELL */
    int		g;		/* GUN */
    int		p;		/* PETROL */
    int		i;		/* IRON */
    int		d;		/* DUST */
    int		b;		/* BAR */
    int		f;		/* FOOD */
    int		o;		/* OIL */
    int		l;		/* LCM */
    int		h;		/* HCM */
    int		u;		/* UW */
    int		r;		/* RAD */
    int		v;		/* VACC */
} _comstr;

typedef struct shpstr {
    char	DUMPTYPE;	/* 'V' FOR VEHICLES */
    char	TIME[32];	/* TIMESTAMP */
    struct shpstr *PREV,*NEXT;	/* UNDEFINED CONVENIENCE POINTERS */
    int   	owner;		/* owner's country num */
    int		id;		/* unit id (ship/vehicle #) */
    int		x;		/* x location */
    int		y;		/* y location */
    char	class[16];	/* "tank", "ship", "balloon", etc */
    char    	type[32];	/* "destroyer", "battletank", etc */
    char	name[16];	/* ship/vehicle name */
    char	orbit[16];	/* orbit speed, dir, alt (e.g., "7u/103") */
    int    	effic;		/* 0% to 100% */
    int    	mobil;		/* mobility units */
    int		tech;		/* tech level ship/vehicle was built at */
    char    	fleet;		/* group membership */
    char	convoy;		/* convoy membership */
    int    	planes;		/* number of planes/missiles on board */
    int    	tanks;    	/* number of tanks/vehicles on board */
    char	depth[16];	/* "surf", "peri", "deep", "high", etc */
    int		alt_depth;	/* numeric altitude/depth */
    int		air;		/* submarine air remaining */
    int		autonav;	/* autonav flags */
    int		standby;	/* TRUE if on standby */
    int		dest_x;		/* autonav destination x location */
    int		dest_y;		/* autonav destination y location */
    int		aboard;		/* id of ship carrying this vehicle (or -1) */
    _comstr	amt;		/* list of things ship/vehicle is carrying */
} _shpstr;

typedef struct plnstr {
    char	DUMPTYPE;	/* 'P' FOR PLANES */
    char	TIME[32];	/* TIMESTAMP */
    struct plnstr *PREV,*NEXT;	/* UNDEFINED CONVENIENCE POINTERS */
    int		owner;		/* owner's country num */
    int		id;		/* unit id (plane #) */
    int		x;		/* x location */
    int		y;		/* y location */
    char	type[32];	/* "fighter 1", "lt bomber 2", etc */
    int		effic;		/* efficiency */
    int		mobil;		/* mobility */
    int		tech;		/* plane's tech level */
    char	wing;		/* like fleet */
    int		range;		/* total distance, not radius */
    int		aboard;		/* id of ship carrying this plane (0r -1) */
    int		att;		/* plane air-air attack value */
    int		def;		/* plane air-air defense value */
    int		harden;		/* amount of hardening for missiles */
    int		armed;		/* TRUE if plane/sat is explosive-armed */
    int		launched;	/* TRUE if satellite has been launched */
    int		boxed;		/* TRUE if plane/sat is in crate */
    int		longrange;	/* TRUE if plane has longrange tanks */
    int		nukeamt;	/* number of warheads aboard */
    char	nuketype[32];	/* type of nuclear armament (if any) */
    char	orbit[16];	/* orbit altidue, speed and direction */
    int		gdr;		/* ABM global defense radius */
    int		alt;		/* satellite orbit altitude */
} _plnstr;

typedef struct armstr {
    char	DUMPTYPE;	/* 'A' FOR ARMY */
    char	TIME[32];	/* TIMESTAMP */
    struct armstr *PREV,*NEXT;	/* UNDEFINED CONVENIENCE POINTERS */
    int		owner;		/* owner */
    int 	id;		/* unit id */
    int		x;		/* x location */
    int		y;		/* y location */
    char 	type[32];	/* unit type */
    char 	name[16];	/* unit name */
    int  	effic;		/* efficiency (0-100) */
    int  	mobil;		/* mobility */
    char  	group;		/* group id */
    int 	tech;		/* tech level */
    int 	aboard;		/* transport */
    int		morale;		/* morale (0-100) */
    int  	acc;		/* accuracy (0-100) */
    _comstr	amt;		/* list of things army is carrying */
} _armstr;

typedef struct spystr {
    char	DUMPTYPE;	/* 'S' FOR SPY */
    char	TIME[32];	/* TIMESTAMP */
    struct spystr *PREV,*NEXT;	/* UNDEFINED CONVENIENCE POINTERS */
    int 	owner;		/* owner */
    int 	id;		/* spy unit id */
    int 	x;		/* x location */
    int 	y;		/* y location */
    char  	type[32];	/* "agent", "terrorist", etc */
    char 	name[16];	/* spy's name */
    int  	effic;		/* efficiency */
    int  	mobil;		/* mobility */
    int 	tech;		/* spy's tech level */
    char  	ring;		/* spy ring */
    int 	aboard;		/* id of ship carrying this spy (or -1) */
    int 	edu;		/* spy's education level */
    int 	hap;		/* spy's happiness level */
    int 	age;		/* length of service (etus) */
    int		acc;		/* accuracy */
    int 	pilot_tech;	/* can pilot planes at & below this tech */
    _comstr	amt;		/* list of things spy is carrying */
} _spystr;

typedef struct sctstr {
    char	DUMPTYPE;	/* 'L' FOR LAND */
    char	TIME[32];	/* TIMESTAMP */
    struct sctstr *PREV,*NEXT;	/* UNDEFINED CONVENIENCE POINTERS */
    int		owner;		/* owner's country num */
    int		x;		/* x coord of sector */
    int		y;		/* y coord of sector */
    char	des;		/* current sector type */
    char	newdes;		/* new sector designation */
    char	occupied;	/* occupied flag (sector not fully yours) */
    int		terr;		/* territory id # of sector */
    int		effic;		/* 0% to 100% */
    int		mobil;		/* mobility units */
    int		work;		/* percentage of civs actually working */
    int		avail;		/* available workforce */
    int		old_owner;	/* old owner of sector */
    char	dist_path[32];	/* commodity distribution path */
    int		dist_x;		/* distribution sector x coord */
    int		dist_y;		/* distribution sector y coord */
    int		m_res;		/* mineral resources */
    int		g_res;		/* gold resources */
    int		f_res;		/* fertility resources */
    int		o_res;		/* oil resources */
    int		u_res;		/* uranium resources */
    _comstr	amt;		/* amounts of commodities here */
    _comstr	cut;		/* cutoff thresholds of commodities here */
    _comstr	dist;		/* dist thresholds of commodities here */
    _comstr	del;		/* delivery thresholds of commodities here */
    int		bunker_size;	/* bunker size */
    int		road_imp;	/* percentage road improvements */
    int		rail_imp;	/* percentage rail improvements */
} _sctstr;

#endif
