.TH Command SPY
.SY "spy <SPIES> [subcommand] [args]..."
The `spy' command lets you micromanipulate your secret agents.
After using the `recruit' command to train spies, 
you use the `spy' command to direct their covert activities.
(Note that the old Empire `spy' command is still available under
a new name: `snoop'.)
.s3
The `spy' command can be used in many ways, enabling your spies
to perform a number of functions normally available only to the
owner of the ship or sector.  Your spies can be moved in foreign
land or sneaked aboard foreign vessels, where they can reveal, in 
estimated numbers, census and commodity reports, distribution paths 
and levels, crew and cargo reports, and the presence of ships, planes, 
and other vehicles.  Additionally, spies can be used to steal small
quantities of commodities, blow up select commodities in their current
location, liquidate individuals (including themselves), and reconnoiter
surrounding territory.
.s3
.NF
   -----------------------------------------------------------------
   PERSONAL STATUS

   General information  about   each  spy and his  surroundings   is
   provided when you use one of the following options:

       spy <id>                 Personal statistics.
       spy <id> report          General info about current location.
       spy <id> look            Map neighboring sectors.

   -----------------------------------------------------------------
   GENERAL MOVEMENT

   You move  spies with  the  `move' option.   Syntax is similar  to
   `explore' command:

       spy <id> move <path>     Move around.

   Be aware  that each time you move  a spy, you  run two risks: the
   spy may be detected and/or caught trying to leave the old sector,
   plus he may be detected/or caught trying to enter the new sector.
   Also note that the difficulty   factor for entering a new  sector
   may   vary  with the  sector   type; for   airports and  harbors,
   difficulty is 25% greater than  normal; for banks and warehouses,
   50%;  for forts  and bridgespans, 75%.   The increased difficulty
   reflects the higher military awareness in those types of sectors.

   -----------------------------------------------------------------
   FOREIGN STATUS REPORTS

   These commands produce estimated  commodity and  vehicle reports.

       spy <id> cargo [comlist]       Produce a cargo report.
       spy <id> commodities [comlist] Produce a commodities report.
       spy <id> level [comlist]       Produce a distribution report.
       spy <id> coastwatch            Perform a coastwatch.
       spy <id> recon                 Report on surrounding sectors.
       spy <id> planes                Report planes in the sector.
       spy <id> ships                 Report ships in the sector.
       spy <id> tanks                 Report tanks in the sector.
       spy <id> balloons              Report balloons in the sector.
       spy <id> trains                Report trains in the sector.
       spy <id> census                Produce a census report.

   The 'census'  option additionally  reports any rumors circulating
   in the spy's sector concerning the presence of  other spies.  The
   rumors become more  frequent as proximity  to another spy becomes
   closer.  If your spy  is in the same sector  as another spy,  all
   other things being  equal, there is  a 98%  chance that you  will
   hear rumors about him.  One sector away, the chance  is 49%.  Two
   sectors away, 32%; three  sectors away, 24%.  Beyond four sectors
   away,  the chance of  hearing a  rumor is a  constant at  2%.  Of
   course, the odds may  decrease  depending on the spies'  relative
   levels of education and efficiency.

   The 'census' option also produces an accurate count of the number
   of guerillas operating in the sector.

   -----------------------------------------------------------------
   MOVEMENT OF COMMODITIES

   Spies can personally  carry one sample of each  of almost any two
   commodities.  A  commodity may  be taken  from from  the  current
   sector,  or  from a ship's  or vehicle's  cargo.  Task difficulty
   factor depends  on  the  commodity  being taken;   `drop'  is the
   opposite of `take':

       5 civilians    5 iron         5 lcms         50 petrol
       35 military    15 dust        5 hcms         20 oil
       60 shells      80 bars        25 uranium
       60 guns         5 food        65 rads

       spy <id> take <comm>     Take a commodity.
       spy <id> drop <comm>     Drop a commodity.

   -----------------------------------------------------------------
   USING BOMBS

   Spies  possessing shells can   bomb  commodities.  The spy   must
   possess one shell, which he  very accurately places and detonates
   in the storage  place of a specific   commodity.  This can  cause
   some collateral damage in addition to large pinpoint damage, with
   damage more   severe  for explosions aboard   ships and vehicles.
   Bombs  can also  lead   to secondary  explosions when  the target
   itself is volatile or  explosive.  Task difficulty factor depends
   on the commodity being bombed, and are the same as for the `take'
   option:

       spy <id> bomb <comm>     Attempt to bomb a commodity.

   -----------------------------------------------------------------
   INCITING ANTIPATRIOTISM

   Creation of new guerillas  is the first  step toward attempting a
   coup.  Successful agitation of  a sector increases the number  of
   guerillas operating in  that  sector.  Success depends mainly  on
   the sector's loyalty plus some random factors:

       spy <id> agitate         Attempt to induce a rebellion.

   -----------------------------------------------------------------
   LEADING A COUP

   Once a sector contains a  substantial number of guerillas (either
   10,  or one-eighth the number of  mil in the sector, whichever is
   more), a spy can  make an attempt to lead  them in a coup.   Coup
   success depends  mostly on the numbers of  che and mil,  and to a
   lesser degree  on  sector  loyalty.   Once the  battle  for power
   begins, disloyal citizens may jump in and join the rebels.  Other
   residents tend to leave the fighting to  the military.  Coups are
   pretty much all-or-nothing, and  are generally pretty  bloody; if
   successful, the sector becomes yours, and most of the mil will be
   annihilated;  if unsuccessful, the spy  will  either be caught or
   killed, and most of the che will be exterminated:

       spy <id> coup            Attempt to overthrow a sector.

   -----------------------------------------------------------------
   ASSASSINATIONS

   A spy can slowly liquidate civs, mil, uws, or even other spies by
   using the `kill' option:

       spy <id> kill <m|c|u|id>

   -----------------------------------------------------------------
   BOARDING/LEAVING VESSELS

   Almost any ship or vehicle can be boarded, regardless of who owns 
   it.  The chance of being detected or caught depends on the number 
   of crew already aboard and the efficiency of the ship or vehicle.
   `Leave' is the opposite of `board', with the  addition  that  you 
   can optionally supply a direction, enabling a spy to leave a ship
   while at sea and sneak ashore on an adjacent coastal sector:

       spy <id> board <shipid>  Attempt to board a ship or vehicle.
       spy <id> leave [dir]     Leave a ship or vehicle.

   -----------------------------------------------------------------
   AIRCRAFT THEFT

   Any spy  can be used  to steal aircraft,  but first the  spy must 
   undergo  pilot training.  This is done leaving the spy in an air-
   port sector.   In a home airport, at each update his  pilot skill 
   level will increase by an  amount equal to one plus his education 
   level, times the number of etus per update divided by three.   In 
   foreign airports, the rate is 1/4 as fast.   Pilot training level 
   grows to match the tech  rating of the most tech nically advanced 
   plane in that sector.   Attempting to fly an  aircraft  of higher 
   tech than the pilot's training level allows can be suicidal.

       spy <id> steal <plane>   Steal an aircraft.

   -----------------------------------------------------------------
   GIVING A SPY TO ANOTHER COUNTRY

   You can easily give a spy to any other country.   Cost is 20 mob,
   and a  20% drop in efficiency.   (Mobility will not drop below 0;
   efficency will not drop below 25%.)

       spy <id> give <cnum>     Give a spy to another country.

   -----------------------------------------------------------------
   RETIREMENT

   If you have  a spy that has outlived  his usefulness to you,  and
   would simply like   to make him   go away, you  can force  him to
   retire.  The spy ceases to exist; his  current location gains one
   mil.  Spies  on foreign  soil  or aboard manned  foreign vehicles
   cannot quit.  If you quit aboard an  unmanned foreign vessel, the
   vessel  becomes  yours.   If  the spy is   more  than halfway  to
   retirement, a portion of his  pension is considered vested and he
   will be paid an appropriate 50, 60, 70, 80, 90, or 100 percent of
   his retirement pension:

       spy <id> retire          Quit and rejoin local military.

   -----------------------------------------------------------------
.FI
.s3
Generally, each spy command first pits the spy's accuracy and intelligence
against the target country's intelligence, technology, and military presence.
Depending on the outcome, the spy may be detected, shot at, killed.  Only
if the spy's actions go unnoticed does the requested assignment actually
get carried out.
.s3
A spy's accuracy may change at each update and depends on a number of factors,
including his personal efficiency, tech, education, happiness, and age levels,
the tech, education, and happiness levels in his homeland, and those same
levels in the country in which he is operating.
.s3
The type of sector in which a spy is located also affects how his levels
change.  A spy's efficiency increases everywhere, but will grow twice as 
fast if he is in a Fort, a Park, or a Capitol.  Being located in a tech
center causes his tech level to increase; a park will increase his happiness.
Education increases in schools, and to a lesser degree in forts and capitols.
Pilot skills increase in airfields.
.s3
If you place a spy in any foreign capitol (can be any capitol, not
just a real one), there is a chance that the spy will intercept
telegrams sent to and from the capitol's owner.  The chance of interception
reflects the ability of the foreign country to encrypt and pass messages,
and is equivalent to:
.NF

                spy's education               spy's efficiency
           -------------------------  X  ---------------------------
           (capitol's edu level + 1)     (capitol's efficiency + 10)

.FI
.s3
Personal levels also frequently move some degree 
toward local national levels.  Tech and education naturally rise, 
regardless of location, toward the local levels wherever he happens 
to be.  The increase rate is greater at home than aboard (information 
at home is more readily available and easier learned). 
.s3
Certain task outcomes may cause drops in happiness.
Personal happiness level determines degree of job satisfaction, which 
in turn determines whether a spy will choose to continue to work, resign,
defect, or simply vanish.
.s3
Spies are paid according to a typical complex bureaucratic salary 
formula which takes into account a number of factors.  In addition to
his base pay, a spy receives bonus pay if he is on foreign soil,
is extremely smart, or is very technically capable.  Pay is reduced
if he's technically deficient, overly happy, or an idiot.
.s3
Each spy's age increases by one at each update; mandatory retirement 
happens when age exceeds 2800 divided by the number of etus per update.
Upon retirement, the spy receives a retirement pension.
.s3
See also : recruit, hunt, snoop
