.TH Concept Space Shuttles
.s1
Space shuttles are high-tech, manned, navigable satellites.
Unlike expensive one-shot satellites however, shuttles are reusable.
Also, while the initial construction cost of a shuttle is high,
each launch of the same shuttle is relatively inexpensive at around
$500 per shot.  
.s3
Unlike satellites, which stay in a fixed orbit, shuttles can be
maneuvered to various altitudes and can even change orbital direction. 
Altitudes range from 0 (on the ground) to 127 (the threshold of space).
The planet's atmosphere extends up to about altitude 32; it is beyond
this point that shuttles best function.
.s1
ORBITAL VELOCITY AND DIRECTION
.s3
Orbital velocity varies linearly with altitude.  Each update, a shuttle
(or satellite) will move zero distance if in the geosynchrous parking
orbit at the threshold of space (altitude 127); a distance of ETU sectors 
if at the edge of the atmosphere (altitude 32); appropriately larger 
or smaller distances at other altitudes.  The direction of movement
generally is set by the direction in which a shuttle (or satellite) 
is launched; although you can use the `\*Qnav\*U' command to maneuver
a shuttle in any direction as it flies, it will always continue in its 
current orbit at the update.
.s3
The only way to alter the orbital direction is to first
ascend to altitude 127
(the zero-velocity geosynchronous parking orbit), and then 
`\*Qnavigate\*U' in a new direction.  The last direction in which 
you move will become 
the new orbital direction if you then descend to a lower altitude.
.s3
With increased altitude, a shuttle's radar and viewing range increase.
Report accuracy, however, decreases.  Shuttles themselves are visible
only to ground radar (they show up on the map as a '$') and to other
shuttles in nearby orbits.
.s1
LIMITED O2, ORBIT DEGRADATION, AND OTHER INTERESTING STUFF
.s3
Like submerged submarines, shuttles have limited oxygen for the crew.
To replenish oxygen, you must land the shuttle.  In any sector capable of 
building a shuttle, cabin O2 automatically refills completely during
the update.  Aloft, O2 depletes at the same rate as aboard submarines.
.s3
All orbits below 127 degrade somewhat with each update, with low altitude
orbits suffer greater degradation than high altitude orbits.  The only
exception is the parking orbit at altitude 127, which suffers no loss.
Altitude loss in other orbits varies linearly through the following
points: 1 per update at altitude 126; ETU/2 per update at altitude 32
(edge of atmosphere).  Any descent that ends up in the atmosphere 
with a vertical velocity exceeding ETU/2 has catastrophic consequences.
.s3
Shuttles can land only in airfields.  You will be informed if a sector does 
not offer an suitable landing area.
.s3
Shuttles can be loaded, unloaded only while on the ground in airfields.
Once aloft, shuttles cannot be boarded, and can be tended only by another
shuttle in the same orbit (both altitude and direction must match).
.s3
You use the `\*Qnav\*U' command to
move shuttles once they are airborne.  `\*QRadar\*U' and `\*Qlook\*U' range 
increases with altitude, but at the price of decreased resolution.
From the ground, a shuttle in orbit can be seen only by radar. 
.s3
If you wish to move a shuttle while it is on the ground, you can do so
by using the `transport' command.
.s3
See also : build, cargo, fleetadd, navigate, load, lookout, scrap, upgrade,
transport, shuttle

