.TH Command SHOW
.SY "show <OBJECT_TYPE> [build|capabilities|NUKETYPE]"
The show command can be used to find out about construction,
capabilities, and other interesting properties for a variety 
of things.  Since this information is gleaned directly from the 
current Empire data structures, it is guaranteed to be accurate.
.s1
Info can be obtained about bridges, planes, ships, tanks, balloons, spies,
nukes (including blast damage charts), commodities, products, and sector types.
To get information on a particular topic type:
.s1
.EX show <object-type>
.s1
If the object type is an aircraft, ship, nuke or vehicle, a further parameter
is required to indicate whether you wish information about construction or
capabilities.  So, for example:
.s1
.EX show nuke capabilities
.s1
will give something like
.NF
              blst dam lbs tech $
10kt fission     3  80   4  200 $7500
50kt fission     3 100   6  225 $9000
100kt fission    4 120   8  250 $12000
250kt fusion     4 150   4  280 $7500
500kt fusion     5 170   6  295 $9000
1mt fusion       6 190   8  310 $12000
3mt fusion       7 210  10  325 $19000
.s1
You can also use the show command to display nuclear bomb blast profiles.
See \*Qnuke-types\*U for further information.
.s1
Note that you can only generally only get information on objects that you 
are technologically capable of building.  Also note that maintanence costs
reported by `show plane build' and `show ship build' are minimums that
may be exceeded if the vehicle's tech level is greater than your 
country's tech level.
.s1
SECTOR PROPERTIES
.s3
To obtain a list of basic sector properties, use `show sector'.
Among other things, the table indicates base mobility costs (no
highway improvements), relative offense and defense factors, and 
dollar cost per efficiency point gained.  Remember that effective
mobility cost can be dropped to 1.0 by raising a sector's highway
improvements to 100%.
.s1
.EX show sect
.NF
                 des mcst off def $val  $/eff  product
sea                .    0   0   0    0   0.00
mountain           ^  127   2  16    5   1.50
sanctuary          s    0   0  99  127   1.00
wasteland          \    0   0  99    0   1.00
wilderness         -    4   2   2    1   0.50
capitol            c    2   2   4   30   1.50
uranium mine       u    2   2   3   15   5.00  radioactive materials
park               p    2   2   2    5   1.00  happy strollers
defense plant      d    2   2   2    7   2.00  guns
shell industry     i    2   2   2    6   2.00  shells
                 ___ ____ ___ ___ ____  _____  _____________________
                  |    |   |   |    |      |             |
             symbol    |   |   |    |      |      production item
                       |   |   |    |      |
     basic mobility cost   |   |    |      dollar cost per percentage
       (no improvements)   |   |    |      point of efficiency gain
                           |   |    |
          offensive strength   |    forclosure value if sector taken
                               |    as repayment on a defaulted loan
              defensive strength

.FI
.s1
COMMODITY PROPERTIES
.s3
You can obtain a table of commodity properties by using `show commodities'.
The table includes item weights (used for calculating aircraft payloads),
whether or not each item is tradable on the market, and how well each
item is guarded by its owner.
.s1
.EX show com
.NF
                 chr wgt buy sec
civilians          c   1   0   5
military           m   1   0  35
shells             s   1   1  60
guns               g  10   1  60
petrol             p   1   1  50
iron ore           i   1   1   5
dust (gold)        d   5   1  15
                 ___ ___ ___ ___
                  |   |   |   |
             symbol   |   |   how well guarded
                      |   |
            unit weight   buyable/sellable

.FI
.s1
PRODUCT PROPERTIES
.s3
Use `show products' to get a list of the various things that sectors
are able to produce.
.s1
.EX show prod
.NF
                    cost rsrc depl level make constituents
shells                 3             10T  1.0  2l 1h
guns                  30             10T  1.0  1o 5l 10h
petrol                 1                  5.0  1o
iron ore               0  min   0%        1.0
gold dust              0 gmin  20%        1.0
                    ____ ____ ____ _____ ____ ________________
                      |    |    |     |    |            |
            dollar cost    |    |  nat'l   |   amount and type
           per quantity    |    |  level   |  of raw materials
                           |    |  req'd   |          required
                    required    |          |
                    resource    |          production
                                |          unit quantity
                resource depletion rate

.FI
.s1
SHIP CONSTRUCTION
.s1
.EX show ship build
                lcm hcm avail tech  $     maint
raft              2   0     1    0 $50     $30
fishing boat     25  15    12    0 $200    $30
slave ship       60  40    29    0 $500    $30
galleon          50  30    23    0 $500    $30
frigate          50  30    23    5 $600    $30
cargo ship       60  40    29   10 $750    $30
                _______ _____ ____ ______ _____
                   |       |    |      |     |
           construction    |    |      |  maintanence cost (per update)
              materials    |    |      |
                           |    |   construction cost
         available workforce    |
                    required  tech level required

.FI
.s1
NUCLEAR DEVICE CONSTRUCTION
.s1
.EX show nuke build
.NF
              lcm hcm  oil  rad avail tech $
2kt fission    10  10    5   12    10  360 $ 15000
5kt fission    30  30   15   36    29  360 $ 25500
10kt fission   50  50   25   60    48  360 $ 36000
15kt fission   50  50   25   70    50  382 $ 40500
50kt fission   60  60   30   80    59  405 $ 45000
              _________________ _____ ____ _______
                      |            |    |      |
         construction materials    |    |  construction cost
                                   |    |
                 available workforce    tech level
                            required    required

.FI
.s1
PREDICTING DAMAGE CAUSED BY NUCLEAR DEVICES
.s1
If you have a particular target in mind before you build a nuclear
device, you can use `show blast <devicetype>' to help you determine
what type of device you should build.  The command will chart for
both ground and airbursts the amount of damage that will be done
at various distances from the blast point.
.s1
.EX show blast 5mt
.NF
                  5mt fusion Bomb Blast Profile

     GROUND   % DAMAGE          1     AIR      % DAMAGE          1
     BURST    1 2 3 4 5 6 7 8 9 0     BURST    1 2 3 4 5 6 7 8 9 0
     dam rad _0_0_0_0_0_0_0_0_0_0     dam rad _0_0_0_0_0_0_0_0_0_0
     190  0 |@@@@@@@@@@@@@@@@@@@@     143  0 |@@@@@@@@@@@@@@@@@@@@
     168  1 |@@@@@@@@@@@@@@@@@@@@     111  1 |@@@@@@@@@@@@@@@@@@@@
     115  2 |@@@@@@@@@@@@@@@@@@@@      86  2 |@@@@@@@@@@@@@@@@@
      62  3 |@@@@@@@@@@@@              67  3 |@@@@@@@@@@@@@
      26  4 |@@@@@                     52  4 |@@@@@@@@@@
       8  5 |@                         41  5 |@@@@@@@@
     ___ ___ ____________________      32  6 |@@@@@@
      |   |           |                25  7 |@@@@@
percent   |     damage graph           19  8 |@@@
 damage   |                            15  9 |@@@
          distance away from           12 10 |@@
          point of blast (ground        9 11 |@
          zero)                         7 12 |@
                                        6 13 |@

.FI
.s3
See also : spy, ship-types, nuke-types, plane-types, tank-types, balloon-types
