.TH Command SDUMP
.SY "sdump <SPIES>"
The `\*Qsdump\*U' command outputs all available information on
some or all of your spies.
`\*QSdump\*U' gathers all of the information that you normally obtain
using `spy', et al, and outputs it in a concise,
easy-to-parse format.  Each spy's information 
is printed on one very long line, with fields separated by single spaces.
.s1
This command is designed to be used for input to an empire tool
such as \*Qve\*U.
.s1
In the syntax of the `sdump' command:
.NF

<SPIES>   is the list of spies for which you want
          information (see \*Qinfo syntax\*U).

.FI
A typical usage might be:
.s1
.EX sdump 1/2/3
.NF
Mon Aug 24 10:02:08 1992
   DUMP SPIES
.FI
.s1
(Although there appear to be more, there are actually only seven lines 
of output: 3 header lines, 3 data lines, and a summary line.)
The first few lines of output consist of the current time and date,
a title line explaining what is being dumped, and a header line
that identifies each of the fields for the data lines that will
follow.  All subsequent lines that do not begin with whitespace
contain vehicle data, one line per vehicle.
.s1
The rules for parsing the field label header are data lines are simple.
Whitespace in the field label header separates the data labels.
Whitespace in the data lines separates the data fields.
.s1
All numeric value fields begin with a digit if positive, or a
minus sign followed by digits if negative.  Any field that starts 
with a double quote defines a string; such fields end with another 
double quote.  A double quote followed immediately by another double
quote defines an empty (null) string.  All single-character fields
and will contain an underscore if the character is to be interpreted 
as a blank.
.s1
.NF
  field label  type      description
  ___________  ________  ________________________________________________

  own          number    spy's country number (reported to DEITYs only)

  id           number    spy id

  type         string    spy type ("agent", etc)

  name         string    spy's name ("Max", "007", etc)

  x y          numbers   current coordinates

  eff          number    current efficiency

  mob          number    current mobility

  ring         char      spy ring id

  tech         number    spy's tech level

  edu          number    spy's education level

  hap          number    spy's happiness level

  age          number    spy's age

  acc          number    spy's accuracy factor

  pilot        number    spy's pilot tech rating

  ship         number    -1 if spy is NOT being transported aboard 
                         a ship or vehicle; otherwise, this is the ID 
                         of the ship doing the transporting

  c_amt ...    number    amount of civs spy is carrying, etc

.FI
.s3
See also : dump, vdump, pdump, rdump, odump
