.TH Command PDUMP
.SY "pdump <PLANES>"
The `\*Qpdump\*U' command outputs all available information on
some or all of the planes, missiles, and satellites
that you own. 
`\*QPdump\*U' gathers all of the information that you normally obtain
using `plane', et al, and outputs it in a concise,
easy-to-parse format.  Each aircraft's information 
is printed on one very long line, with fields separated by single spaces.
.s1
This command is designed to be used for input to an empire tool
such as \*Qve\*U.
.s1
In the syntax of the `pdump' command:
.NF

<PLANES>   is the list of aircraft for which you want
           information (see \*Qinfo syntax\*U).

.FI
A typical usage might be:
.s1
.EX pdump 1/2/3
.NF
Mon Aug 24 10:02:08 1992
   DUMP PLANES
own id type x y eff mob wing tech range att def harden nuketype nukeamt 
gdr armed launched boxed longrange alt orbit ship
6 1 "triplane" 24 16 100 127 _ 41 5 2 1 0 "" 0 0 0 0 0 0 0 "" -1
6 2 "fighter 1" 24 30 100 127 _ 41 7 3 2 0 "" 0 0 0 0 0 0 0 "" -1
6 3 "fighter 1" 20 28 100 127 _ 41 7 3 2 0 "" 0 0 0 0 0 0 0 "" -1
    3 planes
.FI
.s1
(Although there appear to be more, there are actually only seven lines 
of output: 3 header lines, 3 data lines, and a summary line.)
The first few lines of output consist of the current time and date,
a title line explaining what is being dumped, and a header line
that identifies each of the fields for the data lines that will
follow.  All subsequent lines that do not begin with whitespace
contain vehicle data, one line per vehicle.
.s1
The rules for parsing the field label header are data lines are simple.
Whitespace in the field label header separates the data labels.
Whitespace in the data lines separates the data fields.
.s1
All numeric value fields begin with a digit if positive, or a
minus sign followed by digits if negative.  Any field that starts 
with a double quote defines a string; such fields end with another 
double quote.  A double quote followed immediately by another double
quote defines an empty (null) string.  All single-character fields
and will contain an underscore if the character is to be interpreted 
as a blank.
.s1
.NF
  field label  type      description
  ___________  ________  ________________________________________________

  own          number    aircraft owner's country number (reported to 
                         DEITYs only)

  id           number    aircraft id

  type         string    plane type ("triplane", "landsat 1", etc)

  x y          numbers   current coordinates

  eff          number    current efficiency

  mob          number    current mobility

  wing         char      wing id

  tech         number    plane's tech level

  range        number    maximum flying range

  att          number    attack rating

  def          number    defense rating

  harden       number    hardening factor  

  nuketype     name      type of warhead ("1kt neutron", etc)

  nukeamt      number    number of warheads aboard

  gdr          number    global defense radius (for ABMs)

  armed        number    0/1 flag showing if plane is explosive-armed

  launched     number    0/1 flag showing if satellite has launched

  boxed        number    0/1 flag showing if plane is crated

  longrange    number    0/1 flag showing if plane has longrange tanks

  alt          number    satellite altitude

  orbit        string    satellite orbit (e.g., "18j/72")   

  ship         number    -1 if plane is NOT being transported aboard 
                         a ship or vehicle; otherwise, this is the ID 
                         of the ship doing the transporting
.FI
.s3
See also : dump, vdump, sdump, rdump, odump
