.TH Command ORDER
.SY "order <VEHICLE/FLEET> [c|r|s|e|dest1 [[com1] [[dest2] [com2]]]]"
You use the \*Qorder\*U command to give sailing orders to ships and
other vehicles.  At each update, vehicles moving under orders 
\*Qautonavigate\*U toward a specific destination sector.  Telegrams 
notify you of arrivals.  (Although all of the following examples deal
with ships, you can similarly use \*Qorder\*U with any type of
ship, tank, train, or balloon.)
.s3
Any ship can be given sailing orders, but in order to move during the
update a ship must have at least one crew (which may be civilian or military,
but not an uncompensated worker).
.EX order <SHIP/FLEET>
\*QOrder\*U, without any parameters, shows current sailing orders.
Ships that have no orders are not listed.  The report indicates:
.NF
     shp#          ship number
     ship type     type of ship (cargo ship, destroyer, etc)
     x,y           ship's current position
     flt           fleet association
     cnv           convoy association
     destination   destination sector
     stdby         indicates that ship is on standby

[13:248] Command : ord *
shp#     ship type       x,y    flt cnv   dest
   8 fishing boat      -18,42        A  -33,-63    sby
  23 schooner          -32,38    c   A  -33,-63    sby
2 ship(s)
.FI
.EX order <SHIP/FLEET> \*Qc[ancel]\*U
.s1
The \*Qcancel\*U option causes a ship to stop autonavigating and its
current sailing orders to be cancelled.  Cancelled orders cannot be resumed,
and the ship will no longer appear in the orders list.
.s1
.EX order <SHIP/FLEET> \*Qs[tandby]\*U
.s1
The \*Qstandby\*U option causes a ship to stop autonavigating, but maintains
its orders (so that it shows up in the orders list).
.s1
.EX order <SHIP/FLEET> \*Qr[esume]\*U
.s1
The \*Qresume\*U option countermands a \*Qstandby\*U order, causing
autonavigation to resume.
.s1
.EX order <SHIP/FLEET> \*Qe[ta]\*U
.s1
The \*Qeta\*U option instructs the game to compute the current shortest
route to the destination and report to you the distance (in sectors) 
and the estimated time of arrival (real time and date).
.s1
.EX order <SHIP/FLEET> \*Q<dest>\*U
.s1
Specifying a destination orders a ship to autonavigate until
the destination is reached.  When the ship arrives, or if the trip is
not possible, you will be notified by telegram, and the ship's orders
will be cancelled.
.s1
At update time, the most direct path from ship to destination
is calculated, and each ship is then autonavigated along that path to
the best of its mobility.  The path is calculated from what the player
knows of the world (what you can see using the \*Qbmap\*U command).
Open sea, bridges, and unexplored regions of the world
are considered to be navigable; harbors are not.
The specific terrain restrictions for each type of autonavable 
vehicle are:
.NF
  vehicle type         can pass through these sector types
ship                            . x =
train                           w x = # +
tank                all except  . ^ /
tank (atv)          all except  . /
balloon             all except  ^
.FI
.s1
Radar operates continuously as the ship moves along the path, constantly
adding sector information to the known world map.  When a ship encounters
an obstacle that was previously unknown, it will, if it still has any
mobility, use the newly-gained information to find a new route and try
moving again.
.s1
Autonav movement is performed before mobility is increased.
This insures that after the update, ships with orders will still
have some mobility so that you can always manually navigate
to some extent.
.s3
See also : autonav, bmap, nav, ship
