.TH Command NAVIGATE
.SY "navigate <SHIP/TANK/BALLOON/TRAIN/FLEET> <ROUTE>"
The navigate command is the \*Qmove\*U command applied to the ships
at sea, tanks and trains on land, and balloons in the air.  You can use 
it to control any one vehicle, a combination of vehicles, or an entire fleet.
.s3
A vehicle (ship, tank, train, or balloon)  must have at least one crew
(which may be civilian or military, but not an uncompensated worker)
to be navigated.
If you are moving a fleet and the flagship stops, the fleet stops;
(the lowest numbered vehicle is always considered the flagship).
.s1
The program will prompt with the mobility of the flagship,
the minimum mobility value for the fleet, and the current sector
coordinates in the form:
.NF
<57.0:23.5: -6,4>
.FI
which means the flagship has 57 mobility units,
some other ship in the fleet has 23.5 mobility units and
the flagship is in sector -6,4.
You may indicate the direction you would like the fleet to move
by typing a string of letters consisting of any combination of the
following:
.NF
y  for up-left
u  for up-right               y    u
g  for left                    \\\\  /
j  for right               g  --  --  j
b  for down-left               /  \\\\
n  for down-right             b    n
v  for view
h  for end of movement
r  for radar
l  for lookout
p  for petrol report
.FI
The \*Qpetrol\*U option reports the amount of petrol aboard.
This is handy when navigating vehicles that burn petrol.
.s3
The \*Qview\*U option reports where you are and costs no mobility.
(For ships, this really only tells you whether or not you're in a harbor.)
.s3
The \*Qradar\*U option internally invokes the \*Qradar\*U command.
You can supply additional parameters on the same line as the `r',
or you can specify `.' to radar from the flagship.
.s3
Similarly, the \*Qlookout\*U option internally invokes the 
\*Qlookout\*U command.
You can supply additional parameters on the same line as the 'l',
or you can specify `.' to lookout from the flagship.
.s3
Since the <ROUTE> can be specified in the command line,
simple movements are often typed as a single line, such as:
.EX nav 19 jjjh
.s3
Or some movements may be done partly on the command line and partly
interactively:
.EX nav 18 jj
.NF
<112.7:112.7: -4, -2> v
patrol boat #18 on open sea @ -3,-2
<112.7:112.7: -4, -2> gh
patrol boat #18 stopped at -6,-2
.FI
.s1
Some typical movement costs for ships are:
.NF

ship         25% tech factor   50% tech factor   100% tech factor
type           cost/sector       cost/sector       cost/sector
------            ----              ----              ----
patrol boat        7.68              6.4              4.8
fishing boat      25.6              21.33            16.0
minesweep         19.2              16.0             12.0
destroyer         10.96              9.13             6.85
submarine         15.36             12.8              9.6
tender            12.8              10.67             8.0
heavy cruiser     12.8              10.67             8.0
cargo ship        19.2              16.0             12.0
aircraft carrier  15.36             12.8              9.6
battleship        15.36             12.8              9.6

.FI
.s1
Movements costs for submarines running submerged are 2.5 times 
the normal surface rate.
.s1
Vehicles that burn petrol consume petrol at different rates,
depending on the ship or vehicle type, its efficiency,
and the tech level at which it was built.  Balloons are generally
at the mercy of the wind and do not require petrol; similarly,
certain classes of ships and other vehicles are powered by oars, 
sails, or nuclear power and also do not require petrol.
.s1
Nuclear vessels require rads for propulsion.  The speed at which
the ship can move depends on the number of rads it is carrying;
full speed requires a full load of rads (as listed by `\*Qshow 
ship cap\*U'), while a partial load reduces speed proportionally.
Unlike petrol, rads do not deplete; the ship requires rads to
move, but does not consume them.
.s1
You cannot navigate a ship into a trade center that is less than two 
percent efficient.  You can, however, enter inefficient harbors, although
if the efficiency is less than two percent, you will only be able to 
load and unload people (no commodities).
.s1
Moving a ship through a sector that has been mined
introduces a 5% chance per mine (cumulative) that you will be damaged
by \*Qdetecting\*U one of the little cuties.
Minesweeps can remove up to five mines per pass through a
sector (indicated by the message \*QSweep...\*U).
.s3
See also : mine, ship-types, tank-types, balloon-types, train-types
