.de AB
.in 0.3i
.ti -0.3i
..
.TH Concept "Command Condition Items"
.s1
When specifying commands, you can often "filter" the objects
to which the command is applied by explicitly disqualifying
those objects which do not meet certain conditions.  You generally
specify conditions by including on the command line a question mark,
immediately followed by one or more conditional expressions made
up of condition items and relational operators.  For example,
.s1
.EX cens #1 ?civ>50&mil=0
.s1
asks for a census of those sectors in realm 1 that meet the
conditions of having (1) more than 50 civilians, and (2) no military.
Another example might be,
.s1
.EX ship w ?mil>civ&auto=0&roff=1&mob>50
.s1
in which we're asking for a list of all ships in fleet w that
have more mil than civs aboard (mil>civ), do not have sailing orders
(auto=0), have their aircraft autotracking radar turned off (roff=1),
and still have more than 50 mobility.
.s1
A complete list of all condition items follows:
.s1
SECTOR CONDITION ITEMS
.s1
.in +\w'uncompensated workers\0\0'u
.L owner
owner of the sector
.L oldown
original owner of captured sector
.L des
sector designation
.L dx
distribution x coordinate
.L dy
distribution y coordinate
.L newtype
new sector designation
.L efficiency
efficiency
.L work
work/loyalty
.L mobility
mobility units
.L minerals
sector contents
.L ocontent
oil content
.L pcontent
oil content
.L fertility
food fertility
.L "uranium content"
uranium
.L civilians
civilians
.L military
military
.L uw
uncompensated workers
.L "uncompensated workers"
uncompensated workers
.L shells
number of shells
.L guns
number of guns
.L petroleum
amount of petrol
.L "iron ore"
amount of iron ore
.L "dust (gold)"
amount of gold dust
.L "bars of gold"
number of gold bars
.L food
quantity of food
.L oil
amount of crude oil
.L rad
amount of radioactive materials
.L lcm
light construction materials
.L hcm
heavy construction materials
.L pstage
plague stage (0-4)
.L "roads (or highways)"
road improvement level (0-100)
.L "rails (or railroads)"
rail improvement level (0-100)
.L bunker
bunker size (0-255)
.L "geography (or geology)"
underlying geologic sector designation
.L head
sector has a bridge head (1=yes, 0=no)
.L hold
sector is on production hold (1=yes, 0=no)
.L roff
radar tracking is turned off (1=yes, 0=no)
.L rident
radar tracks only identifiable aircraft (1=yes, 0=no)
.L rhostile
radar tracks only hostile aircraft (1=yes, 0=no)
.L starve
sector had starvation at last update (1=yes, 0=no)
.L distpath 
distribution path
.L s_delivery
product delivery routes (shells)
.L g_delivery
gun delivery routes
.L p_delivery
petroleum delivery routes
.L i_delivery
iron ore delivery routes
.L d_delivery
gold dust delivery routes
.L b_delivery
gold bar delivery routes
.L f_delivery
food delivery routes
.L o_delivery
oil delivery routes
.L r_delivery
radioactive material delivery routes
.L l_delivery
lcm delivery routes
.L h_delivery
hcm delivery routes
.L u_delivery
uncompensated worker delivery routes
.L s_dist
product distribution thresholds (shells)
.L g_dist
guns distribution thresholds
.L p_dist
petroleum distribution thresholds
.L i_dist
iron ore distribution thresholds
.L d_dist
gold dust distribution thresholds
.L b_dist
gold bar distribution thresholds
.L f_dist
food distribution thresholds
.L o_dist
oil distribution thresholds
.L r_dist
radioactive material distribution thresholds
.L l_dist
lcm distribution thresholds
.L h_dist
hcm distribution thresholds
.L u_dist
uncompensated worker distribution thresholds
.in -\w'uncompensated workers\0\0'u
.s1
SHIP/VEHICLE CONDITION ITEMS
.s1
.in +\w'uncompensated workers\0\0'u
.L owner
ship owner
.L efficiency
ship's efficiency (0-100)
.L mobility
ship's mobility (0-127)
.L tech
ship's tech level
.L fleet
fleet identifier
.L nplane
number of planes aboard
.L ntank
number of tanks aboard
.L autonav
ship is sailing under orders (1=yes, 0=no)
.L "aboard (or carrier, or transport)"
ID of ship transporting this vehicle
.L depth
current submarine depth (0=surf, 1=peri, 2=deep)
.L altitude
current balloon altitude (0=ground, 1=low, 2=high)
.L "air (or gas, or volume)"
amount of air/gas remaining
.L convoy
convoy identifier
.L camouflagued
ship is camouflaged (1=yes, 0=no)
.L roff
radar tracking is turned off (1=yes, 0=no)
.L rident
radar tracks only identifiable aircraft (1=yes, 0=no)
.L rhostile
radar tracks only hostile aircraft (1=yes, 0=no)
.in -\w'uncompensated workers\0\0'u
.s1
AIRCRAFT CONDITION ITEMS
.s1
.in +\w'uncompensated workers\0\0'u
.L owner
aircraft's owner
.L efficiency
aircraft's efficency
.L mobility
aircraft's mobility
.L tech
aircraft's tech level
.L wing
wing identifier
.L range
maximum flight range
.L "ship (or aboard, or carrier)"
ID of ship/vehicle transporting this aircraft
.L attack
aircraft's attack rating
.L defend
aircraft's defense rating
.L harden
aircraft's hardening factor
.L nukeamt
number of nuclear warheads aboard
.L gdr
ABM global defense radius
.L idr
intercept defense radius
.in -\w'uncompensated workers\0\0'u
.s1
SPY CONDITION ITEMS
.s1
.in +\w'uncompensated workers\0\0'u
.L owner
spy's owner
.L efficiency
spy's efficiency
.L mobility
spy's mobility
.L tech
spy's tech level
.L ship (or aboard, or carrier)
ID of ship/vehicle transporting spy
.L education
spy's education level
.L happiness
spy's happiness level
.L age
spy's age
.L pilot
spy's pilot tech level
.in -\w'uncompensated workers\0\0'u
.s3
See also : realm, command

