.TH Command BUILD
.SY "build [ship|tank|balloon|plane|nuke|bridge] <SECTS> [item-type|direction] <TECH>"
The build command is used to specify the types of vessels, vehicles,
aircraft, nukes, and bridges you wish to construct.
.s1
.NF
     Sector type        What can be built
     ----------------   -------------------------------
     h - Harbors        Ships and balloons 
     * - Airports       Aircraft, missiles and balloons
     z - Tank Factory   Tanks, vehicles, and trains
     n - Nuke Centers   Nuclear devices
     # - Bridge Heads   Bridges
.FI
.s3
The ability to build things is based on several factors:
labor force, light production units, heavy production units,
oil units, radioactive material units, available cash,
and technology level.
The quantities or levels required vary with the object being built.
.s1
HARBOR SECTORS
.s3
The ship choices range from patrol boats through battleships and yachts
to nuclear vessels.  For a brief table indicating the production costs 
of the different ship types respond with \*Q?\*U.  For a table describing 
the costs and capabilities of the different ship types see 
\*Qinfo ship-types\*U.
.s3
The labor force required to build a particular ship type is equal to the 
ship's tonnage, which is the lcm cost plus twice the hcm cost.  Labor force 
is defined as the number of civilians multiplied by the work percentage,
plus the number of uncompensated workers, plus two-fifths the number of military.
.s1
Only the first letter of the ship type is required to indicate your choice.
.s1
Note that ships first appear at 20% efficiency and a 19% efficient ship
will not float (i.e., it sinks).  As the ships' crew and harbor personnel 
work on them, their efficiency grows to 100%.  The workforce needed to
increase a ship's efficiency by one percent per time unit is equal to its 
tonnage.
.s1
Harbor workforce is divided up among those ships needing work in proportion 
to their tonnages relative to the total, up to a workforce limit of two times 
the tonnage for any ship.  For fastest efficiency growth, put full crews on 
your newly built ships and leave them in harbor until they reach 100%.
.s1
Ships at sea have only their crews to make repairs.  Crew members each supply 
the same amount of work, whether civilian, military, or uncompensated worker.
A small crew on a large ship may not be able to make any repairs at all.
(Moral: keep your ships fully crewed in anticipation of future damage.)
.s1
Entropy acts on ships at the rate of one efficiency point every four time units.
Ships at sea without enough crew to fight entropy effects will gradually rust,
take on water, and sink.
.s1
TANK FARM SECTORS
.s3
The tank choices start with a small 4-man tank and range up through 
more exotic vehicles such as battletanks, armored carriers, and rocket 
launchers.  For a complete table describing construction costs and
capabilities for various armored vehicles, see \*Qinfo tank-types\*U.
.s3
Tank efficiency, repair, and construction force characteristics follow 
the same rules as for ships (construction labor force = lcm + 2*hcm; 
newly built tanks are 20% efficient; etc).  Also like ships, entropy
will takes its toll on rusting, poorly manned and neglected vehicles, 
eventually causing them to fall apart.
.s3
For fastest tank efficiency growth, keep your tanks fully manned and leave
them in a tank farm until efficiency reaches 100%.
.s1
AIRPORT SECTORS
.s3
The choices range from low tech \*Qfighter 1\*U planes
up to and including super-long range \*Qjet hvy bomber\*Us
and \*Qicbm 3\*Us.
For a brief table indicating the production costs of the
different plane types respond with \*Q?\*U.
For a table describing the costs and capabilities of the
different plane types see \*Qinfo plane-types\*U.
.s3
Note that planes first appear at 10% efficiency.
As time passes, and as long as there are \*Qavailable work units\*U in the
airport at which the planes reside (to work on the planes), they grow to
100% efficiency.
.s1
NUCLEAR PLANT SECTORS
.s3
If you type
.EX build 6,2
and 6,2 is a nuclear plant that has enough hcm
(heavy construction materials),
lcm (light construction materials), oil, and radioactive material,
the workforce in the sector is large enough (as defined above),
you have enough money, and your technology level is high enough,
then the program will construct a new nuclear device of the type
requested, and add it to the current stockpile in that sector.
.s1
BRIDGE HEAD SECTORS
.s3
You can extend a bridge off of any sector, providing the 
sector contains an appropriate bridge head.  You create
bridge heads by either devoting the entire sector to that
purpose (by designating it `#'), or by explicitly constructing
a bridge head into the infrastructure of an existing sector.
.s1
Constructed Bridge Heads in Any Sector
.s3
Infrastucture bridge heads let you extend bridges off of 
almost any type of sector.  
Construction of a bridge head into the infrastructure of any 
sector generally only requires a fraction of the materials, workforce, 
and money that you would normally spend to construct a single bridge span. 
`\*QShow bridge build\*U' will show you exact bridge span and bridge 
head construction costs.  The command syntax to build a bridge head
is the same as for a bridge span, except that you need not specify
a direction:
.EX build bridge 2,2
If 2,2 has sufficient workforce, money, and materials, and if it
is not a dedicated bridge head, and if it does not already contain a 
constructed bridge head, one will be constructed for you.
(You can use the `\*mobility\*' command to see infrastructure
improvements; constructed bridge heads are be noted in the
`bhead' column.)
.s3
Once built, a constructed bridge head will remain in existance
until damage causes the sector's efficiency to drop below 20%.
Sector redesignation will not affect the bridge head.
.s1
Dedicated Bridge Head Sectors
.s3
If you type
.EX build bridge 2,2
and 2,2 either is or contains a bridge head, an attempt will be
made to construct a bridge span.  If the sector has enough hcms
(heavy construction materials), the workforce is large enough 
(as defined above), you have enough money, and your 
technology level is high enough, the program will then respond:
.NF
Bridge head at 2,2; build span in what direction? j
Bridge span built over 4,2
.FI
To find out the required amounts of materials, workforce, and money
try to build in an underdeveloped bridge head sector
and the program will tell you the current amounts
(may be changed by the local deity).
.s1
If the optional \*Q(direction)\*U argument is used in the command line
the program will try to build
a span in the specified direction from all bridge heads
in the given area that have the necessary heavy production units.
.s1
BALLOONS
.s3
The balloon choices are fairly minimal, ranging from the simplest 2-man
hot air balloon to the relatively large airship.  For a complete table 
describing construction costs and capabilities for various balloons,
see \*Qinfo balloon-types\*U.
.s3
Balloons can be built in either harbors or airfields, and follow the
same efficiency, repair, and construction force characteristics used
by ships and tanks (construction labor force = lcm + 2*hcm; newly built 
balloons are 20% efficient; etc).
.s1
See also : launch, fly, nuke
