.TH Concept Autonavigation
In a very short while after acquiring ships the effort of moving ships after
every update gets very boring.  And the more ships you have, the more work
it is.  Hence the concept of autonavigation.  Like any self-respecting
dictator, you don't personally drive your ships around (except when you want
to) -- instead you command you ship captains to take their vessels to a
specified destination.  This is done via the \*Qorder\*U command.
.s1
Each ship can be ordered to proceed to a destination.  During each update,
the ship will move as far as possible toward its destination, stopping
when it runs out of mobility or when it is unable to proceed because it has
run into previously unknown obstructions.  Note that this movement is done
before mobility is accumlated, so that after the update is complete the ship
will have some mobility remaining.
.s1
The autonavigation capability is dependent upon the per-country map database
accessed via the \*Qbmap\*U command.  If you order a vessel to a destination
that causes it to cross a previously unexplored area, the ship will attempt
to cross that area as if it were water.  One of the features of the bmap
functionality is that when a ship is navigated, it automatically uses its
radar to see the local sectors (much like real life).  This sector information
is added to the per country map database.  Thus upon running into a previously
unknown obstruction, that information is added to the map database and on the
next update, a new path to the destination will be calculated which avoids
the obstruction.  This process applied iteratively means that a ships will
eventually find its way around any obstruction, provided that a path exists.
In reality, this is a limit to this process.  In order to limit the processing
that is done to find a path to the destination, the internal path string is
limited to XX characters.
.s1
Autonavigation is not limited to just ships.  You can also order tanks, 
trains, and balloons to find their way to specific destinations.
The route taken by each vehicle type adheres to certain terrain restrictions:
.NF
  vehicle type         can pass through these sector types
ship                            . x =
train                           w x = # +
tank                all except  . ^ /
tank (atv)          all except  . /
balloon             all except  ^
.FI
.s1
NOTE: The following feature is not available yet.
.s1
The other capability of the autonav function is autotrading.  By specifying
two destinations and two commodities, s ship will move back and forth between
the two destination loading and unloading the appropriate commodities.
.s3
See also : navigate, order, ship-types, tank-types, balloon-types, train-types
