/*
 * trade.h
 *
 * defs for "set/trade" commands
 *
 * from PSL Empire, 1985
 * $Revision: 1.1 $ $Date: 93/06/29 08:58:26 $
 */

struct trdstr {
	char	trd_type;
	natid	trd_owner;
	short	trd_unitid;
	long	trd_price;
};

struct genstr {
	coord	trg_x;
	coord	trg_y;
	natid	trg_own;
};

union trdgenstr {
	struct	genstr gen;
	struct	nukstr nuk;
	struct	plnstr pln;
	struct	shpstr shp;
};

char	*trade_nameof();

#define gettrade(n, p) \
	ef_nbread(EF_TRADE, n, (caddr_t)p)
#define puttrade(n, p) \
	ef_nbwrite(EF_TRADE, n, (caddr_t)p)
#define gettradep(n) \
	(struct trdstr *) ef_ptr(EF_TRADE, n)
