/*
**  spy.h
**
**  Defines spy types
**
**  7/91 Bill Frolik
*/

#ifndef HAVE_NSC
#include "nsc.h"
#endif

#define MAXSPYV 2

struct spystr {
	coord spy_x;		/* plane x-y */
	coord spy_y;
	natid spy_own;		/* owning country */
	char  spy_type;		/* fighter, bomber, etc */
	char  spy_effic;	/* actually "training" */
	char  spy_mobil;	/* mobility */
	short spy_sell;		/* index into trade file */
	short spy_tech;		/* spy's tech level */
	short spy_uid;		/* spy unit id */
	char  spy_ring;		/* spy ring */
	char spy_name[NS_NSIZE];/* spy's name */
	natid spy_down;		/* "doubleagent" owner */
	short spy_ship;		/* pointer to ship he's aboard */
	short spy_edu;		/* spy's education level */
	short spy_hap;		/* spy's happiness level */
	short spy_age;		/* length of service (etus) */
	short spy_plntech;      /* can pilot planes at & below this tech */
	u_char spy_spare1;
	u_char spy_spare2;
	u_char spy_spare3;
	char  spy_flags;	/* state of the spy */
	char  spy_nv;		/* current number of variables */
	u_char spy_vtype[MAXSPYV];
	u_short	spy_vamt[MAXSPYV];
};

struct spchrstr {
	char *sp_name;		/* plane unit name */
	int sp_lcm;		/* costs to build */
	int sp_hcm; 
	int sp_bar;
	int sp_acc;		/* work accuracy (0=ideal) */
	int sp_cost;		   
	int sp_tech;
	int sp_flags;		/* description of capability */
};

#define S_L     bit(0)  /* FEARLESS LEADER */
#define S_B	bit(1)	/* bomber */
#define S_I	bit(2)	/* informant */
#define S_R     bit(3)  /* rebel (can agitate/coup) */
#define S_A	bit(4)  /* assassin */

#define getspy(n, p)    ef_nbread(EF_SPY, n, (caddr_t)p)

#define putspy(n, p) 	ef_nbwrite(EF_SPY, n, (caddr_t)p)

#define getspyp(n) 	(struct spystr *) ef_ptr(EF_SPY, n)

extern  struct spchrstr spchr[];
extern	int spy_maxno;
