/*
 * plane.h
 *
 * defines and plane types
 *
 * Dave Pare, 1986
 * $Revision: 1.1 $ $Date: 93/06/29 08:58:19 $
 */

#include "queue.h"
#include "equip.h"

#define PLN_MAXDEF	50
#define MAXPLOADS	5	/* Max number of different payload items */

#define	P_OK		0
#define P_FIRED		1
#define P_DEL		2

#define CRUISE_FAIL	85 	/* eff at which cruise missile fails to fly */
#define CRUISE_KILL	50 	/* eff at which cruise missile destructs */


/* ________________________________________________________________
**|                                                                |
**| Some routines assume that from pln_x to pln_wing remains       |
**| exactly equivalent with shp_x to shp_fleet                     |
**|________________________________________________________________|
*/

struct plnstr {
	coord pln_x;		/* plane x-y */
	coord pln_y;
	natid pln_own;		/* owning country */
	char pln_type;		/* fighter, bomber, etc */
	char pln_effic;		/* actually "training" */
	char pln_mobil;		/* mobility */
	short pln_sell;		/* index into trade file */
	short pln_tech;		/* plane's tech level */
	short pln_uid;		/* plane unit id */
	char pln_wing;		/* like fleet */
	u_char pln_range;	/* total distance, not radius */
	short pln_ship;		/* pointer to carrier */
	char pln_att;		/* plane air-air attack value */
	char pln_def;		/* plane air-air defense value */
	char pln_harden;	/* for missiles */
	char pln_nuketype;	/* type of nuclear armament (if any) */
	char pln_nukeamt;	/* # of nukes */
	char pln_gdr;		/* ABM global defense range */
	coord pln_fsx;		/* Failsafe autolaunch target x-y */
	coord pln_fsy;		/* If bogus coords, failsafe not set */
	short pln_flags;	/* State of the plane */
	u_char pln_alt;		/* Satellite altitude */
        u_char pln_idr;         /* Intercept defense range */
        char spare1;            /* spare */
        char spare2;            /* spare */
        char spare3;            /* spare */
        char spare4;            /* spare */
};

/* pln_flags bits */
#define PLB_ORBITDIR	0	/* Bits 0,1,2: Orbit direction        */
#define PLB_ARMED	3	/* Bit 3: Explosive-armed satellite   */
#define	PLB_LAUNCHED	5	/* Bit 5: A satellite that's in orbit */
#define PLB_BOXED	6	/* Bit 6: Aircraft is disassembled    */
#define PLB_LONGRANGE	7       /* Bit 7: Has long range fuel tanks   */
#define PLB_COVERED	8	/* Bit 8: Is camouflaged              */

/* pln_flags masks */
#define PLN_ORBITDIR	0x07	/* Bits 0,1,2: Orbit direction        */
#define PLN_ARMED	bit(PLB_ARMED)
#define	PLN_LAUNCHED	bit(PLB_LAUNCHED)
#define PLN_BOXED	bit(PLB_BOXED)
#define PLN_LONGRANGE	bit(PLB_LONGRANGE)
#define PLN_COVERED	bit(PLB_COVERED)

struct plchrstr {
	char *pl_name;		/* plane unit name */
	int pl_lcm;		/* costs to build */
	int pl_hcm;
	int pl_wood;
	int pl_cost;
	int pl_tech;		/* tech needed to build */
	int pl_acc;		/* bombing accuracy (higher the better) */
	int pl_load;		/* bomb load, also for carrying cargo */
	int pl_att;		/* air-air attack/defense strengths */
	int pl_def;
	int pl_range;		/* how many sectors it can fly */
	int pl_crew;		/* number of mil to crew it */
	int pl_fuel;		/* fuel consumption */
	int pl_speed;		/* speed rating (mph) */
	int pl_fullrangemob;	/* mob burned for full range flight */
	int pl_maxalt;		/* max flight altitude */
	int pl_flags;		/* description of capability */
        short pl_req_load;      /* requirements to load & unload (NYI) */
        short pl_req_fly;       /* requirements to launch & land (NYI) */
};

#define P_B	bit(0)	/* bombing factor only for bombing */
#define P_T	bit(1)	/* tactical bombing ability */
#define P_F	bit(2)	/* interceptor/escort */
#define P_C	bit(3)	/* bombing factor for transport only */
#define P_V	bit(4)	/* vtol ability (planes and helicopters) */
#define P_M	bit(5)	/* missile, used only once, can't be intercepted */
#define P_L	bit(6)	/* light plane, lands on carriers */
#define P_S	bit(7)	/* Spy ability */
#define P_I	bit(8)	/* Imaging ability (advanced spying) */
#define P_O	bit(9)	/* Orbital ability (a satellite) */
#define P_X	bit(10)	/* Stealth ability */
#define P_H     bit(11) /* Helicopter */
#define P_U     bit(12) /* Sub locating ability */
#define P_E     bit(13) /* Enhanced functionality */
#define P_MS    bit(14) /* Mine sweep ability */
#define P_spare	bit(15) /* --unused-- */
#define P_J     0x10000 /* Jet aircraft */
#define P_ABM (P_M+P_E) /* Anti-ballistic missile */
#define PM_R	bit(0)  /* Recon mission */

struct pldstr {
    unsigned char candrop;	/* FLAG: Payload is droppable */
    short item;			/* Payload item */
    short amt;			/* Amount being carried */
};

struct plist {
	struct qelem queue;		/* list of planes */
	struct plchrstr *pcp;		/* pointer to desc of plane */
	struct plnstr plane;		/* struct plane */
	struct pldstr payload[MAXPLOADS];/*payload list */
        struct spystr *spy;             /* spy aboard */
	int misc;			/* misc variable */
	int state;			/* state of plane */
	int kamikaze;			/* kamikaze target id */
};

#define getplane(n, p) \
	ef_nbread(EF_PLANE, n, (caddr_t)p)
#define putplane(n, p) \
	ef_nbwrite(EF_PLANE, n, (caddr_t)p)
#define getplanep(n) \
	(struct plnstr *) ef_ptr(EF_PLANE, n)

extern  struct plchrstr plchr[];
extern	int pln_maxno;
