/*
 * nuke.h
 *
 * things having to do with nukes
 *
 * Dave Pare, 1986
 * $Revision: 1.1 $ $Date: 93/06/29 08:58:19 $
 */

#define T250odds	0.10	/* odds of a tech 250 nuke launch accident */
#define T350odds	0.03	/* odds of a tech 350 nuke launch accident */

#define	N_MAXNUKE	30

struct	nukstr {
	coord	nuk_x;		/* current loc of device */
	coord	nuk_y;
	natid	nuk_own;
	char	nuk_n;		/* number of nukes in list */
	short	nuk_spare1;
	short	nuk_spare2;
	short	nuk_uid;
	short	nuk_ship;	/* currently aboard ship */
	short	nuk_trade;	/* index into trade file */
	char	nuk_types[N_MAXNUKE];	/* # of nukes in sector of given type */
};

struct nchrstr {
	char *n_name;		/* warhead unit name */
	int n_lcm;		/* cost: lcms */
	int n_hcm;		/* cost: hcms */
	int n_oil;		/* cost: oil */
	int n_rad;		/* cost: rads */
	int n_vac;		/* cost: vaccine */
	int n_blast;		/* blast radius */
	int n_dam;		/* damage at center */
	int n_cost;
	int n_tech;		/* tech needed to build */
	int n_weight;
	int n_flags;		/* description of capability */
};

/* Nuke special capability flags */
/* These MUST equate exactly with the damage flags in damage.h */

#define N_NEU		bit(0)	/* Neutron bomb */
#define N_CHM		bit(1)  /* Chemical bomb */
#define N_PLG		bit(2)  /* Plague bomb */
#define N_SPA		bit(3)  /* Sparse-damage flag */

#define getnuke(n, p) \
	ef_nbread(EF_NUKE, n, (caddr_t)p)
#define putnuke(n, p) \
	ef_nbwrite(EF_NUKE, n, (caddr_t)p)
#define getnukep(n) \
	(struct nukstr *) ef_ptr(EF_NUKE, n)

extern  struct nchrstr nchr[];
