/*
 * nsc.h
 *
 * defines for empire conditionals.
 *
 * rewritten by Dave Pare, 1989
 * $Revision: 1.2 $ $Date: 93/07/30 14:29:36 $
 */

#ifndef HAVE_NSC

#define HAVE_NSC

#define NS_LSIZE	128
#define NS_NCOND	16
#define NS_NSIZE	12

#ifndef HAVE_XY
#include "xy.h"
#endif

struct	nscstr	{
	long	fld1;			/* first commodity or number */
	long	fld2;			/* second commodity or number */
	int	oper;			/* required relationship operator */
};

struct nstr_sect {
	coord	x, y;			/* current x-y */
	coord	dx, dy;			/* accumlated x,y travel */
	int	id;			/* return value of sctoff */
	int	type;			/* type of query */
	int	curdist;		/* dist query: current range */
	struct	range range;		/* area of coverage */
	int	dist;			/* dist query: range */
	coord	cx, cy;			/* dist query: center x-y */
	int	(*read)();		/* read function */
	int	ncond;			/* # of selection conditions */
	struct	nscstr cond[NS_NCOND];	/* selection conditions */
};

struct nstr_item {
	int	cur;			/* current item */
	int	sel;			/* selection type */
	int	type;			/* item type being selected */
	int	curdist;		/* if NS_DIST, current item's dist */
	struct	range range;		/* NS_AREA/NS_DIST: range selector */
	int	dist;			/* NS_DIST: distance selector */
	coord	cx, cy;			/* NS_DIST: center x-y, NS_XY: xy */
	int	group;			/* NS_GROUP: fleet/wing match */
	char	name[NS_NSIZE];		/* NS_NAME: name match */
	int	size;			/* NS_LIST: size of list */
	int	index;			/* NS_LIST: index */
	int	list[NS_LSIZE]; 	/* NS_LIST: item list */
	int	(*read)();		/* read function */
	int	flags;			/* EFF_ flags */
	int	ncond;			/* # of selection conditions */
	struct	nscstr cond[NS_NCOND];	/* selection conditions */
};

#define NS_UNDEF	0
#define NS_LIST		1
#define NS_DIST		2
#define NS_AREA		3
#define NS_ALL		4
#define NS_XY		5
#define NS_GROUP	6
#define NS_NAME		7

/*
 * looks something like this:
 * T: type of pointer.
 * C: catagory of value.
 * V: value.
 *
 * xxxx xxxx xxxx xxxx
 *   TT TTCC VVVV VVVV
 */

#define NSC_CAT_POS     16
#define NSC_OFF_POS     18

/*
 * catagories
 */

#define NSC_VAL		(0)	          /* normal number */
#define	NSC_VAR		(1<<NSC_CAT_POS)  /* is a vtype */
#define	NSC_OFF		(2<<NSC_CAT_POS)  /* is a sect/ship offset */
#define NSC_UNIT	(3<<NSC_CAT_POS)  /* unit present flag */
#define	NSC_CMASK	(3<<NSC_CAT_POS)

/*
 * how to interpret "offset" fields
 */

#define NSC_CHAR	( 1<<NSC_OFF_POS) /* pointer to char */
#define NSC_UCHAR	( 2<<NSC_OFF_POS) /* pointer to uchar */
#define NSC_SHORT	( 3<<NSC_OFF_POS) /* pointer to short */
#define	NSC_LONG	( 4<<NSC_OFF_POS) /* pointer to long */
#define NSC_DPX         ( 5<<NSC_OFF_POS) /* dist x (pointer to sctstr) */
#define NSC_DPY         ( 6<<NSC_OFF_POS) /* dist y (pointer to sctstr) */
#define NSC_NEXT        ( 7<<NSC_OFF_POS) /* adjacent owner */
#define NSC_UC_BIT0     ( 8<<NSC_OFF_POS) /* ptr to uchar, test bit 0 */
#define NSC_UC_BIT1     ( 9<<NSC_OFF_POS) /* ptr to uchar, test bit 1 */
#define NSC_UC_BIT2     (10<<NSC_OFF_POS) /* ptr to uchar, test bit 2 */
#define NSC_UC_BIT3     (11<<NSC_OFF_POS) /* ptr to uchar, test bit 3 */
#define NSC_UC_BIT4     (12<<NSC_OFF_POS) /* ptr to uchar, test bit 4 */
#define NSC_UC_BIT5     (13<<NSC_OFF_POS) /* ptr to uchar, test bit 5 */
#define NSC_UC_BIT6     (14<<NSC_OFF_POS) /* ptr to uchar, test bit 6 */
#define NSC_UC_BIT7     (15<<NSC_OFF_POS) /* ptr to uchar, test bit 7 */
#define NSC_TMASK	(15<<NSC_OFF_POS)

#define NSC_COORD	NSC_SHORT	/* change if coord typedef changes */
#define NSC_NATID	NSC_UCHAR	/* change if natid typedef changes */

#define NSC_MASK	(0xffff0000)

#define NSC_UC_BIT(x)   (((x)&7 | 8) << NSC_OFF_POS)

struct	castr	{
	long	ca_code;	/* encoded form */
	char	*ca_name;	/* name used for matches */
};

/* variables using the above */

extern  struct castr sect_ca[];
extern  struct castr var_ca[];
extern  struct castr ship_ca[];
extern  struct castr plane_ca[];
extern  struct castr ca[];

extern	char *nstr_comp();

#define snxtitem_list(np,type,list,len)         SNXTITEM_LIST(np,type,list,len,-1)
#define snxtitem_name(np,type,name)             SNXTITEM_NAME(np,type,name,-1)
#define snxtitem_group(np,type,group)           SNXTITEM_GROUP(np,type,group,-1)
#define snxtitem_all(np,type)                   SNXTITEM_ALL(np,type,-1)
#define snxtitem_xy(np,type,x,y)                SNXTITEM_XY(np,type,x,y,-1)
#define snxtitem_dist(np,type,cx,cy,dist)       SNXTITEM_DIST(np,type,cx,cy,dist,-1)
#define snxtitem_area(np,type,range)            SNXTITEM_AREA(np,type,range,-1)
#define snxtitem(np,type,str)                   SNXTITEM(np,type,str,-1)

#define snxtitem_list_own(np,type,list,len)     SNXTITEM_LIST(np,type,list,len,cnum)
#define snxtitem_name_own(np,type,name)         SNXTITEM_NAME(np,type,name,cnum)
#define snxtitem_group_own(np,type,group)       SNXTITEM_GROUP(np,type,group,cnum)
#define snxtitem_all_own(np,type)               SNXTITEM_ALL(np,type,cnum)
#define snxtitem_xy_own(np,type,x,y)            SNXTITEM_XY(np,type,x,y,cnum)
#define snxtitem_dist_own(np,type,cx,cy,dist)   SNXTITEM_DIST(np,type,cx,cy,dist,cnum)
#define snxtitem_area_own(np,type,range)        SNXTITEM_AREA(np,type,range,cnum)
#define snxtitem_own(np,type,str)               SNXTITEM(np,type,str,cnum)

#define snxtsct(np,str)                         SNXTSCT(np,str,-1)
#define snxtsct_all(np)                         SNXTSCT_ALL(np,-1)
#define snxtsct_area(np,range)                  SNXTSCT_AREA(np,range,-1)
#define snxtsct_dist(np,cx,cy,dist)             SNXTSCT_DIST(np,cx,cy,dist,-1)

#define snxtsct_own(np,str)                     SNXTSCT(np,str,cnum)
#define snxtsct_all_own(np)                     SNXTSCT_ALL(np,cnum)
#define snxtsct_area_own(np,range)              SNXTSCT_AREA(np,range,cnum)
#define snxtsct_dist_own(np,cx,cy,dist)         SNXTSCT_DIST(np,cx,cy,dist,cnum)

#endif
