/*
 * nat.h
 *
 * things having to do with nations
 *
 * from PSL Empire, 1985
 * $Revision: 1.2 $ $Date: 93/08/12 08:47:25 $
 */

#define	MAXNOR		12              /* max # realms */
#define COUNTRYBITS     (MAXNOC+7)/8    /* number of bytes needed for 1 bit per country */

struct	boundstr {
	short	b_xl, b_xh;		/* horizontal bounds */
	short	b_yl, b_yh;		/* vertical bounds */
};

struct	natstr {
    char	nat_cnam[20];		/* country name */
    char	nat_pnam[20];		/* representative */
    coord	nat_xcap, nat_ycap;	/* cap location in abs coords */
    coord	nat_xorg, nat_yorg;	/* origin location in abs coords */
    char	nat_stat;		/* inuse, norm, god, abs */
    char	nat_dayno;		/* day of the year mod 128 */
    char	nat_flags;		/* misc other flags */
    int		nat_tgms;		/* # of telegrams to be announced */
    int		nat_minused;		/* number of minutes used today */
    int		nat_btu;		/* bureaucratic time units */
    long	nat_reserve;		/* military reserves */
    long	nat_money;		/* moola */
    time_t	nat_date;		/* last logoff */
    time_t	nat_newstim;		/* date news last read */
    float	nat_level[4];		/* technology, etc */
    struct	boundstr nat_b[MAXNOR];	/* realm bounds */
    short	nat_relate[COUNTRYBITS];/* two bits for each other country */
    double	nat_pricemult[MAXNOC];	/* price multipliers */
    float       nat_iratio[MAXNOC];     /* interceptor control constants:     */
    u_char      nat_iextra[MAXNOC];     /*  intrcptrs=intruders*iratio+iextra */
    u_char	nat_reject[COUNTRYBITS];/* reject telegrams: one bit for each country */
    u_char      nat_spare[COUNTRYBITS]; /* one bit for each country */
    };

        /* nation flags */
#define FLAG_LOGIN	bit(0)		/* currently logged in */
#define FLAG_UPDATE	bit(1)		/* demanding an update */
#define FLAG_TRIBE      bit(2)          /* tribal auto-player */
#define FLAG_POGO       bit(3)          /* God of gods */

	/* nation status types */
#define STAT_INUSE	bit(0)		/* cnum in use */
#define STAT_SANCT	bit(1)		/* country in sanctuary */
#define STAT_NORM	bit(2)		/* normal country */
#define STAT_GOD	bit(3)		/* deity powers */
#define STAT_ABS	bit(4)		/* abs coords */
#define STAT_NEW	bit(5)		/* just initialized */

	/* nstat values */
#define VIS		STAT_INUSE
#define	NORM		(STAT_INUSE|STAT_NORM)
#define	GOD		(STAT_INUSE|STAT_GOD)
#define	SANCT		(STAT_INUSE|STAT_SANCT)
#define	CAP		bit(6)
#define	MONEY		bit(7)

	/* nation relation codes */
#define	NEUTRAL		0
#define	ALLIED		1
#define	HOSTILE		2
#define	AT_WAR		3

#define	NAT_TLEV	0
#define	NAT_RLEV	1
#define	NAT_ELEV	2
#define	NAT_HLEV	3

#define	NF_DELTA	1
#define NF_SET		2

	/* yuck; nation modify macros to send stuff to tm */

#define	NAT_DELTA(field, coun, value) \
	(nat_value(OFFSET(natstr, field), coun, 0, NF_DELTA, value))

#define	NAT_SET(field, coun, value) \
	(nat_value(OFFSET(natstr, field), coun, 0, NF_SET, value))

#define	NAT_SETARY(field, coun, i, value) \
	(nat_value(OFFSET(natstr, field), coun, i, NF_SET, value))

#define	NAT_DELTARY(field, coun, i, value) \
	(nat_value(OFFSET(natstr, field), coun, i, NF_DELTA, value))

#define	NF_CHAR		1
#define	NF_UCHAR	2
#define	NF_SHORT	3
#define	NF_LONG		4
#define	NF_STRING	5
#define	NF_FLOAT	6
#define	NF_DOUBLE	7
#define	NF_BOUND	8

#define NF_NOTIFY	1
#define NF_PRIVATE	2

#define NF_NATID	NF_UCHAR
#define NF_COORD	NF_SHORT

struct fixnat {
	char *name;
	int type;
	int index;
	int notify;
	int offset;
};

/* procedures relating to nation stuff */

#define getnat(n, p) \
	ef_nbread(EF_NATION, n, (caddr_t)p)
#define putnat(n, p) \
	ef_nbwrite(EF_NATION, n, (caddr_t)p)
#define getnatp(n) \
	(struct natstr *) ef_ptr(EF_NATION, (int)n)

extern	double techfact();
extern	double tfact();
extern	double reltech();
extern	double multread();

extern	char *natstate();
extern	char *cname();
extern	char *relatename();
extern	struct fixnat *natfield();

extern	natid cnum;
extern	int owner;
extern	int nstat;
extern	double dolcost;
extern	int nbtu;
extern	int broke;
