/*
 * file.h
 *
 * Describes Empire files and their contents.
 *
 * $Revision: 1.1 $ $Date: 93/06/29 08:58:14 $
 */

typedef struct empfile {
	char *name;		/* file name (e.g., "treaty") */
	char *file;		/* file path */
	int flags;		/* misc stuff */
	int mode;		/* O_flags */
	int size;		/* size of object */
	int (*postread)();	/* specific massage routines for items */
	int (*prewrite)();
	int varoffs[3];		/* struct offs for nv, vtype, vamt */
	int maxvars;		/* max # vars for type */
	int fd;			/* file descriptor */
	int baseid;		/* starting item in cache */
	int cids;		/* # ids in cache */
	int csize;		/* size of cache in bytes */
	caddr_t cache;		/* pointer to cache */
	int fids;		/* # of ids in file */
	struct castr *cadef;	/* ca defs selection list */
} _empfile;

#define EFF_COM		bit(0)	/* item has commodities attached */
#define EFF_XY		bit(1)	/* has location */
#define EFF_MEM		bit(2)	/* stored entirely in-memory */
#define EFF_OWNER	bit(3)	/* has concept of owner */
#define EFF_GROUP	bit(4)	/* has concept of group */
#define EFF_NAME	bit(5)  /* has concept of names */

#define EF_SECTOR	0
#define EF_NEWS		1
#define EF_LOAN		2
#define EF_SHIP		3
#define EF_PLANE	4
#define EF_TREATY	5
#define EF_NUKE		6
#define EF_TRADE	7
#define EF_POWER	8
#define EF_NATION	9
#define EF_SPY          10
#define EF_ARMY         11
#define EF_MAX		12

typedef struct fileinit {
	int (*postread)();
	int (*prewrite)();
	struct castr *cadef;
} _fileinit;

extern	struct castr *ef_cadef();
extern	int ef_read();
extern	int ef_nbread();
extern	char *ef_ptr();
extern	char *ef_nameof();
extern	time_t ef_mtime();
extern	struct range worldrange;
extern	struct empfile empfile[];
