/*
**  army.h
**
**  Defines military unit types
**
**  9/92 Bill Frolik
*/

#ifndef HAVE_NSC
#include "nsc.h"
#endif

#define MAXARMV 14

struct armstr {
	coord arm_x;		/* army x-y */
	coord arm_y;
	natid arm_own;		/* owner */
	char  arm_type;		/* unit type */
	char  arm_effic;	/* efficiency (0-100) */
	char  arm_mobil;	/* mobility */
	short arm_sell;		/* index into trade file */
	short arm_tech;		/* tech level */
	short arm_uid;		/* unit id */
	char  arm_group;	/* group id */
	char arm_name[NS_NSIZE];/* unit name */
	short arm_ship;		/* transport */
	char  arm_morale;	/* morale (0-100) */
	char  arm_acc;		/* accuracy (0-100) */
	u_char arm_spare1;
	u_char arm_spare2;
	char  arm_flags;	/* flags */
	char  arm_nv;		/* current number of variables */
	u_char arm_vtype[MAXARMV];
	u_short	arm_vamt[MAXARMV];
};

struct auchrstr { /* army unit characteristics */
	char *au_name;		/* army unit name */
	double au_cost;		/* formation cost/mil */
	double au_paymult;	/* pay aultiplier */
	int au_tech;            /* tech required */
	int au_flags;		/* description of capability */
};

#define A_GI	bit(0)	/* general infantry */
#define A_PA	bit(1)  /* paratroops */
#define A_CO	bit(2)	/* commandos */
#define A_EN	bit(3)	/* engineers */
#define A_AR	bit(4)	/* artillery */

#define getarmy(n, p)   ef_nbread(EF_ARMY, n, (caddr_t)p)
#define putarmy(n, p) 	ef_nbwrite(EF_ARMY, n, (caddr_t)p)
#define getarmyp(n) 	(struct armstr *) ef_ptr(EF_ARMY, n)

extern  struct auchrstr auchr[];
extern	int arm_maxno;
