/*
 * ioqueue.h
 *
 * stores and frees data associated with a file descriptor.
 * uses writev to write, and read to read.
 *
 * $Revision: 1.1 $ $Date: 93/08/02 12:10:32 $
 */

#define MAXIOV		16

struct ioqueue {
	struct qelem queue;	/* queue fwd/back */
	int bsize;		/* basic block size */
	int cc;			/* character count */
};

struct io {
	struct qelem queue;	/* list of ioqueue elements */
	int nbytes;		/* number of data bytes present */
	int offset;		/* offset into current entry */
	char *data;		/* pointer to start */
};

char	*ioq_gets();
