#define NEWPOWER
#ifndef lint
static char *RCSid = "$Header: powe.c,v 1.11 89/11/13 00:09:59 mr-frog Exp $";
#endif

/*
 * powe.c
 *
 * Do a power report
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "ship.h"
#include "land.h"
#include "nuke.h"
#include "power.h"
#include "item.h"
#include "deity.h"
#include "plane.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"

#include <fcntl.h>

static	int powcmp();
static	out5();
static	gen_power();
static	addtopow();

int
powe()
{
	extern s_char *argp[];
	extern double powe_cost;
	struct natstr *natp;
#ifdef NOGODS
	struct natstr *natp2;
#endif /* NOGODS */
	int     round_flag;
	time_t	pow_time;
	struct	nstr_item ni;
	struct	powstr pow;
	int	num;
	int	target = 0;
	int     show_score = 0;
	        /* Michael Feuell (elf@twain.ucs.umass.edu) Jun 1991 */

	natp = getnatp(cnum);
	pr("     - = [   Empire Power Report   ] = -\n");
	num = MAXNOC;
	if (argp[1] && argp[1][0] == 'n') {
		if (natp->nat_btu < 1)
			pr("\n  Insufficient BTUs, using the last report.\n\n");
		else {
			gen_power();
			if (argp[2] && (num = atoi(argp[2])) < 0)
				return RET_FAIL;
		}
	} else if (argp[1] && argp[1][0] == 's') { show_score=1;
	} else if (argp[1] && argp[1][0] == 'c') {
		if (!argp[2] || (target = atoi(argp[2])) < 0)
		  /* Michael Feuell (elf@twain.ucs.umass.edu) Jun 1991 */
			return RET_FAIL;
	} else if (argp[1] && (num = atoi(argp[1])) < 0)
		return RET_FAIL;
	pow_time = ef_mtime(EF_POWER);
	pr(fmt("      as of %s\n         sects  eff civ", ctime(&pow_time)));
	pr("  mil  shell gun pet  iron dust oil  pln ship unit money\n");
	snxtitem_all(&ni, EF_POWER);
	while ((nxtitem(&ni, (s_char *)&pow)) && num > 0) {
		if (pow.p_nation == 0 || pow.p_power <= 0.0)
			continue;
#ifdef NOGODS
		natp2 = getnatp(pow.p_nation);
		if (natp2->nat_stat & STAT_GOD)
			continue;
#endif /* NOGODS */
		if (target && pow.p_nation != target)
			continue;
		if (pow.p_nation != cnum && cnum != 0)
			round_flag = 1;
		else
			round_flag = 0;
		num--;
		pr(fmt("%9.9s", cname(pow.p_nation)));
		out5(pow.p_sects, 5, round_flag);
		if (pow.p_sects)
		  pr(fmt("%4.0f%%", pow.p_effic / (pow.p_sects)));
		  /* Michael Feuell (elf@twain.ucs.umass.edu) Jun 1991 */
		else pr(fmt("%4.0f%%", 0));
		out5(pow.p_civil, 50, round_flag);
		out5(pow.p_milit, 50, round_flag);
		out5(pow.p_shell, 25, round_flag);
		out5(pow.p_guns, 5, round_flag);
		out5(pow.p_petrol, 50, round_flag);
		out5(pow.p_iron, 50, round_flag);
		out5(pow.p_dust, 50, round_flag);
		out5(pow.p_oil, 50, round_flag);
		out5(pow.p_planes, 10, round_flag);
		out5(pow.p_ships, 10, round_flag);
		out5(pow.p_units, 10, round_flag);
		out5(pow.p_money, 5000, round_flag);
		pr("\n");
		if (show_score && (god != 0))
			pr(fmt("%9.2f\n", pow.p_power));
	}
	pr("          ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ----\n");
	getpower(0, &pow);
	pr("worldwide");
	out5(pow.p_sects, 5, 1);
	pr(fmt("%4.0f%%", pow.p_effic / (pow.p_sects + 0.1)));
	out5(pow.p_civil, 50, 1);
	out5(pow.p_milit, 50, 1);
	out5(pow.p_shell, 25, 1);
	out5(pow.p_guns, 5, 1);
	out5(pow.p_petrol, 50, 1);
	out5(pow.p_iron, 50, 1);
	out5(pow.p_dust, 50, 1);
	out5(pow.p_oil, 50, 1);
	out5(pow.p_planes, 10, 1);
	out5(pow.p_ships, 10, 1);
	out5(pow.p_units, 10, 1);
	out5(pow.p_money, 5000, 1);
	pr("\n");
	return RET_OK;
}

static
out5(value, round_val, round_flag)
	double  value;
	int     round_val;
	int     round_flag;
{
	if (value > round_val && round_flag)
		value = (int) (value / round_val + 0.5) * round_val;
	if (value < -995000.)
		pr(fmt("%4.0fM", value / 1e6));
	else if (value < -9950.)
		pr(fmt("%4.0fK", value / 1000.));
	else if (value < -999.)
		pr(fmt("%4.1fK", value / 1000.));
	else if (value < 1000.)
		pr(fmt("%4.0f ", value));
	else if (value < 10000.)
		pr(fmt("%4.1fK", value / 1000.));
	else if (value < 1e6)
		pr(fmt("%4.0fK", value / 1000.));
	else if (value < 1e7)
		pr(fmt("%4.1fM", value / 1e6));
	else if (value >= 1e9)
		pr(fmt("%4.0fG", value / 1e9));
	else
		pr(fmt("%4.0fM", value / 1e6));
}

struct powsort {
	float powval;
	natid cnum;
};

static
gen_power()
{
	extern	double powe_cost;
	float  *f_ptr;
	float  *f_pt2;
	register struct powstr *pow;
	register int i;
	struct	sctstr sect;
	struct	plnstr plane;
	struct	shpstr ship;
	struct	lndstr land;
	struct	powstr powbuf[MAXNOC];
	struct	nstr_item ni;
	struct	nstr_sect ns;
	int	vec[I_MAX+1];
	struct	powsort order[MAXNOC];
	struct	natstr *natp;
#ifdef NEWPOWER
	float	f;
#endif /* NEWPOWER */

	NAT_DELTA(nat_btu, cnum, (int)-powe_cost);
	bzero((s_char *) powbuf, sizeof(powbuf));
	snxtsct_all(&ns);
	while (nxtsct(&ns, &sect)) {
		if (sect.sct_own == 0)
			continue;
		pow = &powbuf[sect.sct_own];
		pow->p_sects += 1.0;
		pow->p_effic += sect.sct_effic;
		getvec(VT_ITEM, vec, (s_char *)&sect, EF_SECTOR);
		addtopow(vec, pow);
	}
	snxtitem_all(&ni, EF_LAND);
	while (nxtitem(&ni, (s_char *)&land)) {
		if (land.lnd_own == 0)
			continue;
		pow = &powbuf[land.lnd_own];
		getvec(VT_ITEM, vec, (s_char *)&land, EF_LAND);
		addtopow(vec, pow);
#ifndef NEWPOWER
		pow->p_power += lchr[land.lnd_type].l_lcm / 10.0;
		pow->p_power += lchr[land.lnd_type].l_hcm / 5.0;
#else
		f = ((float)(lchr[land.lnd_type].l_lcm / 10.0)) *
			((float)land.lnd_effic)/100.0;
		f += ((float)(lchr[land.lnd_type].l_hcm / 10.0)) * 
			((float)land.lnd_effic/100.0);
		pow->p_power += f*2;
#endif /* NEWPOWER */
		pow->p_units += 1.0;
	}
	snxtitem_all(&ni, EF_SHIP);
	while (nxtitem(&ni, (s_char *)&ship)) {
		if (ship.shp_own == 0)
			continue;
		pow = &powbuf[ship.shp_own];
		getvec(VT_ITEM, vec, (s_char *)&ship, EF_SHIP);
		addtopow(vec, pow);
#ifndef NEWPOWER
		pow->p_power += mchr[ship.shp_type].m_lcm / 10.0;
		pow->p_power += mchr[ship.shp_type].m_hcm / 5.0;
#else
		f = ((float)(mchr[ship.shp_type].m_lcm / 10.0)) *
			((float)ship.shp_effic)/100.0;
		f += ((float)(mchr[ship.shp_type].m_hcm / 10.0)) * 
			((float)ship.shp_effic/100.0);
		pow->p_power += f*2;
#endif /* NEWPOWER */
		pow->p_ships += 1.0;
	}
	snxtitem_all(&ni, EF_PLANE);
	while (nxtitem(&ni, (s_char *)&plane)) {
		if (plane.pln_own == 0)
			continue;
		pow = &powbuf[plane.pln_own];
		pow->p_planes += 1.0;
#ifndef NEWPOWER
		pow->p_power += plane.pln_effic / 10.0;
#else
		natp=getnatp(plane.pln_own);
		pow->p_power += 20 * (plane.pln_effic / 10.0) *
			(natp->nat_level[NAT_TLEV]/500.0);
#endif /* NEWPOWER */
	}
	for (i=1; natp = getnatp(i); i++) {
		pow = &powbuf[i];
		pow->p_nation = i;
		if ((natp->nat_stat & STAT_INUSE) == 0 ||
		    (natp->nat_stat & STAT_NORM) == 0) {
			pow->p_power = 0.;
			continue;
		}
#ifdef NEWPOWER
		if (natp->nat_stat & STAT_GOD){
			pow->p_power = 0.;
			continue;
		}
#endif /* NEWPOWER */
		pow->p_money = natp->nat_money;
		pow->p_power += pow->p_money / 100.;
#ifndef NEWPOWER
		pow->p_power += pow->p_petrol / 50.0;
#else
		pow->p_power += pow->p_petrol / 500.0;
#endif /* NEWPOWER */
#ifndef NEWPOWER
		pow->p_power += (pow->p_civil + pow->p_milit +
			pow->p_shell) / 10.;
		pow->p_power += (pow->p_iron + pow->p_dust +
			pow->p_effic + pow->p_oil) / 10.;
		pow->p_power += (pow->p_guns + pow->p_effic) / 3.;
		pow->p_power += pow->p_ships;
		pow->p_power += pow->p_sects * 3.0;
		pow->p_power += pow->p_planes * 5.0;
#else
		pow->p_power += (pow->p_civil + pow->p_milit)/10.0;
		pow->p_power += (pow->p_shell)/2.5;
		pow->p_power += (pow->p_iron)/100.0;
		pow->p_power += (pow->p_dust/5 + pow->p_oil/10 + pow->p_bars);
		pow->p_power += (pow->p_guns) / 12.5;
		if (pow->p_sects > 0)
			pow->p_power += (pow->p_sects *
				((pow->p_effic/pow->p_sects)/100.0)) * 10.0;
		if (natp->nat_level[NAT_TLEV] > 0.0)
			pow->p_power = pow->p_power *
				(((float)natp->nat_level[NAT_TLEV])/500.0);
		else
			pow->p_power = pow->p_power * (1.0/500.0);
#endif /* NEWPOWER */
		/* ack.  add this vec to the "world power" element */
		f_pt2 = &(powbuf[0].p_sects);
		f_ptr = &(pow->p_sects);
		while (f_ptr <= &(pow->p_power)) {
			*f_pt2 += *f_ptr;
			f_pt2++;
			f_ptr++;
		}
	}
	for (i=1; i < MAXNOC; i++) {
#ifdef RES_POP
		struct	natstr *np;
		int     maxpop;
		float	f;

		np = getnatp(i);
		maxpop = max_pop(np->nat_level[NAT_RLEV]);
		f = 1.0 + (((float)maxpop)/10000.0);
#else
		float	f=1.0;
#endif /* RES_POP */
		powbuf[i].p_power *= f;
		order[i].powval = powbuf[i].p_power;
		order[i].cnum = i;
	}
	qsort((s_char *)&order[1], MAXNOC-1, sizeof(*order), powcmp);
	putpower(0, &powbuf[0]);
	for (i=1; i<MAXNOC; i++) {
		putpower(i, &powbuf[order[i].cnum]);
	}
}

static
powcmp(p1, p2)
	struct	powsort *p1;
	struct	powsort *p2;
{
	if (p1->powval > p2->powval)
		return -1;
	if (p1->powval < p2->powval)
		return 1;
	return 0;
}

static
addtopow(vec, pow)
	register int vec[I_MAX+1];
	register struct powstr *pow;
{
	pow->p_civil += vec[I_CIVIL];
	pow->p_milit += vec[I_MILIT];
	pow->p_shell += vec[I_SHELL];
	pow->p_guns += vec[I_GUN];
	pow->p_petrol += vec[I_PETROL];
	pow->p_iron += vec[I_IRON];
	pow->p_dust += vec[I_DUST];
	pow->p_food += vec[I_FOOD];
	pow->p_oil += vec[I_OIL];
	pow->p_bars += vec[I_BAR];
	pow->p_power += vec[I_LCM] / 10.0;
	pow->p_power += vec[I_HCM] / 5.0;
}
