#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/coun.c,v 1.8 89/09/16 17:16:19 mr-frog Exp $";
#endif /* not lint */

/*
 * coun.c
 *
 * do a country roster.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "deity.h"
#include <fcntl.h>
#include <ctype.h>

int
coun()
{
	extern	s_char *argp[];
	struct	nstr_item ni;
	struct	natstr nat;
	int	first;

	int     chk_god;
	chk_god = (argp[2]&&argp[2][0]=='g');

        /* Force a complete re-read of nation file, I hope --ts */
        ef_close(EF_NATION);
        ef_open(EF_NATION, O_RDONLY, EFF_MEM);
	if (!snxtitem(&ni, EF_NATION, argp[1]))
		return RET_SYN;
	first = 1;

	while (nxtitem(&ni, (s_char *)&nat)) {
		if ((nat.nat_stat & STAT_INUSE) == 0)
			continue;
		if (((nat.nat_stat & GOD) == GOD) && !god)
			if(!chk_god) continue;
		if (((nat.nat_stat & GOD) != GOD) && !god)
			if(chk_god) continue;
		if (first) {
			coun_header(chk_god);
			first = 0;
		}
		coun_list((natid)ni.cur, &nat,chk_god);
	}
	return RET_OK;
}

static
coun_header(chk_god)
        int chk_god;
{
	prdate();
	pr("  #   ");
	if (god||chk_god)
	  pr("last access       time\t");
	pr("status\t\t country name\n");
}

static
coun_list(cn, natp, chk_god)
	natid	cn;
	struct	natstr *natp;
        int     chk_god;
{
	s_char	*status;
	struct	sctstr sect;

	pr(fmt("%3d  ",cn));
	if (god||chk_god) {
	  if (natp->nat_login)
	    pr(fmt("%-16.16s   [%d]"," Now logged on",
		   natp->nat_btu));
	  else
	    pr(fmt("%-16.16s   [%d]", ctime(&natp->nat_date),
		   natp->nat_btu));
	}
	switch (natp->nat_stat & (STAT_NORM|STAT_GOD|STAT_NEW|STAT_SANCT)) {
	case 0:
		status = "Visitor";
		break;
	case STAT_NEW:
		status = "New";
		break;
	case STAT_SANCT:
		status = "Sanctuary";
		break;
	case (STAT_NORM|STAT_SANCT):
		getsect(natp->nat_xcap, natp->nat_ycap, &sect);
		if (sect.sct_own != cn ||
		    (sect.sct_type != SCT_CAPIT &&
		    sect.sct_type != SCT_MOUNT))
			status = "In flux";
		else if (natp->nat_money < 0)
			status = "Broke";
		else
			status = "Active";
		break;
	case (STAT_GOD|STAT_NORM):
	case (STAT_GOD|STAT_NORM|STAT_SANCT):
		status = "DEITY";
		break;
	default:
		status = "Buggy";
		break;
	}
	pr(fmt("\t%-9.9s\t %s\n", status, natp->nat_cnam));
}
