static char *RCSid = "$Header: /sequent2/empire/EMP/lib/global/RCS/constants.c,v 1.2 89/09/03 17:23:55 mr-frog Exp $";

/*
 * constglb.c
 *
 * Global constants file.  This should probably be redone.  Note that
 * the "hours" file can override some of these, so be careful.
 *
 */

#include "gamesdef.h"
#include "misc.h"
#include "xy.h"

s_char    *privname   = PRVNAM;	/* name of priv user */
s_char    *privlog    = PRVLOG;	/* logname of priv user */

int	m_m_p_d     = 1000;	/* max mins of play per day (per country) */
long    s_p_etu     = 4;	/* seconds per Empire time unit */
int	etu_per_update = ETUS;	/* # of etu's per update, from misc.h */
long    adj_update  = 0;	/* update time adjustment */

int	sect_mob_max = 127;	/* sector mobility limits */
float	sect_mob_scale = 1.0;	/* accumulation multiplier */
int	land_mob_max = 127;	/* land mobility limits */
float	land_mob_scale = 1.0;	/* accumulation multiplier */
int	ship_mob_max = 127;	/* ship mobility limits */
float	ship_mob_scale = 3.0;	/* accumulation multiplier */
int	plane_mob_max = 127;	/* plane mobility limits */
float	plane_mob_scale = 2.0;	/* accumulation multiplier */

double	combat_mob=10.0;	/* how much mob do units spend for combat? */

/* if you find that naving is taking too long, try reducing these */
int fort_max_interdiction_range = 8;
int ship_max_interdiction_range = 8;
int land_max_interdiction_range = 8;

double mission_mob_cost = 0.01;	/* Cost is percentage of max mob */

double	unit_damage = 0.30;	/* Units take this % of normal damage */
double	people_damage = 0.40;	/* Civs/Mil/Uw take this % of normal damage */

#ifdef START_UNITS
int	start_unit_type[START_UNITS] = {0, 1, 2, 2};	/* type of unit */
#endif /* START_UNITS */

#ifdef FUEL
int	fuel_mult = 10;		/* 1 fuel = 10 mob */
#endif /* FUEL */

int	land_grow_scale = 1;	/* how fast eff grows for land units (xETUS) */
int	ship_grow_scale = 2;	/* how fast eff grows for ships (xETUS) */
int	plane_grow_scale = 1;	/* how fast eff grows for planes (xETUS) */

double   fgrate      = 0.0012;	/* food growth rate (dt * fert) */
double   fcrate      = 0.0013;	/* food cultivate rate (dt * workforce) */
double   eatrate     = 0.0010;	/* food eating rate (dt * people) */
/*double   eatrate     = 0.0000;	/* food eating rate (dt * people) */
double   babyeat     = 0.0120;	/* food to mature 1 baby into a civilian */
/*double   babyeat     = 0.0000;	/* food to mature 1 baby into a civilian */

double   obrate      = 0.0125;	/* other sectors birth rate */
double	 uwbrate     = 0.025;	/* uncompensated worker birth rate */
				/* values > 0.25 for either will overflow */


double   bankint     = 0.05;	/* bank interest rate (dt * bars) */

double	 minmult     = 0.5;	/* minimum trade mulitple */
double	 maxmult     = 10.0;	/* maximum trade multiple */
double	 tradetax    = 0.95;	/* Tax charged on trade */
double	 buytax	     = 1.0;	/* Tax charged on market purchases */
int	 startmob    = 127;	/* Sanctuary starting mobility */
double	 flakscale   = 2.85;	/* Scale factor for flak damage */
#ifdef	MISSINGMISSILES
int	 miss_inacc_thresh = 20;	/* distance at which missile */
					/* accuracy comes into play */
int	 miss_miss_chance = 25;		/* Percent chance of a missile */
					/* which is past the above thresh */
					/* missing by one sector */
#endif	MISSINGMISSILES

/* money gained from taxes, paid to military, and reservists */
double	money_civ	= 0.0043333;
double	money_uw	= 0.0086666;
double	money_mil	= -0.0833333;
double	money_res	= -0.0086666;

/* pct cost per ETU for maintaining a ship or plane or land unit */
double	money_plane	= -0.001;
double	money_ship	= -0.001;
double	money_land	= -0.001;

/* edu and hap consumption factors -- hap_cons civs need 1 hap --> hlev++ */
double	hap_cons        = 5000.0;
double	edu_cons        = 4000.0;

/* hap and edu avg mean that the weight on current happiness is
 *  (cur_hap * hap_avg + hap_prod * etu) / (hap_avg + etu);  		*/
float   hap_avg = 16.0 * 3.0;
float   edu_avg = 16.0 * 12.0;


/* tech build limitations.  Tech limits only apply after easy_tech.
 * Two ways of limiting tech: asymptotic or logrithmic:
 * tech_hard is asymptopic limitation, tech_log_base is the logrithmic
 * limitation.  set tech_log_base > 1.0 to have it take effect,
 * set hard_tech > 0 to have it take effect
 * for log based, only tech values where the slop is < 1 are used	*/

float	easy_tech = 1.00;	/* amount of tech built with no penality */
float	hard_tech = 0.0;	/* amount of in-efficiently built tech */
float	tech_log_base = 1.55;	/* base of log to take of in-efficient tech */

float   ally_factor = 1.25;	/* shared tech with allies = 1/factor */
				/* 80% shared tech, encourages not building */
float	level_age_rate = 00.0;	/* 1% per 96 etu's; 0 -> no decline */


int	players_at_00 = 0;	/* players coord system on deity 0,0? */
int	at_least_one_100 = 1;	/* init player with 100/100/100/100 sector? */



float	btu_build_rate = 0.0008;/* etu * civ * eff * btu_build_rate */
				/* 8 * 999 * 100 * 0.0004 = 319 */
int	max_btus = 600;		/* maximum # of btu's */
double	powe_cost = 10.0;	/* btu cost to gen a power report */

double	buil_bt = 100.0;	/* tech level required to build a bridge */
int	buil_bh = 400;		/* hcm required to build a bridge */
double	buil_bc = 4000.0;	/* cash required to build a bridge */

#ifdef SLOW_WAR
int     War_Cost = 1000;	/* Cost to declare war */
#endif /* SLOW_WAR */
#ifdef DEMANDUPDATE
long	last_demand_update=0;	/* When was last demand update? */
#endif /* DEMANDUPDATE */

#ifdef DRNUKE
float	drnuke_const = .33;	/* research must be at least drnuke_const*tech*/
				/* in order to build a nuke. For example, if
				/* drnuke_const is .25, you need a 75 res to */
				/* build a nuke that takes 300 tech */
#endif /* DRNUKE */
#ifdef TRADESHIPS
int   trade_1_dist = 8;		/* less than this gets no money */
int   trade_2_dist = 14;	/* less than this gets trade_1 money */
int   trade_3_dist = 25;	/* less than this gets trade_2 money */
float trade_1 = 0.035;		/* return on trade_1 distance */
float trade_2 = 0.060;		/* return on trade_2 distance */
float trade_3 = 0.090;		/* return on trade_3 distance */
float trade_ally_bonus = 0.20;	/* 20% bonus for trading with allies */
float trade_ally_cut = 0.10;	/* 10% bonus for ally you trade with */
#endif /* TRADESHIPS */

int	torpedo_damage = 30;	/* damage is X + 1dX, so 30+1d30 */

#ifdef	FALLOUT
/* these are the radioactive decay constants */
/* fraction of commodity destroyed is
   etus*fallout/(1000*melt_item_denom[item])
   higher denominators for tougher commodities */
int	 melt_item_denom[] = 
	/*   civ mil shell gun pet iron dust bar*/
	{ 0, 4,  20, 80,   100,50, 100, 100, 200,
	   2,  50, 100,100,2, 1000 };
	/*food oil lcm hcm UW rads */
double	 decay_per_etu = 0.003, /* This gives a half life of ? etus,
				   about ? days.
				   half life in etus =
					 log(.5) / log(1-decay_per_etu)
				   Calculate your own if you don't like it.
				   If you want a specific half life you can
				   calc it with this formula:
				   decay_per_etu = 1 - (.5)^(1/etus)
				   due to the discrete nature of empire
				   you can not get a precise number
				   without intensive simulation
				   (more than 3 digits). */
	 fallout_spread = 0.005;  /* fraction of fallout that leaks into 
				    each surrounding sector */
#endif	FALLOUT
