/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/update/RCS/populace.c,v 5.1 93/03/14 16:52:32 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:52:32 $
    $Author: etienne $
    $Id: populace.c,v 5.1 93/03/14 16:52:32 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	populace.c,v $
 * Revision 5.1  93/03/14  16:52:32  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:23:58  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:44:42  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"
#include "var.h"
#include "census.h"
#include "version.h"

double PopulaceSct (sct)
Sector sct;
{
	return (s_civ (sct) * s_wor (sct)) / 100.0 +
	       (s_mil (sct) * 2 / 5.0) +
	        q_uw (sct);
}

void Starvation (sct)
Sector sct;
{
	set_wor (sct, 0);
}

#ifdef TERMC_VERSION
#define ADDIT_MODE      NORMAL
#else
#define ADDIT_MODE      BOLD
#endif

double PopulaceSct2 (sct, etus,line)
Sector sct;
int etus;
int *line;
{
	int	newciv;
	int	newuw;
	int	new_birth;
	int	new_food;

	newciv = 0;
	newuw = 0;

	if (EMPOption(RES_POP))
		max_civ_uw = CalcMaxPop ();
	else
		max_civ_uw = 999;

	if (s_civ(sct) == max_civ_uw)
	{
	    Print (census_win, 0, (*line) ++,
		   Fmt ("WARNING: Civs at %d", s_civ(sct)), ADDIT_MODE);
	}
		
	if (q_uw(sct) == max_civ_uw)
	{
	    Print (census_win, 0, (*line) ++,
		   Fmt ("WARNING: Slaves at %d", q_uw(sct)), ADDIT_MODE);
	}

	if (s_civ (sct) < max_civ_uw)
	{
		new_birth = roundavg (obrate * (double) (etus * s_civ (sct)));
		new_food = (int) (0.5 + q_foo (sct) / (2.0 * babyeat));
		newciv = new_birth;
		if (newciv > new_food)
			newciv = new_food;
		if((s_civ(sct) + newciv) > max_civ_uw) 
		    Print (census_win, 0, (*line) ++,
			   Fmt ("WARNING: Civs %d",
				(s_civ(sct) + newciv)), ADDIT_MODE);
	}

	if (q_uw (sct) < max_civ_uw)
	{
		new_birth = roundavg (uwbrate * (double) (etus * q_uw (sct)));
		new_food = (int) (0.5 + q_foo (sct) / (2.0 * babyeat));
		newuw = new_birth;
		if (newuw > new_food)
			newuw = new_food;
		if((q_uw(sct) + newuw) > max_civ_uw) 
		    Print (census_win, 0, (*line) ++,
			   Fmt ("WARNING: UWs %d",
				(q_uw(sct) + newuw)), ADDIT_MODE);
	}

	return ((newciv+s_civ(sct)) * s_wor (sct)) / 100.0 + (s_mil (sct) * 2 / 5.0) + (newuw+q_uw(sct));
}
