/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/ship/RCS/scrap.c,v 5.1 93/03/14 16:51:38 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:51:38 $
    $Author: etienne $
    $Id: scrap.c,v 5.1 93/03/14 16:51:38 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	scrap.c,v $
 * Revision 5.1  93/03/14  16:51:38  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:42  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:43:25  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "ship.h"

void RedoScrap ()
{
	Ship next;
	char nextfl;

	if (last_layout == SHIP_MODE)
	{
		next = sh_nxtsct (curship);
		ScrapShip (Fmt ("%d", sh_nr (curship)));
		curship = next;
		if (curship != (Ship) 0)
			CensusShip (curship);
		else
			Census ();
		DrawSector (cursct);
	}
	else if (last_layout == FLEET_MODE)
	{
		nextfl = GiveNextFleetInSct (cursct, curfleet);
		ScrapShip (FleetId ());
		if (nextfl != ' ' && nextfl != '\0')
		{
			curfleet = '\0';
			Census ();
		}
		else
		{
			curfleet = nextfl;
			CensusFleet (curfleet);
		}
		DrawSector (cursct);
	}
	else
	{
		Message ("No current ship/fleet selected");
		Bell ();
	}
}
	

	/*
	 *	There is no binding to scrap.
	 *	This routine should only be called with owned ships
	 */

void ScrapShip (what)
char * what;
{
	Ship ptr, next;
	int i, j;
	int inc_lcm, inc_hcm;
	int nr;
	char itemchar;

	UnmarkAllShips ();
	MarkShips (what);

	if (! s_owned (cursct) || s_des (cursct) != 'h' || s_eff (cursct) < 60)
	{
		Message ("Only scrapping in 60% harbors");
		Bell ();
		return;
	}

	Message (Fmt ("Scrapping %s", what));

	if (! Confirm (Fmt ("Scrap %s", what), True))
	{
		Message ("Scrap ship cancelled");
		return;
	}

	FeedCommand (Fmt ("scrap ship %s", what), PRINT);
	SetAgain (RedoScrap);

	ptr = shiplist;
	nr = inc_lcm = inc_hcm = 0;
	while (ptr != (Ship) 0)
		if (sh_marked (ptr))
		{
			next = sh_next (ptr);

			for (i = 1; i < V_MAX; i ++)
			{
				itemchar = ItemChar (i);
				j = GiveShipQuant (ptr, itemchar);
				if (j > 0)
					SetQuant (cursct, itemchar,
					      GiveQuant (cursct, itemchar) + j);
			}

			inc_lcm += (shiptypes [sh_type (ptr)]. lcm * 2) / 3;
			inc_hcm += (shiptypes [sh_type (ptr)]. hcm * 2) / 3;
			nr ++;

			DeleteShip (ptr);
			ptr = next;
		}
		else
			ptr = sh_next (ptr);
	
	if (nr == 0)
	{
		Message ("No ships scrapped");
		Bell ();
		return;
	}

	set_q_lcm (cursct, q_lcm (cursct) + inc_lcm);
	set_q_hcm (cursct, q_hcm (cursct) + inc_hcm);
	Message (Fmt ("%d ships scrapped", nr));
	Census ();
	DrawSector (cursct);
}
