/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/ship/RCS/build.c,v 5.1 93/03/14 16:51:34 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:51:34 $
    $Author: etienne $
    $Id: build.c,v 5.1 93/03/14 16:51:34 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	build.c,v $
 * Revision 5.1  93/03/14  16:51:34  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:42  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:43:25  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "ship.h"
#include "nation.h"

static int last_shipid, last_techn;
void RedoBuildShip ();

void DoBuildShip (x, y, shipid, techn)
int x, y;
int shipid, techn;
{
	Strings strings;
	Pager pager;
	char * ptri, * err;
	char * line, * answer;
	int newshipnr;
	int maint;
	int mult;

	if (! s_owned (cursct) || s_des (cursct) != 'h' || s_eff (cursct) < 60)
	{
		Message ("You can only build ships in +60% harbors !");
		Bell ();
		return;
	}

	if (s_ava (cursct) < 1)
	{
		Message ("No available workers !");
		Bell ();
		return;
	}

	if (shipid < 0)
	{
		strings = InitStrings ();

		for (shipid = 0; shiptypes [shipid]. nam != (char *) 0;
								shipid ++)
			if (shiptypes [shipid]. tec <= (int) n_tech (nation))
			{
					/* Cost to maintain this ship */
					/* Of course no multiplier     */

				maint = (int) (etu_per_update * - dmin (-1.0,
				     shiptypes [shipid]. cos * money_ship));

				AddStringID (strings, Fmt (
		   "%-18.18s  %3d tech %3d lcm  %3d hcm  %3d ava $%-4d  ($%d)",
					shiptypes [shipid]. nam,
					shiptypes [shipid]. tec,
					shiptypes [shipid]. lcm,
					shiptypes [shipid]. hcm,
					shiptypes [shipid]. ava,
					shiptypes [shipid]. cos,
					maint), shipid);
			}

		if (StringsSize (strings) == 0)
		{
			Message ("You can't build any ships");
			Bell ();
			return;
		}

		pager = InitPager (strings, "Build which ship ?");
		MapPagerFromTop (pager, map_win, x, y);
		shipid = PagerMenu (pager);
		FreePager (pager);
		FreeStrings (strings);

		if (shipid < 0 || interrupt)
		{
			interrupt = False;
			ClearMes ();
			return;
		}
	}

	err = (char *) 0;

	if (land_units)
		mult=5;
	else
		mult=1;

	if (shiptypes [shipid]. ava > (s_ava (cursct)*mult))
		err = Fmt ("not enough available workers (need %d)",
			shiptypes [shipid]. ava);

	if (shiptypes [shipid]. lcm > (q_lcm (cursct)*mult))
		err = Fmt ("not enough light constr. materials (need %d)",
			shiptypes [shipid]. lcm);;

	if (shiptypes [shipid]. hcm > (q_hcm (cursct)*mult))
		err = Fmt ("not enough heavy constr. materials (need %d)",
			shiptypes [shipid]. hcm);

	if (shiptypes [shipid]. cos / 10 > (n_treas (nation)*mult))
		err = Fmt ("not enough money (need $%d)",
			(int) shiptypes [shipid]. cos / 10);

	if (err != (char *) 0)
	{
		Message (err);
		Bell ();
		return;
	}

	FeedEmpire (Fmt ("build ship %s", CrdStr (cursct)), PRINT);
	(void) WaitForPrompt (PRINT);
	if (EmpireStatus () != E_QUESTION)
	{
		Message ("Build failed");
		Bell ();
		return;
	}

	FeedEmpire (Fmt ("%s", shiptypes [shipid]. nam), PRINT);

	for (;;)
	{
		line = ReadEmpire (PRINT);

		if (EmpireStatus () == E_QUESTION)
		{
			PrintAtEmpire (line);
			Bell ();

			if (strncmp (line, "Build at what tech", 18) == 0)
			{
			    if (techn < 0)
			    {
				Bell ();
			    	answer = InputAtMessage (line, 5, GS_PNUMBER);

				if (answer == (char *) 0 || interrupt)
				{
					while (EmpireStatus () != E_COMMAND)
					{
						FeedEmpire ("aborted", PRINT);
						(void) WaitForPrompt (PRINT);
					}

					Message ("Build ship aborted");
					return;
				}

				if (* answer == '\0' || atoi (answer) >
							(int) n_tech (nation))
				     answer = Fmt ("%d", (int) n_tech (nation));
				     
				techn = atoi (answer);
			    }
			    else
				answer = Fmt ("%d", techn);
			}
			else
			    answer = InputAtMessage (line, 10, GS_NAME);

			if (interrupt || answer == (char *) 0)
			{
				interrupt = False;
				Message ("Build cancelled");
				FeedEmpire ("aborted", PRINT);
				(void) WaitForPrompt (PRINT);
				return;
			}
			FeedEmpire (answer, PRINT);
			continue;
		}

		if (EmpireStatus () == E_COMMAND)
		{
			PrintAtEmpire (line);
			Message ("Build failed");
			Bell ();
			return;
		}

		ptri = index (line, '#');

		if (ptri != (char *) 0)
		{
			ptri++;

			if (!ScanDigit (&ptri, &newshipnr))
				/* No digit ignore it */
				continue;

			SkipBlank (&ptri);

			if (strncmp (ptri, "built in sector", 15) != 0)
				/* No build ignore it */
				continue;

			break;
		}
	}

		/* Get new ship, just scan it */

	(void) WaitForPrompt (PRINT);
	last_techn = techn;
	last_shipid = shipid;
	SetAgain (RedoBuildShip);

	if (FScanShips (Fmt ("%d", newshipnr), DONT_PRINT) == 0)
	{
		Bell ();
		PrintAtEmpire ("Can't find your new ship !!");
		(void) WaitForPrompt (DONT_PRINT);
		return;
	}

	(void) WaitForPrompt (DONT_PRINT);

	curship = NrToShip (newshipnr);

	Message (Fmt ("A new %s is built (at tech %d)",
		shiptypes [shipid]. nam,
		sh_tech (curship)));

		/* Adjust materials & available workers */
	
	RedumpSector (cursct, DONT_PRINT);

	CensusShip (curship);

	if ((shiptypes [shipid]. cos / 10) <= 100)
		n_treas (nation) -= (double) (shiptypes [shipid]. cos / 10);
}

void BuildShip (x, y)
int x, y;
{
	DoBuildShip (x, y, -1, -1);
}

void RedoBuildShip (x, y)
int x, y;
{
	DoBuildShip (x, y, last_shipid, last_techn);
}
