/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/plane/RCS/drop.c,v 5.1 93/03/14 16:51:06 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:51:06 $
    $Author: etienne $
    $Id: drop.c,v 5.1 93/03/14 16:51:06 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	drop.c,v $
 * Revision 5.1  93/03/14  16:51:06  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:20  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:42:01  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "plane.h"
#include "var.h"

static char * last_planes = (char *) 0;
static char * last_escort = (char *) 0;
static char * last_path = (char *) 0;
static char * last_trans = (char *) 0;
static int last_x, last_y;
static Sector last_sct = (Sector) 0;
static Sector last_design = (Sector) 0;

void RedoDropOff ()
{
	char * planes;

	if (cursct != last_sct)
	{
		if (! s_owned (cursct))
		{
			Message ("Drop off only at your own sectors");
			Bell ();
			return;
		}
		DoDropOff (last_x, last_y, last_planes, last_escort,
			last_trans, (char *) 0);
		return;
	}
	
	if (last_layout == PLANE_MODE)
		planes = Fmt ("%d", pl_nr (curplane));
	else if (last_layout == WING_MODE)
		planes = WingId ();
	else
		planes = (char *) 0;

	DoDropOff (last_x, last_y, planes, (char *) 0, last_trans, (char *) 0);
}

void DropOff (x, y)
int x, y;
{
	DoDropOff (x, y, (char *) 0, (char *) 0, (char *) 0, (char *) 0);
}

	/*
	 *	Bind key to drop off ( item )
	 */

void BindDropOff (x, y, str)
int x, y;
char * str;
{
	char buf [20];
	char * planes;

	if (last_layout == PLANE_MODE)
		planes = Fmt ("%d", pl_nr (curplane));
	else if (last_layout == WING_MODE)
		planes = WingId ();
	else
		planes = (char *) 0;

	if (str != (char *) 0 && sscanf (str, " ( %s )", buf) == 1)
	{
		if (CharToItem (* buf) < 0)
		{
			Message (Fmt ("Illegal bind: drop off (%s)", buf));
			Bell ();
			return;
		}

		DoDropOff (x, y, planes, (char *) 0, buf, (char *) 0);
	}
	else
		DoDropOff (x, y, planes, (char *) 0, (char *) 0, (char *) 0);
}

void DoDropOff (x, y, planes, escort, trans, path)
int x, y;
char * planes;
char * escort, * trans;
char * path;
{
	int max_range;
	int max_load;
	Sector design;
	bool all_yours;

	UnmarkAllPlanes ();

	if (planes == (char *) 0)
	{
		planes = SelectPlanes (x, y, cursct, MIS_DROP,
					"Drop off with which planes ?");
		if (planes == (char *) 0)
		{
			Message ("DropOff cancelled");
			return;
		}
	}

	MarkPlanes (planes);
	FilterPlanesMob ();
	FilterPlanesHaving (P_M);
	FilterPlanesHaving (P_O);
	MarkAs20Mob ();
	max_load = 2 * LoadMarked (False);

	planes = MarkedPlanesId (MOB20);
	if (planes == (char *) 0)
	{
		Message ("Nothing to drop off with");
		Bell ();
		return;
	}

	if (last_planes != (char *) 0)
		free (last_planes);
	last_planes = Str (planes);

	if (escort == (char *) 0)
		escort = SelectPlanes (x, y, cursct, MIS_ESCORT,
						"Use as escort ?");

	if (escort != (char *) 0)
	{
		MarkPlanes (escort);
		FilterPlanesMob ();
		FilterPlanesHaving (P_M);
		FilterPlanesHaving (P_O);

		escort = MarkedPlanesId (MOB12);
	}

	if (escort == (char *) 0)
		escort = "";

	if (last_escort != (char *) 0)
		free (last_escort);
	last_escort = Str (escort);

	if (! ChargePetrol ())
	{
		Message ("Not enough petrol !");
		Bell ();
		return;
	}

	max_range = MaxRangeMarked (cursct); 
	SetAgain (RedoDropOff);
	last_x = x;
	last_y = y;
	last_sct = cursct;
	if (path == (char *) 0)
	{
		path = AskFlyRoute (cursct, (int) (max_range - 2) / 2,
								"drop off");

		if (path == (char *) 0)
		{
			Message ("drop off cancelled");
			UnchargePetrol ();
			return;
		}
	}
	else
	{
		if (strlen (path) > (int) ((max_range - 2) / 2))
		{
			Message ("Too far away !");
			UnchargePetrol ();
			return;
		}
	}

	if (last_path != (char *) 0)
		free (last_path);
	last_path = Str (path);
	
	design = FollowOwnedPath (cursct, path, & all_yours);
	last_design = design;

		/*
		 *	Can't drop off at planes (yet)
		 */

	if (design == cursct)
	{
		Message ("Quite useless, don't you think ?");
		UnchargePetrol ();
		Bell ();
		return;
	}

	if (design == (Sector) 0 || ! s_owned (design))
	{
		Message ("end sector should be yours !");
		UnchargePetrol ();
		Bell ();
		return;
	}

	if (max_load > 0 && design != cursct)
	{
		if (trans == (char *) 0)
		{
			trans = AskFlyItem (x + 2, y + 2, max_load, MIS_DROP);
			if (trans == (char *) 0)
			{
				Message ("Drop off cancelled");
				UnchargePetrol ();
				return;
			}
		}

		if (* trans != '\0')
			if (! LoadMarkedPlanes (* trans, 2))
			{
				Message (Fmt ("Not enough %s for all planes!",
						trans));
				Bell ();
				UnchargePetrol ();
				Bell ();
				return;
			}
	}
	else
		trans = "";

	if (last_trans != (char *) 0)
		free (last_trans);
	last_trans = Str (trans);

	if (command_state == FORCE_BUF_STATE && all_yours)
	{
		FeedCommand (Fmt ("drop %s %s %s %sh %s",
			last_planes,
			strlen (last_escort) == 0 ? "." : last_escort,
			CrdStr (cursct),
			last_path,
			trans), PRINT);
	}
	else
	{
		if (! FeedFly ("drop", last_planes, last_escort, (char *) 0,
			CrdStr (cursct), Fmt ("%sh", last_path), trans))
		{
			Message ("Something went wrong, drop off failed?");
			Bell ();
			UnchargePetrol ();
			if (* trans != '\0')
				UnloadMarkedPlanes (* trans, 2);
			return;
		}
		ParseFlyOutput (-1);
	}

	ChargeMobility ();
	if (* trans != '\0')
		DropMarkedPlanes (* trans, 2, design);
	CensusSct (cursct);
	DrawSector (cursct);
	Message ("drop off done");
}
