/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/misc/RCS/item.c,v 5.1 93/03/14 16:49:23 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:49:23 $
    $Author: etienne $
    $Id: item.c,v 5.1 93/03/14 16:49:23 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	item.c,v $
 * Revision 5.1  93/03/14  16:49:23  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:49  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:37:47  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "var.h"
#include "sector.h"

	/*
	 *	just copy from lib/global/item.c and shorten the names
	 *	so did I (I only added an unnessecary static)
	 */

static struct ichrstr ichr[I_MAX+2]  = {
/*      mnem vtype     val sell  lbs rg,wh,ur,bnk  name */
	'?', 0,         0,   0,   0, 0, 0, 0, 0, "unused",
	'c', V_CIVIL,   1,   0,   1, 1, 1,10, 1, "civilians",
	'm', V_MILIT,   0,   0,   1, 1, 1, 1, 1, "military",
	's', V_SHELL,   5,   1,   1, 1,10, 1, 1, "shells",
	'g', V_GUN,     60,  1,   10,1,10, 1, 1, "guns",
	'p', V_PETROL,  4,   1,   1, 1,10, 1, 1, "petrol",
	'i', V_IRON,    2,   1,   1, 1,10, 1, 1, "iron ore",
	'd', V_DUST,    20,  1,   5, 1,10, 1, 1, "dust (gold)",
	'b', V_BAR,     280, 1,   50,1, 5, 1, 1, "bars of gold",
	'f', V_FOOD,    0,   1,   1, 1,10, 1, 1, "food",
	'o', V_OIL,     8,   1,   1, 1,10, 1, 1, "oil",
	'l', V_LCM,     2,   1,   1, 1,10, 1, 1, "light products",
	'h', V_HCM,     4,   1,   1, 1,10, 1, 1, "heavy products",
	'u', V_UW,      1,   1,   2, 1, 1, 1, 1, "uncomp. workers", 
	'r', V_RAD,	150, 1,   8, 1,10, 1, 1, "rad. materials",
  	'\0', 0,         0,   0,   0, 0, 0, 0, 0, 0,
};

char *ItemName (i)
int i;
{
	return ichr [i]. i_name;
}

char ItemChar (i)
int i;
{
	return ichr [i]. i_mnem;
}

int CharToItem (ch)
char ch;
{
	register int i;

	for (i = 1; ichr [i]. i_mnem != '\0'; i++)
		if (ch == ichr [i]. i_mnem)
			return i;

	return -1;
}

double ItemWeight (i, pck)
int i;
int pck;
{
	return (((double) ichr [i]. i_lbs) /
			 ((double) ichr [i]. i_pkg [pck]));
}
	
int SelectItem (x, y, quest)
int x, y;
char *quest;
{
	int i;
	Pager pager;
	Strings strings;

	strings = InitStrings ();
	for (i = 1; ichr [i]. i_mnem != '\0'; i ++)
		AddStringID (strings, ichr [i]. i_name, i);

	pager = InitPager (strings, quest);
	MapPagerFromTop (pager, map_win, x, y);

	i = PagerMenu (pager);

	FreePager (pager);
	FreeStrings (strings);

	return i;
}

int SelectSellItem (x, y, quest)
int x, y;
char *quest;
{
	int i;
	Pager pager;
	Strings strings;

	strings = InitStrings ();
	for (i = 1; ichr [i]. i_mnem != '\0'; i ++)
		if ((ichr [i]. i_sell == 1) &&
		    (GiveQuant (cursct, ichr [i]. i_mnem) > 0))
			AddStringID (strings, ichr [i]. i_name, i);

	if (StringsSize (strings) == 0)
	{
		FreeStrings (strings);
		return 0;
	}

	pager = InitPager (strings, quest);
	MapPagerFromTop (pager, map_win, x, y);

	i = PagerMenu (pager);

	FreePager (pager);
	FreeStrings (strings);

	return i;
}

int SelectAvaItem (x, y, sct, quest)
int x, y;
Sector sct;
char *quest;
{
	int i;
	Pager pager;
	Strings strings;

	strings = InitStrings ();
	for (i = 1; ichr [i]. i_mnem != '\0'; i ++)
		if (GiveQuant (sct, ichr [i]. i_mnem) > 0)
			AddStringID (strings, ichr [i]. i_name, i);

	if (StringsSize (strings) == 0)
	{
		FreeStrings (strings);
		return 0;
	}
		
	pager = InitPager (strings, quest);
	MapPagerFromTop (pager, map_win, x, y);

	i = PagerMenu (pager);

	FreePager (pager);
	FreeStrings (strings);

	return i;
}
