#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "land.h"

#define DEF_MINES	10

static int last_quant = 0;

void LMine (what)
char * what;
{
	DoLMine (what, 0);
}

void RedoLMine ()
{
	if (last_layout == LAND_MODE)
		DoLMine (Fmt ("%d", ld_nr (curland)), last_quant);
	else if (last_layout == ARMY_MODE)
		DoLMine (Fmt ("%c", curarmy), last_quant);
	else
	{
		Message ("No current land/army selected");
		Bell ();
		return;
	}
}

	/* ARGSUSED */
void BindLMine (x, y, str)
int x, y;
char * str;
{
	int quant;

	if (str != (char *) 0 && sscanf (str, " ( %d )", & quant) == 1)
		last_quant = quant;
	
	RedoLMine ();
}

DoLMine (what, quant)
char * what;
int quant;
{
	char * ans;
	register Land ptr;
	int nr, n;
	int total;

	if (s_des (cursct) == '.')
	{
		Message ("You can't lay mines here!");
		Bell ();
		return;
	}

	UnmarkAllLands ();
	MarkLands (what);

	nr = 0;
	for ALL_LANDS (ptr)
		if (ld_marked (ptr))
		{
			if (! ld_owned (ptr) || ! LandHas (ptr, L_ENGINEER) ||
						      ld_she (ptr) == 0)
				set_ld_marked (ptr, False);
			else
				nr ++;
		}

	if (nr == 0)
	{
		Message ("No selected units with mine-capability / shells");
		Bell ();
		return;
	}

	if (quant <= 0)
	{
		ans = InputAtMessage (Fmt ("How many mines%s %s:",
				nr == 1 ? "" : " from each unit",
#ifndef lint
				DEF_MINES < 0 ? "" :
#endif
					Fmt ("[%d]", DEF_MINES)),
			3, GS_PNUMBER);

		if (ans == (char *) 0 || interrupt ||
					(* ans == '\0' && DEF_MINES < 0))
		{
			Message ("mine cancelled");
			Bell ();
			return;
		}

		if (* ans == '\0')
			quant = DEF_MINES;
		else
			quant = atoi (ans);
	}

	SetAgain (RedoLMine);
	last_quant = quant;
	
	if (quant == 0)
	{
		Message ("mine cancelled");
		Bell ();
		return;
	}

	total = 0;
	for ALL_LANDS (ptr)
		if (ld_marked (ptr))
		{
			n = ld_she (ptr);
			if (n == 0)
				continue;

			if (n > quant)
				n = quant;
			
			total += n;
		}
	
	if (total == 0)
	{
		Message ("No mines layed");
		Bell ();
		return;
	}

	inc_mines (cursct, total);
	if (command_state < FORCE_BUF_STATE)
	{
		FeedEmpire (Fmt ("lmine %s %d", what, quant), PRINT);
		(void) WaitForPrompt (PRINT);
	}
	else if (command_state == FORCE_BUF_STATE)
		FeedCommand (Fmt ("lmine %s %d", what, quant), PRINT);

	Message (Fmt ("%d mines layed", total));
	Census ();
}
