/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/land/RCS/landlist.c,v 5.1 93/03/14 16:47:27 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:47:27 $
    $Author: etienne $
    $Id: landlist.c,v 5.1 93/03/14 16:47:27 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	landlist.c,v $
 * Revision 5.1  93/03/14  16:47:27  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:30  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:47:37  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "census.h"
#include "nation.h"
#include "var.h"
#include "land.h"
#include "sector.h"

#define SORT_NR		0
#define	SORT_SECTOR	1
#define	SORT_TYPE	2
#define	SORT_ARMY	3
#define	SORT_OWNER	4

#define SORT_MAX_O	4
#define SORT_MAX_E	5

#define OWN  		0
#define ENEMY           1

static char * list_lands_how [] = 
{
	"sort by number",
	"sort by sector",
	"sort by army-type",
	"sort by army",
	"sort by owner",
	(char *) 0
};

static char *army_chars =
	"~abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

static int AddLandToStrings (strings, land, enemy)
Strings strings;
Land land;
{
  if ((ld_owned(land)) && (enemy == OWN))

      {
	AddString (strings, Fmt (
			       "%4d %-14.14s %4d,%-4d %c %3d%%  %3d  %3d  %3d  %3d %3d%%  %3d  %3d  %3d",
			       ld_nr (land),
			       LandName (land),
			       ld_xcd (land),
			       ld_ycd (land),
			       ld_army (land),
			       ld_eff (land),
			       ld_mob (land),
			       ld_fort (land),
			       ld_foo (land),
			       ld_fuel (land),
			       ld_retr (land),
			       ld_xpln (land),
			       ld_arad (land),
			       ld_tech (land)));
	return 1;
      }
  
  else if ( !(ld_owned(land)) && (enemy == ENEMY))

    {
      AddString (strings, Fmt (
	    "%4d %-14.14s %-14.14s %4d,%-4d %s %s",
			ld_nr (land),
			LandName (land),
			(CountryName(ld_owner (land))),
			ld_xcd (land),
			ld_ycd (land),
			ld_eff (land) ? Fmt ("%3d%% ", ld_eff (land) -1 ) : " ?? ",
			ld_tech (land) ? Fmt ("%3d", ld_tech (land) -1 ) : " ??"));
      return 1;
    }
  else
    return 0;
}

void ListLand (x, y, enemy)
int x, y, enemy;
{
	Strings strings;
	Pager pager;
	int i, j;
	int total;
	Sector sct;
	Land ptr;
	char * ch;
	bool empty_line;

	strings = InitStrings ();
	AddStringsID (strings, list_lands_how,
		      enemy == OWN ? SORT_MAX_O : SORT_MAX_E,
		      0);
	pager = InitPager (strings, "Listing of Units");
	MapPagerFromTop (pager, map_win, x, y);
	i = PagerMenu (pager);
	FreePager (pager);
	FreeStrings (strings);
	if (i < 0)
	{
		Message ("No listing");
		return;
	}

	strings = InitStrings ();
	Message ("generating list");
	if (enemy == OWN)
	  	AddString (strings, 
		     	"   #    type           x,y    a  eff  mob fort food fuel retr xpln radr tech");
	else
	  AddString (strings, "   #    type         Owner            x,y     eff tech ");
	
	total = 0;
	switch (i)
	{

	case SORT_NR:
		for ALL_LANDS (ptr)
		{
		  if (AddLandToStrings (strings, ptr, enemy))
		    {
		      empty_line = True;
		      total ++;
		    }
		}
		break;
	
	case SORT_SECTOR:
		for (x = - MAX_X / 2; x <= MAX_X / 2; x ++)
			for (y = - MAX_Y / 2; y <= MAX_Y / 2; y++)
			{
				sct = World (x, y, S_EXIST);
				if (sct == (Sector) 0)
					continue;

				empty_line = False;
				for (ptr = s_fland (sct); ptr != (Land) 0;
							ptr = ld_nxtsct (ptr))
				{
				  if (AddLandToStrings (strings, ptr, enemy))
				    {
				      empty_line = True;
				     total ++;
				   }
				}

				if (empty_line)
					AddString (strings, "");
			}
		break;
	
	case SORT_TYPE:
		for (j = 0; landtypes [j]. nam != (char *) 0; j ++)
		{
			empty_line = False;

			for ALL_LANDS (ptr)
			{
				if (ld_type (ptr) == j)
				{
				  if (AddLandToStrings (strings, ptr, enemy))
				    {
				      empty_line = True;
				      total ++;
				    }
				}
			      }
			
			if (empty_line)
				AddString (strings, "");
		}
		break;
	
	case SORT_ARMY:
		for (ch = army_chars; * ch != '\0'; ch ++)
		{
			empty_line = False;

			for ALL_LANDS (ptr)
			{
				if (ld_army (ptr) == * ch)
				  {
				  if (AddLandToStrings (strings, ptr, enemy))
				    {
				      empty_line = True;
				      total ++;
				    }
				}
			      }
			if (empty_line)
				AddString (strings, "");
		}

		break;

	case SORT_OWNER:

		for (j = 0; j < MAX_NATIONS ; j ++)
		{
			empty_line = False;

			for ALL_LANDS (ptr)
			{
				if (ld_owner (ptr) == j)
				{
				  if (AddLandToStrings (strings, ptr, enemy))
				    {
				      empty_line = True;
				      total ++;
				    }
				}
			}
			
			if (empty_line)
				AddString (strings, "");
		}
	
		break;
	}

	if (total == 0)
	{
		Message ("No info on units !");
		FreeStrings (strings);
		Bell ();
		return;
	}

	AddString (strings, Fmt ("%d units", total));
#ifdef X_VERSION
	InitWMPager (strings, "List of all units");
#else /* TERMC_VERSION */
	ShowStringsInPager (strings, "List of all units");
#endif /* VERSION */
}
