/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/land/RCS/land.c,v 5.1 93/03/14 16:47:20 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:47:20 $
    $Author: etienne $
    $Id: land.c,v 5.1 93/03/14 16:47:20 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	land.c,v $
 * Revision 5.1  93/03/14  16:47:20  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:30  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:47:37  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"
#include "land.h"
#include "var.h"
#include "version.h"

extern void 	DeleteLand();
LdType landtypes [MAX_LANDTYPES];

LdType nilland = {
	(char *) 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0, 0.0, 0, 0, 0, 0, 0, 0, 0,
	/* 0, 0, 0, 0, 0, 0, (long) ~L_KNOWN, */
	 0, 0, 0, 0, 0, 0, (long) 0,
	{ 0, 0, 0 , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } };

Land landlist = (Land) 0;

int FindLandTypeByName (name, must_exist)
char *name;
bool must_exist;
{
	register int i;
	register char *ptr;
	register char *nptr;

	for (i = 0; landtypes [i]. nam != (char *) 0; i ++)
	{
		nptr = name;
		ptr = landtypes [i]. nam;

		while (*ptr == *nptr && *ptr != '\0')
		{
			ptr ++;
			nptr ++;
		}

		if (*ptr != '\0' && *nptr != '\0')
		{
			continue;
		}
		
			/* Longer name */
		if (must_exist && *nptr != '\0')
		{
			if (ptr - landtypes [i]. nam < 15)
				continue;

			free ((char *) landtypes [i]. nam);
			landtypes [i]. nam = Str (name);
		}

		return i;
	}

	if (! must_exist)
		return -1;

	PrintAtEmpire (Fmt ("Unit \"%s\" not found in 'land-types' list",
			name));
	Bell ();
	(void) EmpireMore ();

	landtypes [i] = nilland;
	landtypes [i]. nam = Str (name);
	if (isupper (*landtypes [i]. nam))
		*landtypes [i]. nam = tolower (*landtypes [i]. nam);
	return i;
}

char *LandName (land)
Land land;
{
        return (landtypes [ld_type (land)].  nam);
}

void SetLandValues (land, land_name)
Land land;
char *land_name;
{
	int tf;

	set_ld_type (land, FindLandTypeByName (land_name, True));

	if (! ld_owned (land))
	{
		/* No way to tell which values */
		set_ld_arad (land, 0);
		return;
	}

/*
	tf = (int) TechFact (ld_tech (land),
			(double) landtypes [ld_type (land)].  spy);

	set_ld_arad (land, 0.01 * (double) tf * (double) ld_eff (land));
*/
}

bool LandOnList (land)
Land land;
{
	Land ptr;

	for (ptr = landlist; ptr != (Land) 0; ptr = ld_next (ptr))
		if (ptr == land)
			return True;
	
	return False;
}

Land NrToLand (nr)
int nr;
{
	Land ptr;

	for (ptr = landlist; ptr != (Land) 0; ptr = ld_next (ptr))
		if (ld_nr (ptr) == nr)
			return ptr;
	
	return (Land) 0;
}

void SetSectorLandsNr (sct)
Sector sct;
{
	Land ptr;

	set_land (sct, 0);
	for (ptr = s_fland (sct); ptr != (Land) 0; ptr = ld_nxtsct (ptr))
		inc_land (sct);
}

void AddLandToSector (land, to)
Land land;
Sector to;
{
	Land ptr;

	if (! LandOnList (land))
	{
		fprintf (stderr,
			"AddLandToSector : unit not on global list ??\n");
		leave ();
	}

	set_ld_xcd (land, s_xcd (to));
	set_ld_ycd (land, s_ycd (to));

	for (ptr = s_fland (to); ptr != (Land) 0; ptr = ld_nxtsct (ptr))
	{
		if (ld_nr (ptr) == ld_nr (land))
		{
			if (ptr != land)
			{
				/* impossible */
				DeleteLand (ptr);
				/* Restart Chain */
				ptr = s_fland (to);
			}
			else
			{
				SetSectorLandsNr (to);
				return;
			}
		}
	}

	set_ld_nxtsct (land, s_fland (to));
	s_fland (to) = land;
	SetSectorLandsNr (to);
}

void DeleteLandFromSector (land)
Land land;
{
	register Land ptr, prv;
	Sector from;

	from = World (ld_xcd (land), ld_ycd (land), S_DESIG);

	prv = (Land) 0;
	for (ptr = s_fland (from); ptr != (Land) 0; ptr = ld_nxtsct (ptr))
	{
		if (ptr == land)
		{
			SetSectorLandsNr (from);
			s_land (from) --;

			if (prv == (Land) 0) 
				s_fland (from) = ld_nxtsct (ptr);
			else
				set_ld_nxtsct (prv, ld_nxtsct (ptr));

			return;
		}

		prv = ptr;
	}

	fprintf (stderr,
	"Internal error (DeleteLandFromSector): unit not found at it's pos.\n");
	leave ();
}

void MoveLand (land, to)
Land land;
Sector to;
{
	Sector old;

	if (land == (Land) 0)
		return;

	DeleteLandFromSector (land);
	AddLandToSector (land, to);
}

void DeleteLand (land)
Land land;
{
	register Land ptr, prv;

	if (land == (Land) 0)
		return;

	DeleteLandFromSector (land);

	prv = (Land) 0;
	for (ptr = landlist; ptr != (Land) 0; ptr = ld_next (ptr))
	{
		if (ptr == land)
		{
			if (prv == (Land) 0)
				landlist = ld_next (landlist);
			else
				set_ld_next (prv, ld_next (land));

			if (land == curland)
				curland = ld_nxtsct (curland);
			free ((char *) land);
			return;
		}
		prv = ptr;
	}

	fprintf (stderr, "DeleteLand : unit not on global list ??\n");
	leave ();
}

void AddLandToList (land)
Land land;
{
	Land ptr;

	if (land == (Land) 0)
		return;

	if ((ptr = NrToLand (ld_nr (land))) != (Land) 0)
	{
		if (ptr == land)
			/* obviously already there */
			return;
		else
		{
			if (ptr == curland)
				curland = land;
			DeleteLand (ptr);
		}
	}

	set_ld_next (land, landlist);
	landlist = land;

}

char LandCharInSector (sct)
Sector sct;
{
	Land land;
	char let;

	if ((land = s_fland (sct)) == (Land) 0)
		return s_des (sct);
	else
	{
		let = * LandName (land);
		return toupper (let);
	}
}

bool LandAtSect (sct, let)
Sector sct;
char let;
{
	Land land;
	char slet;

	for (land = s_fland (sct); land != (Land) 0; land = ld_nxtsct (land))
	{
		slet = * LandName (land);
		if (toupper (slet) == let)
			return True;
	}

	return False;
}

bool AddEnemyLand (x, y, nr, owner, ptr, eff, tech)
int x, y, nr, owner, eff, tech;
char *ptr;
{
	Land new;
	Sector to;

	to = World (x, y, S_DESIG);

	if ((new = NrToLand (nr)) != (Land) 0)
	{
		/* It's already on list just move it (Might not have moved) */
		if (owner != ld_owner (new))
		{
			PrintAtEmpire (Fmt (
				"%s (#%d) changed hands from %s to %s",
				LandName (new), nr, CountryName (new-> owner),
				CountryName (owner)));
			set_ld_owner (new, owner);
		}
		if (eff) {
			set_ld_eff (new, eff);
		} 
		if (tech) {
			set_ld_tech (new, tech);
		}

		if (ld_xcd (new) == x && ld_ycd (new) == y)
			return False;
		
		set_ld_oldpos (new, ld_xcd (new), ld_ycd (new));
		set_ld_time (new, time ((time_t *) 0));
		set_ld_marked (new, False);
		MoveLand (new, to);
		return True;
	}

	new = (Land) doalloc ((unsigned) sizeof (struct l_land));
	bzero (new, sizeof (struct l_land));
	set_ld_owner (new, owner);
	set_ld_nr (new, nr);
	set_ld_army (new, '~');
	set_ld_time (new, (time_t) 0);
	set_ld_marked (new, False);
	if (eff != -1) {
		set_ld_eff (new, eff);
		set_ld_tech (new, tech);
		set_ld_rad (new, True);  /* use rad for spy-mark */
	} else
		set_ld_rad (new, False);

	SetLandValues (new, ptr);
	AddLandToList (new);
	AddLandToSector (new, to);
	return True;
}


int GiveLandQuant (land, item)
Land land;
char item;
{
	if (land == (Land) 0)
	{
		fprintf (stderr, "GiveLandQuant : NIL land ??\n");
		leave ();
	}

	switch (item)
	{

	case 'O': return ld_owner (land);
	case 'F': return (int) ld_army (land);   /* Ugly !! */
	case 'R': return ld_arad (land);
	case 'N': return ld_nr (land);
	case 'x': return ld_xcd(land);
	case 'y': return ld_ycd (land);
	case 't': return ld_type (land);

	}

	if  (! deity && ! ld_owned (land))
		return 0;

	switch (item)
	{

	case 'E': return ld_eff (land);
	case 'T': return ld_tech (land);
	case 'M': return ld_mob (land);
	case 'f': return ld_foo (land);
	case 's': return ld_she (land);
	case 'g': return ld_gun (land);
	case 'p': return ld_pet (land);
	case 'i': return ld_iron (land);
	case 'd': return ld_dust (land);
	case 'b': return ld_bar (land);
	case 'o': return ld_oil (land);
	case 'l': return ld_lcm (land);
	case 'h': return ld_hcm (land);
	case 'r': return ld_rad (land);
	case 'w': return ld_xpln (land);
        case 'e': return ld_fuel (land);
        case 'm': return ld_retr (land);
	default:  return 0;

	}
}

int MaxLandCargo (land, itemchar)
Land land;
char itemchar;
{
	int item;

	if (land == (Land) 0)
	{
		fprintf (stderr, "MaxLandCargo : NIL land ??\n");
		leave ();
	}

	if(itemchar == 'e')
	{
		return (landtypes [ld_type (land)]. fcar);
	}

	item = CharToItem (itemchar);
	return landtypes [ld_type (land)].  car [item];
}

char * GiveLandQuantStr (land, id)
Land land;
char id;
{
	int i;
	char *ptr;

	if (land == (Land) 0)
	{
		fprintf (stderr, "GiveLandQuantStr : NIL land ??\n");
		leave ();
	}

	i = GiveLandQuant (land, id);
	ptr = Fmt ("%-4d", i);

	switch (id)
	{

	case 'E':
		return Fmt ("%-3d%%", ld_eff (land));
	case 'O':
	case 'N':
	case 'T':
	case 'M':
		return ptr;
	case 'R':
		if (ld_arad (land) > 0)
			return ptr;
		else
			return "--  ";
	case 'F':
		return Fmt (" %c  ", ld_army (land));
	case 'P':
	case 'c':
	case 'm':
	case 'u':
	case 'f':
	case 's':
	case 'g':
	case 'p':
	case 'i':
	case 'd':
	case 'b':
	case 'o':
	case 'l':
	case 'h':
	case 'r':
	case 'e':
	case 'w':
	case 'z':
	case 'L':
		if (i > 0)
			return ptr;
		if (MaxLandCargo (land, id) == 0)
			return "--  ";
		break;
	default:
		return "??  ";
	}
	return "    ";
}

void SetLandQuant (land, item, value)
Land land;
char item;
int value;
{
	if (land == (Land) 0)
	{
		fprintf (stderr, "SetLandQuant : NIL land ??\n");
		leave ();
	}

	if  (!deity && ! ld_owned (land))
		return;

	switch (item)
	{

	case 'R': { set_ld_arad (land, value); break; }
	case 'm': { set_ld_retr (land, value); break; }
	case 'f': { set_ld_foo  (land, value); break; }
	case 's': { set_ld_she  (land, value); break; }
	case 'g': { set_ld_gun  (land, value); break; }
	case 'p': { set_ld_pet  (land, value); break; }
	case 'i': { set_ld_iron (land, value); break; }
	case 'd': { set_ld_dust (land, value); break; }
	case 'b': { set_ld_bar  (land, value); break; }
	case 'o': { set_ld_oil  (land, value); break; }
	case 'l': { set_ld_lcm  (land, value); break; }
	case 'h': { set_ld_hcm  (land, value); break; }
	case 'r': { set_ld_rad  (land, value); break; }
	case 'F': { set_ld_army (land, value); break; }
	case 'e': { set_ld_fuel (land, value); break; }
	case 'w': { set_ld_xpln (land, value); break; }
	default:  
		if (! deity)
			return;
		switch (item) {
		case 'O': { set_ld_owner (land, value); break; }
		case 'T': { set_ld_tech  (land, value); break; }
		case 'E': { set_ld_eff   (land, value); break; }
		case 'M': { set_ld_mob   (land, value); break; }
		default:  
			return;
		}
	}
}

bool LandHasRadar (land)
Land land;
{
	return (landtypes [ld_type (land)]. rad >= 1);
}

bool LandHas (land, flags)
Land land;
long flags;
{
        return BIT_SET (landtypes [ld_type (land)]. flags, flags);
}

void MoveLandTo (land, sct)
Land land;
Sector sct;
{
	DeleteLandFromSector (land);
	AddLandToSector (land,sct);
}

void DeleteEnemyLands ()
{
	Land land, nland;

	for (land = landlist; land != (Land) 0; land = nland)
	{
		nland = ld_next (land);
		if (ld_owner (land) != my_cnum)
			DeleteLand (land);
	}
}

Land AskLand (x, y, quest, allow_others)
int x, y;
char *quest;
bool allow_others;
{
	Strings strings;
	Pager pager;
	Land land;
	int select;

	strings = InitStrings ();

	for (land = landlist; land != (Land) 0; land = ld_next (land))
	{
		if (! allow_others && ! deity && ld_owner (land) != my_cnum)
			continue;
		AddStringID (strings, Fmt ("#%d @%d,%d %-18s%s",
						ld_nr (land),
						ld_xcd (land), ld_ycd (land),
						LandName (land),
					deity ? Fmt (" owner %s", 
						CountryName (ld_owner (land)))
					        : ""), ld_nr (land));
	}
	if (StringsSize (strings) == 0)
	{
		FreeStrings (strings);
		Message ("No Lands !!");
		Bell ();
		return ((Land) 0);
	}

	pager = InitPager (strings, quest);
	MapPagerFromTop (pager, map_win, x, y);
	select = PagerMenu (pager);
	FreePager (pager);
	FreeStrings (strings);

	if (select < 0)
		return ((Land) 0);

	return NrToLand (select);
}

void ArmyAdd (x, y)
int x, y;
{
	char first_free;
	char * quest;
	char * ans;
	char * lands;
	Land ptr;
	char fl;

	first_free = FirstFreeArmy ();

	if (first_free == '\0')
		quest = "Add to which army [all used]: ";
	else
		quest = Fmt ("Add to which army [%c]: ", first_free);

	Bell ();
	ans = InputAtMessage (quest, 1, "a-zA-Z~");
	if (ans == (char *) 0 || interrupt)
	{
		interrupt = False;
		Message ("Armyadd cancelled");
		return;
	}

	if (* ans == '\0' && first_free == '\0')
	{
		Message ("You must specify a army !");
		Bell ();
		return;
	}

	fl = * ans == '\0'  ? first_free : * ans;
	
	lands = (char *) SelectLands (x, y, LD_ARMYADD, "Select unit(s) to add");
	if (lands == (char *) 0)
		return;

		/*
		 *	Select lands marks the selected lands
		 */
		
	MarkLands (lands);
	for ALL_LANDS (ptr)
		if (ld_marked (ptr))
			set_ld_army (ptr, fl);

	FeedCommand (Fmt ("army %c %s", fl, lands), PRINT);
	UnmarkAllLands ();
}

char * LandCargoNames (cargo)
int cargo[];
{
	int i;
	static char buffer [100];

	buffer [0] = '\0';

	for (i = 1; i < V_MAX; i++)
		if (cargo [i] > 0)
			strcat (buffer, Fmt (" %d%c", cargo [i], ItemChar (i)));
	
	return buffer;
}

bool PortableLand (land)
Land land;
{
	if (LandHas (land, L_LIGHT))
		return True;
	else
		return False;
}

char * LandCapNames (flags)
long flags;
{
	static char buffer [100];

	buffer [0] = '\0';

	if (BIT_SET (flags, L_SUPPLY))
		strcat (buffer, " supply");
	if (BIT_SET (flags, L_LIGHT))
		strcat (buffer, " light");
	if (BIT_SET (flags, L_RECON))
		strcat (buffer, " recon");
	if (BIT_SET (flags, L_RADAR))
		strcat (buffer, " radar");
	if (BIT_SET (flags, L_ASSAULT))
		strcat (buffer, " assault");
	if (BIT_SET (flags, L_SECURITY))
		strcat (buffer, " security");
	if (BIT_SET (flags, L_ENGINEER))
		strcat (buffer, " engineer");
	if (BIT_SET (flags, L_MARINE))
		strcat (buffer, " marine");
	if (!BIT_SET (flags, L_KNOWN))
		strcat (buffer, " unknown");
	
	return buffer;
}

void ShowLandCBStrings (strings)
Strings strings;
{
	int i;
	int maint;

	AddString (strings, Fmt ("%s %s",
		"Name             lcm hcm mil guns shells  cost  maint tech att",
		 "def vul spd vis spy rad frg acc dam amm aaf fus fca xpl ava flags"));
	AddString (strings, "");

	for (i = 0; landtypes [i]. nam != (char *) 0; i ++)
	{
		maint = (int) (etu_per_update * - dmin (0.0,
				landtypes [i]. cos * money_land));

 	  	AddString (strings, Fmt (
  "%-16.16s %-3d %-3d %-3d  %-3d   %-3d   %-6s %-4s %-4d %-3s %-3s %-3d %-3d %-3d %-3d %-3d %-3d %-3d %-3d %-3d %-3d %-3d %-3d %-3d %-3d %s %s",
				landtypes [i]. nam,
				landtypes [i]. lcm,
				landtypes [i]. hcm,
				landtypes [i]. mil,
				landtypes [i]. guns,
				landtypes [i]. shells,
				Fmt ("$%d", landtypes [i]. cos),
				Fmt ("$%d", maint),
				landtypes [i]. tec,
				Fmt ("%.1f", landtypes [i]. att),
				Fmt ("%.1f", landtypes [i]. def),
				landtypes [i]. vul,
				landtypes [i]. spd,
				landtypes [i]. vis,
				landtypes [i]. spy,
				landtypes [i]. rad,
				landtypes [i]. frg,
				landtypes [i]. acc,
				landtypes [i]. dam,
				landtypes [i]. amm,
				landtypes [i]. aaf,
				landtypes [i]. fuse,
				landtypes [i]. fcar,
				landtypes [i]. xpl,
				landtypes [i]. ava,
				LandCargoNames (landtypes [i]. car),
				LandCapNames (landtypes [i]. flags)));
	}

}

void PageShowLandCSBs ()
{
	Strings strings;

	strings = InitStrings ();
	ShowLandCBStrings (strings);

	if (StringsSize (strings) == 2)
	{
		Message ("You don't know about units yet");
		Bell ();
		FreeStrings (strings);
		return;
	}

#ifdef TERMC_VERSION
	ShowStringsInPager (strings, "show land c&b&s");
#else /* TERMC_VERSION */
	InitWMPager (strings, "show land c&b&s");
#endif /* TERMC_VERSION */
}

double LandFireRange (land)
Land land;
{
	return (landtypes [ld_type (land)].frg);
}

int LandMaxGuns (land)
Land land;
{
	return landtypes [ld_type (land)]. acc;
}

Sector LandSector (land)
Land land;
{
	return World (ld_xcd (land), ld_ycd (land), S_EXIST);
}

bool SectorHasOwnedLands (sct, n)
Sector sct;
int n;
{
	int i;
	Land ptr;

	i = 0;
	for (ptr = s_fland (sct); ptr != (Land) 0; ptr = ld_nxtsct (ptr))
		if (ld_owned (ptr))
			if (++ i == n)
				return True;
	
	return False;
}

bool LandAtWith (sct, flag)
Sector sct;
long flag;
{
	register Land ptr;

	for (ptr = s_fland (sct); ptr != (Land) 0; ptr = ld_nxtsct (ptr))
		if (LandHas (ptr, flag))
			return True;
	
	return False;
}

