/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/commands/RCS/market.c,v 5.1 93/03/14 16:45:43 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:45:43 $
    $Author: etienne $
    $Id: market.c,v 5.1 93/03/14 16:45:43 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	market.c,v $
 * Revision 5.1  93/03/14  16:45:43  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:18:04  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:32:23  greyhelm
 * Client for ASCII /X Empire client
 * Added RCS header - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"

static int last_quant;
static double last_price;
static char last_comm;

void DoSell ();
double atof ();
#define GS_PFNUMBER	"+0-9."

/* ARGSUSED */
void BindSell (x, y, str)	/* sell (com, quant, price) */
int x, y;
char * str;
{
	char *ans;
	int quant;
	double price;
	char com[20];

	if (str == (char *) 0)
		SingleSell (x, y);
	else
		switch (sscanf (str, " ( %[^,], %d, %g )",
				com, & quant, &price))
		{

		    case 0:
			SingleSell (x, y);
			return;
		
		    case 1:
			if (CharToItem (* com) < 0)
			{
				Message ("Illegal bind: 'sell (comm, #, $)'");
				Bell ();
				return;
			}
			ans = InputAtMessage ("Quantity to Sell? ",
					      4, GS_NUMBER);
			if (ans == (char *)0 || interrupt || * ans == '\0')
			{
				interrupt = False;
				Message ("Sale cancelled");
				return;
			}
			quant = atoi (ans);

			ans = InputAtMessage ("Price to sell at? ", 4, GS_PFNUMBER);
			if (ans == (char *)0 || interrupt || * ans == '\0')
			{
				interrupt = False;
				Message ("Sale Cancelled");
				return;
			}
			price = atof(ans);

			DoSell (CrdStr (cursct), * com, quant, price);
			return;
		
		    case 2:
			if (CharToItem (* com) < 0 || quant <= 0)
			{
				Message ("Illegal bind: 'sell (comm, #, $)'");
				Bell ();
				return;
			}
			ans = InputAtMessage ("Price to sell at? ", 4, GS_PFNUMBER);
			if (ans == (char *)0 || interrupt || * ans == '\0')
			{
				interrupt = False;
				Message ("Sale Cancelled");
				return;
			}
			price = atof(ans);

			DoSell (CrdStr (cursct), * com, -quant, price);
			return;
		    case 3:
			if (CharToItem (* com) < 0 || quant <= 0 || price <= 0)
			{
				Message ("Illegal bind: 'sell (comm, #, $)'");
				Bell ();
				return;
			}

			DoSell (CrdStr (cursct), * com, -quant, price);
			return;
		}
}

	/*
	 *	RedoSell, repeat a sale
	 */

/* ARGSUSED */
void RedoSell (x, y)
int x, y;
{
	DoSell (CrdStr(cursct), last_comm, last_quant, last_price);
}


void DoSell (realm, comm, quant, price)
char *realm;
char comm;
int quant;
double price;
{
	char *ptr;
	Sector sct;
	char *itemname;
	int item;
	int tot_sold = 0;
        int sx, sy, ex, ey;
	int x, y;
	int available;

	(void) ConvRealmToCoord (realm, &sx, & sy, & ex, &ey);

	item = CharToItem (comm);
	itemname = ItemName (item);
	SetAgain (RedoSell);
	last_price = last_quant = 0;
	last_comm = comm;


	Message ("Current command: sell");

	FeedCommand (Fmt ("sell %c %s %d %f",
			  comm, realm, quant,
			  price), PRINT);

	for (y = sy; y <= ey; y ++)
		for (x = sx; x <= ex; x++)
		{
			sct = World (x, y, S_EXIST);

			if (sct == (Sector)0 || ! s_owned (sct))
				continue;

			available = GiveQuant (sct, comm);
			if (available <= 0)
				continue;
			if (quant > 0) {
				available -= quant;
				if (available <= 0)
					continue;
			}
			else
				available = available < -quant ?
					available : -quant;
			tot_sold += available;
			SetQuant (sct, comm,
				  GiveQuant (sct, comm) - available);
			DrawSector (sct);
		}
	if (tot_sold > 0)
		price = (double)ItemWeight (item, NPKG) *
			 (double)tot_sold / 10.0;
	Message (Fmt ("Put %d %s on the market, tax of $%d",
		 tot_sold, itemname, (int)price));
}

MultiSell (x,y)
int x,y;
{
	char *ptr;
	int quant; 
	double price;
	int item;
	char *realm;
	char itemchar, *itemname;

	item = SelectSellItem (x + 4, y + 4, "Sell what ?");

	if (item <= 0)
	{
		Message ("Nothing sold");
		return;
	}

	itemchar = ItemChar (item);
	itemname = ItemName (item);

	ptr = InputAtMessage (Fmt (
				   "Sell how many %s:",
				   itemname), 4, GS_PNUMBER);

	if (interrupt || ptr == (char *) 0 || *ptr == '\0')
	{
		interrupt = False;
		Message ("Changed your mind ??");
		return;
	}
	quant = atoi (ptr);

	ptr = InputAtMessage (Fmt ("Sell %d %s at what price? ",
				   quant, itemname), 4, GS_PFNUMBER);
	if (interrupt || ptr == (char *)0 || *ptr == '\0') {
		interrupt = False;
		Message ("Changed your mind ??");
		return;
	}

	price = atof (ptr);

	while ((realm = MySelRealm ()) != (char *)0)
		DoSell (realm, itemchar, quant, price);
	Message ("Multi sale completed");
}


SingleSell (x, y)
int x,y;
{
	char *ptr;
	int quant;
	double price;
	int item;
	int available;
	char itemchar, *itemname;

	item = SelectSellItem (x + 4, y + 4, "Sell what ?");

	if (item <= 0)
	{
		Message ("Nothing sold");
		return;
	}

	itemchar = ItemChar (item);
	itemname = ItemName (item);

	available = GiveQuant (cursct, itemchar);
	if (available == 0)
	{
		Message (Fmt ("There is no (more) %s in this sector",
			      itemname));
		Bell ();
		return;
	}

	if (available > 1)
	{
		ptr = InputAtMessage (Fmt (
					   "Sell how many %s [%d]:",
					   itemname, available), 4, GS_PNUMBER);

		if (interrupt || ptr == (char *) 0)
		{
			interrupt = False;
			Message ("Changed your mind ??");
			return;
		}
		else if   (*ptr == '\0')
			quant = available;
		else 
			quant = atoi (ptr);
	}
	else
		quant = 1;

	if (quant > available)
	{
		quant = available;
		Error (Fmt (
			    "Warning: only selling %d %s", quant, itemname));
		if (interrupt)
			return;
	}

	ptr = InputAtMessage (Fmt ("Sell %d %s at what price? ",
				   quant, itemname), 4, GS_PFNUMBER);
	if (interrupt || ptr == (char *)0 || *ptr == '\0') {
		interrupt = False;
		Message ("Changed your mind ??");
		return;
	}

	price = atof (ptr);

	DoSell (CrdStr (cursct), itemchar, -quant, price);
}
