/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/commands/RCS/fire.c,v 5.1 93/03/14 16:44:30 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:44:30 $
    $Author: etienne $
    $Id: fire.c,v 5.1 93/03/14 16:44:30 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	fire.c,v $
 * Revision 5.1  93/03/14  16:44:30  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:18:04  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:32:23  greyhelm
 * Client for ASCII /X Empire client
 * Added RCS header - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "ship.h"
#include "nation.h"

static char * last_target = (char *) 0;
static int last_guns = -1;

static void ParseFireOutput (sct, ship)
Sector sct;
Ship ship;
{
	Ship vship;
	char * ptr, * ans;
	char * ptri;
	char word [40];
	int dam;
	int shipnr;
	bool rescan;
	int x_coord, y_coord;

	rescan = False;
	for (;;)
	{
		ptr = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () == E_COMMAND)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (ptr);
			if (rescan)
			{
				if (sct != (Sector) 0)
					RedumpSector (sct, DONT_PRINT);
				else
				{
					x_coord = sh_xcd (ship);
					y_coord = sh_ycd (ship);
					if (DumpShips (Fmt ("%d", sh_nr (ship)),
							DONT_PRINT) == 0)
					{
						Warning (	
						       "You lost you're ship!");
						DrawMap (World (x_coord, 
							y_coord, S_DESIG));
					}
				}
			}
			return;
		}
		
		PrintAtEmpire (ptr);
		if (EmpireStatus () == E_QUESTION)	/* treaty ? */
		{
			ans = InputAtMessage (ptr, 20, GS_TEXT);
			if (ans == (char *) 0 || interrupt)
			{
				interrupt = False;
				while (EmpireStatus () != E_COMMAND)
				{
					FeedEmpire ("aborted", PRINT);
					(void) WaitForPrompt (PRINT);
				}

				Message ("Fire aborted");
				Bell ();
			}

			FeedEmpire (ans, PRINT);
		}

		if (StrEQ (ptr, "CAPTAIN!  !!Depth  charges"))
		{
			Bell ();
			Message ("Depthcharges !");
			rescan = True;
		}

		if (sscanf (ptr, "Incoming shell! %d%%", & dam) == 1 ||
		    sscanf (ptr, "\007Incoming shell does %d%%", & dam) == 1 ||
		    sscanf (ptr, "\007Incoming shells do %d%%", & dam) == 1)
		{
			Bell ();
			Message ("Incoming shells !");
			rescan = True;
			continue;
		}

		ptri = index (ptr, '#');
		if (ptri != (char *) 0)
		{
			ptri ++;
			if (! ScanDigit (& ptri, & shipnr))
				continue;
			
		/* Haz: KSU has an alternate sunk message */
			if (ksu_version && * ptri == ')')
				ptri++;

			if (! ScanWord (& ptri, word) ||
						strcmp (word, "sunk!") != 0)
				continue;

			Message (Fmt ("PLEP: %s", ptr));

			vship = NrToShip (shipnr);
			x_coord = sh_xcd (vship);
			y_coord = sh_ycd (vship);
			DeleteShip (vship);
			DrawSector (World (x_coord, y_coord, S_DESIG));
			if (last_target != (char *) 0)
				free (last_target);
			last_target = (char *) 0;
		}

	}
}

static char * SelectTarget (fromx, fromy, maxdist, dept, is_sub)
int fromx, fromy;
int maxdist;
bool * dept;	/* allow shooting at subs ? */
bool is_sub;
{
	int x, y;
	int button;
	int dist;
	Sector sct;
	Sector csct;
	Ship ship;
	Ship cship;

	csct = cursct;
	cship = curship;
	Message (Fmt ("Select Target to shoot at %s",
		is_sub ? "(ships only)" : "(ship/sector)"));
	MesBut ("View", "Cancel", "FIRE");

	for (;;)
	{
		if (! SelectSctCrd (& x, & y, & button) ||
							button == MIDDLE_BUTTON)
		{
			Message ("Fire cancelled");
			ClearMes ();
			MesClearBut ();
			return (char *) 0;
		}

		sct = World (x, y, S_EXIST);
		if (sct == (Sector) 0)
			continue;

		if (button == RIGHT_BUTTON)
		{
			dist = Dist (fromx, x, fromy, y);
			if (dist > maxdist)
			{
				Message (Fmt ( "Target too far away (range %d)",
					maxdist));
				Bell ();
				continue;
			}

			if (curship != (Ship) 0)
			{
				if (ShipHas (curship, M_SUB))
				{
					if (! * dept && ! is_sub)
					{
						Message (
						       "You can't fire @ subs");
						Bell ();
						continue;
					}
					else
					{
						if ((! is_sub) &&
						   (sh_xcd (curship) != fromx ||
						    sh_ycd (curship) != fromy))
						{
		Message ("Must be in the same sector for a deptcharge !");
							Bell ();
							continue;
						}

						* dept = True;
					}
				}
				else
					* dept = False;

				if (sh_owned (curship) && ! Confirm (
				           "That's your own ship, still fire?"))
					continue;

				ClearMes ();
				MesClearBut ();
				ship = curship;
				cursct = csct;
				curship = cship;
				CensusShip (cship);
				return Fmt ("%d", sh_nr (ship));
			}
			else
			{
				if (is_sub)
				{
					Message ("You can't torpedo land");
					Bell ();
					continue;
				}

				if (sct != cursct)
					cursct = sct;
					
				if (s_des (sct) == 's')
				{
					Message ("They're protected");
					Bell ();
					continue;
				}

				if (s_des (sct) == '.' || s_des (sct) == '\\')
				{
					Message ("Useless target");
					Bell ();
					continue;
				}

				* dept = False;
			}


			if (s_owned (sct) && ! Confirm (
				   "That's your own sector, still fire?"))
				continue;

			ClearMes ();
			MesClearBut ();
			cursct = csct;
			curship = cship;
			CensusSct (csct);
			return CrdStr (sct);
		}

		if (button != LEFT_BUTTON)
			continue;
		
		if (cursct == sct)
		{
			if (curship == (Ship) 0)
				curship = s_fship (sct);
			else
				curship = sh_nxtsct (curship);
		}
		else
		{
			cursct = sct;
			curship = (Ship) 0;
		}


		CensusShip (curship);
	}

	/* NOTREACHED */
}

static void DoFireFromSector ();

void FireFromSector ()
{
	DoFireFromSector ((char *) 0);
}

void RedoFireFromSector ()
{
	DoFireFromSector (last_target);
}

static void DoFireFromSector (target)
char * target;
{
	Sector from_sector;

	int guns;
	int range;

	char * mes;
	bool dept;

	from_sector = cursct;

	if (! s_owned (from_sector))
	{
		Message ("You don't own that sector !");
		Bell ();
		return;
	}
	
	mes = (char *) 0;

	if (s_des (from_sector) != 'f')
		mes =  "You can only fire from a fortress";

	guns = q_gun (from_sector);
	if (guns == 0)
		mes = "No guns here";

	if (q_she (from_sector) == 0)
		mes = "Klick, no more shells";

	if (s_mil (from_sector) < 5)
		mes = "Need 5 militairs";

	if (mes != (char *) 0)
	{
		Message (mes);
		Bell ();
		return;
	}

	if (guns > 7)
		guns = 7;

	range = TechFact ((int) n_tech (nation), (double) guns);
	if (range > 7)
		range = 7;

	dept = False;

	if (target == (char *) 0)
		target = SelectTarget (s_xcd (from_sector), s_ycd (from_sector),
					range, & dept, False);
	
	if (target == (char *) 0)
		return;
		
	if (last_target != (char *) 0)
		free (last_target);
	last_target = Str (target);
	SetAgain (RedoFireFromSector);
        if(chainsaw_version) {
	    FeedEmpire (Fmt ("fire sect %s %s", CrdStr (from_sector)), target, PRINT);
	} else {
	    FeedEmpire (Fmt ("fire %s %s", target, CrdStr (from_sector)), PRINT);
	}
	set_q_she (from_sector, q_she (from_sector) - 1);
	ParseFireOutput (from_sector, (Ship) 0);
	cursct = from_sector;
	CensusSct (cursct);
}

void MultiFire ()
{
	Sector from_sector;
	char *target;

	int guns;
	int range;

	char * mes;
	bool dept;

	from_sector = cursct;
	target = ((char *) 0);

	mes = "WARNING - Multi-Fire uses REALM 0 set it properly!!!!";

	Message (mes);
	Bell();
	(void) EmpireMore();

	if (guns > 7)
		guns = 7;

	range = TechFact ((int) n_tech (nation), (double) guns);
	if (range > 7)
		range = 7;

	dept = False;

	if (target == (char *) 0)
		target = SelectTarget (s_xcd (from_sector), s_ycd (from_sector),
					range, & dept, False);
	
	if (target == (char *) 0)
		return;
		
	if (last_target != (char *) 0)
		free (last_target);
	last_target = Str (target);
	SetAgain (MultiFire);
        if(chainsaw_version) {
	    FeedEmpire (Fmt ("fire sect # %s", CrdStr (from_sector)), target, PRINT);
	} else {
	    FeedEmpire (Fmt ("fire %s %s", target, CrdStr (from_sector)), PRINT);
	}
	set_q_she (from_sector, q_she (from_sector) - 1);
	ParseFireOutput (from_sector, (Ship) 0);
	cursct = from_sector;
	CensusSct (cursct);
}

void FireFromShip ()
{
	DoFireFromShip ((char *) 0, -1);
}

void RedoFireFromShip ()
{
	DoFireFromShip (last_target, last_guns);
}

void DoFireFromShip (target, guns)
char * target;
int guns;
{
	Ship from_ship;
	Sector from_sct;
	char * ans;

	int nr_guns, shells;
	double range;

	char * mes;
	bool dept;

	from_ship = curship;
	from_sct = cursct;

	if (from_ship == (Ship) 0)
	{
			/* set current, again, no ship ? */
		Message ("Ship-fire without a ship ?");
		Bell ();
		return;
	}

	if (! sh_owned (from_ship))
	{
		Message ("You don't own that ship !");
		Bell ();
		return;
	}

	if (! ksu_version && ShipHas (from_ship, M_SUB))
	{
		DoFireFromSub ( (char *) 0 );
		return;
	}
	mes = (char *) 0;

	if (sh_eff (from_ship) < 60)
		mes = "Ship is crippled";

	shells = sh_she (from_ship);
	if (shells == 0)
		mes = "Klick, no more shells";

	if (sh_gun (from_ship) == 0)
		mes = "No guns";

	if (sh_mil (from_ship) == 0)
		mes = "No mils to fire !";

	nr_guns = ShipMaxGuns (from_ship);

	range = ShipFireRange (from_ship);

	if (nr_guns == 0 || range == 0.0)
		mes = Fmt ("You can't fire from a %s", ShipName (from_ship));

	if (mes != (char *) 0)
	{
		Message (mes);
		Bell ();
		return;
	}

	dept = ShipHas (from_ship, M_DCHRG);

	if (target == (char *) 0)
		target = SelectTarget (sh_xcd (from_ship), sh_ycd (from_ship),
					(int) range, & dept, False);
	
	if (target == (char *) 0)
	{
		Message ("fire cancelled");
		return;
	}

	if (dept)
	{
		if (shells < 2)
		{
			Message ("You need two shells for a deptcharge");
			Bell ();
			return;
		}

		guns = 2;
	}
	else
	{
		if (shells < nr_guns)
		{
			Message (Fmt ("Only %d shell%s left"),
				shells, 
				shells > 1 ? "s" : "");
			Bell ();
			nr_guns = shells;
		}

		if (nr_guns == 1)
			guns = 1;
		else
		{
			if (guns <= 0)
			{
				ans = InputAtMessage (Fmt (
						"Fire how many guns [%d]:",
						nr_guns), 2, GS_PNUMBER);

				if (ans == (char *) 0 || interrupt)
				{
					Message ("Fire cancelled");
					return;
				}

				if (* ans == '\0')
					guns = nr_guns;
				else
				{
					guns = atoi (ans);
					if (guns > nr_guns)
					{
						Bell ();
						guns = nr_guns;
					}
				}
			}
		}
	}

	if (guns == 0)
	{
		Message ("Fire cancelled");
		return;
	}

	if (target == (char *) 0)
		return;
		
	if (last_target != (char *) 0)
		free (last_target);

	last_target = Str (target);
	last_guns = guns;

	SetAgain (RedoFireFromShip);

	if(chainsaw_version) {
  	   FeedEmpire (Fmt ("fire ship %d %s",
			sh_nr (from_ship),
			target),
		PRINT);
	} else { 
  	   FeedEmpire (Fmt ("fire %s %d %d",
			target,
			sh_nr (from_ship),
			guns),
		PRINT);
	}

	set_sh_she (from_ship, sh_she (from_ship) - guns);
	ParseFireOutput ((Sector) 0, curship);

	cursct = from_sct;
	curship = from_ship;
	CensusShip (curship);
}

void Torpedo()
{
	DoFireFromSub ( (char *) 0 );
}

void RedoFireFromSub ()
{
	DoFireFromSub (last_target);
}

void DoFireFromSub (target)
char * target;
{
	bool dept;
	double range;
	Ship from_ship;
	Sector from_sector;

	from_ship = curship;
	from_sector = cursct;

	if (ksu_version)
	{
		if (from_ship == (Ship) 0)
		{
				/* set current, again, no ship ? */
			Message ("Ship-torpedo without a ship ?");
			Bell ();
			return;
		}

		if (! sh_owned (from_ship))
		{
			Message ("You don't own that ship !");
			Bell ();
			return;
		}

		if (! ShipHas (from_ship, M_TORP))
		{
			Message ("Ship does not have torpedo ability.");
			Bell();
			return;
		}
	}

	if (sh_eff (from_ship) < 60)
	{
		Message ("Ship is crippled");
		Bell ();
		return;
	}

	if (sh_she (from_ship) < 3)
	{
		Message ("Not enough shells (need three)");
		Bell ();
	}

	if (sh_gun (from_ship) == 0)
	{
		Message ("You need a gun to fire torpedo's");
		Bell ();
		return;
	}

	if (sh_mob (from_ship) <= 0)
	{
		Message ("Not enough mobility");
		Bell ();
		return;
	}

	range = sh_eff (from_ship) *
				TechFact (sh_tech (from_ship), 2.0) / 100.0;
	dept = False;
	if (target == (char *) 0)
		target = SelectTarget (s_xcd (cursct), s_ycd (cursct),
				(int) range, & dept, True);
	
	if (target == (char *) 0)
	{
		Message ("Torpedo cancelled");
		Bell ();
		return;
	}

	if (last_target != (char *) 0)
		free (last_target);

	last_target = Str (target);
	last_guns = 0;

	if (ksu_version)
		SetAgain (RedoFireFromSub);
	else
		SetAgain (RedoFireFromShip);

	FeedEmpire (Fmt ("torpedo %s %d", target, sh_nr (from_ship)), PRINT);

	set_sh_mob (from_ship, sh_mob (from_ship) - 20);
	set_sh_she (from_ship, sh_she (from_ship) - 3);

	ParseFireOutput ((Sector) 0, curship);

	cursct = from_sector;
	curship = from_ship;
	CensusShip (curship);
}
