/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/commands/RCS/enlist.c,v 5.1 93/03/14 16:44:27 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:44:27 $
    $Author: etienne $
    $Id: enlist.c,v 5.1 93/03/14 16:44:27 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	enlist.c,v $
 * Revision 5.1  93/03/14  16:44:27  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:18:04  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:32:23  greyhelm
 * Client for ASCII /X Empire client
 * Added RCS header - Karl Hagen
 *

*/
	/*
	 *	enlist.c
	 */
	
#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"

static int last_quant;

void RedoEnlist ()
{
	DoEnlist (CrdStr (cursct), last_quant);
}

	/* ARGSUSED */
void BindEnlist (x, y, str)	/* enlist (10) */
int x, y;
char * str;
{
	int number;

	if (str == (char *) 0 || sscanf (str, "( %d )", & number) == 0)
		SingleEnlist ();
	else
		DoEnlist (CrdStr (cursct), number);
}

void DoEnlist (realm, quant)
char * realm;
int quant;
{
	char * ptr;
	int newv, nr;
	int x, y;
	Sector sct;
	int tot_enl;
	int n;
	int sx, sy, ex, ey;
	int newmil;
	bool quota;
	char * ans;

	SetAgain (RedoEnlist);
	last_quant = quant;

	if (quant > 500)
		quant = 500;

	(void) ConvRealmToCoord (realm, & sx, & sy, & ex, & ey);
	tot_enl = 0;
	n = 0;
	if ((command_state == TEST_STATE || command_state == FORCE_BUF_STATE)
		&& EmpireStatus () != E_COMMAND)
	{
		if (command_state == FORCE_BUF_STATE)
			FeedCommand (Fmt ("enlist %s %d", realm, quant), PRINT);

		if (quant < 0)
		{
			quota = True;
			quant = -quant;
		}
		else
			quota = False;

		for (y = sy; y <= ey; y ++)
			for (x = sx; x <= ex; x ++)
			{
				sct = World (x, y, S_EXIST);

					/*
					 *	No way to test loyality
					 */

				if (sct == (Sector) 0 || ! s_owned (sct) ||
							 s_occ (sct) == '*')
					continue;
				
				if (n_mil_res (nation) <= 0)
				{
					Message ("Mil. reserves exhausted");
					Bell ();
					return;
				}

				newmil = s_civ (sct) * 0.5;

				if (quota)
					newmil = quant - s_mil (sct);
				else
					newmil = quant;

				if (newmil <= 0)
					continue;

				if (newmil > s_civ (sct) * 0.5)
					newmil = s_civ (sct) * 0.5;
				
				if (s_mil (sct) + newmil > max_mil)
					newmil = max_mil - s_mil (sct);

				if (newmil > n_mil_res (nation))
					newmil = n_mil_res (nation);

				set_mil (sct, s_mil (sct) + newmil);
					/*
					 *	Perhaps I should learn
					 *	how to cast efficiently
					 */
				set_mob (sct, (int) (((double) s_mob (sct)) *
					(1.0 - ((double) newmil) /
					       ((double) s_civ (sct)))));

				set_civ (sct, s_civ (sct) - newmil);
				tot_enl += newmil;
				n_mil_res (nation) -= (long) newmil;
				n ++;
				if (tot_enl >= 10000)
				{
					Bell ();
		Message ("Rioting in induction center interrupts enlistment");
					return;
				}
			}

		if (n == 0)
			Message ("No appropiate sectors");
		else if (n == 1)
			Message (Fmt ("%d enlisted", tot_enl));
		else
			Message (Fmt ("Total enlistment: %d", tot_enl));

		DrawMapPart (sx, sy, ex, ey);
		return;
	}

	FeedEmpire (Fmt ("enlist %s %d", realm, quant), PRINT);

	for (;;)
	{
		ptr = ReadEmpire (PRINT);
		if (EmpireStatus () == E_COMMAND)
		{
			PrintAtEmpire (ptr);
			break;
		}

		else if (EmpireStatus () == E_QUESTION)	/* treaty violation */
		{
			ans = InputAtMessage (ptr, 10, GS_TEXT);
			if (ans == (char *) 0 || interrupt)
			{
				interrupt = False;
				FeedEmpire ("aborted", PRINT);
				(void) WaitForPrompt (PRINT);
				return;
			}

			FeedEmpire (ans, PRINT);
			continue;
		}

		if (StrEQ (ptr, "No military reserves") ||
		    StrEQ (ptr, "Rioting in induction center inter") ||
		    StrEQ (ptr, "Military reserve exhausted") ||
		    StrEQ (ptr, "No room for military in") ||
		    StrEQ (ptr, "civilians refuse to report"))
		{
			Message (ptr);
			Bell ();
			continue;
		}

		if (sscanf (ptr, "%d enlisted in %d,%d (%d)", 
			& nr, & x, & y, & newv) == 4)
		{
			Message (ptr);

			sct = World (x, y, S_EXIST);

			tot_enl += nr;

			if (sct == (Sector) 0)
				continue;
			
			set_mil (sct, newv);
					/*
					 *	Perhaps I should learn
					 *	how to cast efficiently
					 */
			set_mob (sct, (int) ((double) s_mob (sct) *
					(1.0 - (double) nr /
					       (double) s_civ (sct))));
			set_civ (sct, s_civ (sct) - nr);


			if (sct == cursct)
				Census ();
			
			continue;
		}
	}

	(void) WaitForPrompt (PRINT);

	n_mil_res (nation) -= (long) tot_enl;

	DrawMapPart (sx, sy, ex, ey);
}

void SingleEnlist ()
{
	char * ans;
	int quant;

	ans = InputAtMessage ("# to enlist: ", 4, GS_NUMBER);

	if (ans == (char *) 0 || interrupt || * ans == '\0')
	{
		interrupt = False;
		ClearMes ();
		return;
	}

	quant = atoi (ans);
	if (quant == 0)
	{
		ClearMes ();
		return;
	}

	DoEnlist (CrdStr (cursct), quant);
	DrawSector (cursct);
	Census ();
}

void MultiEnlist (x, y)
int x, y;
{
	MultiCommand (x, y, "Enlist how many mils", "enlist", -1, DoEnlist,
									'\0');
}
