/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/census/RCS/nuke.c,v 5.1 93/03/14 16:41:54 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:41:54 $
    $Author: etienne $
    $Id: nuke.c,v 5.1 93/03/14 16:41:54 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	nuke.c,v $
 * Revision 5.1  93/03/14  16:41:54  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:16:27  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.5  1993/02/06  07:48:54  greyhelm
 * Added gnumake mods to allow checkin and Checkout
 *
 * Revision 4.4  1993/02/06  04:21:26  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "census.h"
#include "nuke.h"
#include "sector.h"

#define	NCM_BUILD	0
#define	NCM_TRANSPORT	1

#define NCM_MAX		2

#ifdef X_VERSION

static struct s_funcbutton funcbuttons [] =
{
	{ NCM_BUILD,		"Build",	2,  NKL_SY_FUNCBUT,	5 },
	{ NCM_TRANSPORT,	"Transport",	10, NKL_SY_FUNCBUT,	9 }
};

#else /* TERMC_VERSION */

static struct s_funcbutton funcbuttons [] =
{
	{ NCM_BUILD,		"Build",	3,  NKL_SY_FUNCBUT,	5 },
	{ NCM_TRANSPORT,	"Transport",	10, NKL_SY_FUNCBUT, 	9 }
};

#endif /* VERSION */

static bool cens_enable [NCM_MAX];
static int cennuketype[NKL_MAX_NUKES], cennukequant[NKL_MAX_NUKES];

static void HandleNukeCensusButton (i)
int i;
{
	if (! cens_enable [i])
		return;
	
	switch (i)
	{

	case NCM_BUILD:
		BuildNuke (10, 10);
		break;

	case NCM_TRANSPORT:
		TransportNuke(10, 10, Fmt ("%d", sp_nr (curnuke)));
		break;
	}
}

void CensusLayNuke ()
{
	CenLine (NKL_SY_NR - 1);
	CenPuts (0, NKL_SY_NR, "Nuke #");
	CenLine (NKL_SY_NR + 1);
	CenLine (NKL_SY_BUT - 1);
	if (s_shi (cursct) > 0)
		CenButton (NKL_SX_SHIP,  NKL_SY_BUT, "Ship",  4,False);
	else
		CenButton (NKL_SX_SHIP,  NKL_SY_BUT, "----",  4,False);

	if (s_pla (cursct) > 0)
		CenButton (NKL_SX_PLANE, NKL_SY_BUT, "Plane", 5, False);
	else
		CenButton (NKL_SX_PLANE, NKL_SY_BUT, "-----", 5, False);

	CenButton (NKL_SX_SECTOR, NKL_SY_BUT, "Sector", 6, False);
	CenLine (NKL_SY_BUT + 1);
}

void NukeCensus (stockp)
Stockp stockp;
{
	register int i, j, k;

	curnuke = stockp;

	CenClr (NKL_SY_NR);
	CenPuts (0, NKL_SY_NR, "Nuke #");
	CenPutShort (6, NKL_SY_NR, sp_nr (stockp));
	if (deity)
		CenPutVal (10, NKL_SY_NR, Fmt ("(%-.13s)",
				CountryName (sp_owner (stockp))));

	for (i = 0; i < NKL_MAX_NUKES; i ++)
		CenClr (NKL_SY_NUKES + i);
		cennuketype[i] = cennukequant[i] = 0;

	k = 0;
	for (i = 0; i < nr_nuke_types; i ++)
	{
		j = sp_nukamt (stockp, i);
		if (j > 0)
		{
			if (curnuketype < 0)
				curnuketype = i;

			cennuketype[k] = i;
			cennukequant[k] = j;

			CenPutShort (0, NKL_SY_NUKES + k, j);

			if (i == curnuketype)
				CenPutVal (4, NKL_SY_NUKES + k, nt_name (i));
			else
				CenPuts (4, NKL_SY_NUKES + k, nt_name (i));
			k ++;
		}
	}

	if (s_des (cursct) == 'n' && (deity || s_eff (cursct) >= 60))
		cens_enable [NCM_BUILD] = True;
	else
		cens_enable [NCM_BUILD] = False;

	cens_enable [NCM_TRANSPORT] = True;
	DrawCensusButtons (funcbuttons, NCM_MAX, cens_enable);
	FlushWindow (census_win);
	Refresh ();
}

void NukeCensusButton (x, y)
int x, y;
{
	int i;

	if (y == NKL_SY_BUT)
	{
		if (ButtonPressed (x, y, NKL_SX_SHIP, y, 4))
		{
			if (s_fship (cursct) != (Ship) 0)
				CensusShip (s_fship (cursct));
		}
		else if (ButtonPressed (x, y, NKL_SX_PLANE, y, 5))
		{
			if (s_fplane (cursct) != (Plane) 0)
				CensusPlane (s_fplane (cursct));
		}
		else if (ButtonPressed (x, y, NKL_SX_SECTOR, y, 6))
		{
			CensusSct (cursct);
		}
		return;
	}

	if (y >= NKL_SY_NUKES && y < NKL_SY_NUKES + NKL_MAX_NUKES)
	{
		i = y - NKL_SY_NUKES;
		if (cennukequant[i] != 0) {
			curnuketype = cennuketype[i];
			NukeCensus (curnuke);
		}
		return;
	}

	i = WhichCensusButton (funcbuttons, NCM_MAX, x, y);
	if (i != -1)
		HandleNukeCensusButton (i);
}
