#include <stdio.h>
#include <unistd.h>

#define True	1
#define	False	0

typedef int bool;
typedef FILE * File;

#define tmp_patch	"tmp_patch"

#define DEF_PAGER	"/usr/local/bin/yap"

static void line_read ()
{
	static int index = 0;
	static char * chars = "|/-\\";

	printf ("%c\b", chars [index]);
	if (++ index > 3)
		index = 0;
	fflush (stdout);
}

static bool start_line (line)
char * line;
{
	char filename [1000];
	char day [1000];

	if (sscanf (line, "*** %[a-z/.] %[a-zA-Z]", filename, day) != 2)
		if (sscanf (line, "--- %[a-z/.] %[a-zA-Z]", filename, day) != 2)
			return False;

	if (access (filename, W_OK) != 0)
		return False;

	if ( !  (strcmp (day, "Sun") == 0 ||
	         strcmp (day, "Mon") == 0 ||
	         strcmp (day, "Tue") == 0 ||
	         strcmp (day, "Wed") == 0 ||
	         strcmp (day, "Thu") == 0 ||
	         strcmp (day, "Fri") == 0 ||
	         strcmp (day, "Sat") == 0))
		return False;

	return True;
}

static bool next_patch (in)
File in;
{
	static bool buffered = False;
	static char buf [1000];
	File out;
	bool put;

	put = False;
	out = fopen (tmp_patch, "w");
	if (out == (File) 0)
	{
		fprintf (stderr, "Could not open %s for writting\n");
		perror ("fopen");
		exit (-1);
	}


	printf ("reading new patch: ");

	if (buffered)
	{
		buffered = False;
		line_read ();
		fputs (buf, out);
		put = True;
	}

	while (fgets (buf, 1000, in) != (char *) 0)
	{
		line_read ();
		if (start_line (buf))
		{
			buffered = True;
			fclose (out);
			printf ("done\n");
			return True;
		}

		fputs (buf, out);
		put = True;
	}

	printf ("stop\n");
	fclose (out);
	return put;
}

static void page_patch ()
{
	char buf [1000];
	char * pager, * getenv ();

	pager = getenv ("PAGER");
	if (pager == (char *) 0)
		pager = DEF_PAGER;

	(void) sprintf (buf, "%s %s", pager, tmp_patch);
	(void) system (buf);
}

static void apply_patch ()
{
	printf ("patch -p < tmp_patch\n");
	(void) system ("patch -p < tmp_patch");
}

static void edit_patch ()
{
	static char * editor = (char *) 0;
	char buf [100];

	extern char * getenv ();

	if (editor == (char *) 0)
	{
		editor = getenv ("EDITOR");
		if (editor == (char *) 0)
			editor = "vi";
	}

	sprintf (buf, "%s tmp_patch", editor);
	printf ("%s\n", buf);
	(void) system (buf);
}

main (argc, argv)
int argc;
char ** argv;
{
	File in;
	bool paged, applied;
	char ch;
	bool cont;
	char buf [1000];

	if (argc != 2)
	{
		fprintf (stderr, "Usage: %s <big-patchfile>\n", argv [0]);
		exit (-1);
	}

	in = fopen (argv [1], "r");
	if (in == (File) 0)
	{
		fprintf (stderr, "Can't open %s\n", argv [1]);
		perror ("fopen");
		exit (-1);
	}

	while (next_patch (in))
	{
		paged = False;
		applied = False;
		cont = True;

		while (cont)
		{
			printf ("(P)ager (A)pply (Q)uit (E)dit (N)ext");
			if (! paged)
				printf (" [Pager]: ");
			else if (! applied)
				printf (" [Apply]: ");
			else 
				printf (" [Next]: ");
			
			fflush (stdout);

			if (gets (buf) == (char *) 0)
			{
				printf ("Quit\n");
				fclose (in);
				exit (0);
			}

			ch = buf [0];
			if (ch == '\0')
			{
				if (! paged)
					ch = 'p';
				else if (! applied)
					ch = 'a';
				else
					ch = 'n';
			}
				
			cont = True;
			switch (ch)
			{

			case 'q':
			case 'Q':	printf ("Bye\n");
					fclose (in);
					exit (0);
				
			case 'a':
			case 'A':	apply_patch ();
					applied = True;
					break;
			
			case 'n':
			case 'N':	cont = False;
					break;
			
			case 'p':
			case 'P':	page_patch ();
					paged = True;
					break;

			case 'e':
			case 'E':
					edit_patch ();
					break;

			default:	printf ("Huh?\n");
					break;
			}
		}
	}
	
	printf ("No more patches\n");
	fclose (in);
	exit (0);
}
