#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"
#include "var.h"
#include "ship.h"

void FScanShowShipBuild ()
{
	
	char *line;
	char *bptr, buffer [BUFSIZ];
	int nr = 0;
	int i;
	ShType tmp;

	FeedEmpire ("show ship build", PRINT);
	(void) SkipNLines (1, DONT_PRINT);

	MessageAtEmpire ("scanning ship build data");

	for (;;)
	{
		line = ReadEmpire (DONT_PRINT);

		if (StrStr("lcm hcm avail tech  $", line))
		   continue;
			/* last line ? */
		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (line);
			shiptypes [nr]. nam = (char *) 0;
			return;
		}
		
		strncpy (buffer, line, 14);
		buffer [14] = '\0';
		bptr = buffer + 14;

		if (!ksu_version) {
			while (*bptr < 'a' || *bptr > 'z')
				bptr --;
		}
		* ++bptr = '\0';


		if (shiptypes [nr]. nam != (char *) 0)
			free (shiptypes [nr]. nam);

		shiptypes [nr]. nam = Str (buffer);
		if (sscanf (line + 14, " %d %d %d %d $%d",
			               & (shiptypes [nr]. lcm),
			               & (shiptypes [nr]. hcm),
			               & (shiptypes [nr]. ava),
			               & (shiptypes [nr]. tec),
			               & (shiptypes [nr]. cos)) != 5) {
			PrintAtEmpire (Fmt ("Scanning ship failed \"%s\"",
						line));
			Bell ();
			(void) EmpireMore ();
			nr --;
		}
		/* sort the list by tech */
		for( i=nr; i > 0; i-- ) {
		    if (shiptypes[i].tec < shiptypes[i-1].tec) {
			bcopy(&shiptypes[i-1], &tmp, sizeof(ShType));
			bcopy(&shiptypes[i], &shiptypes[i-1], sizeof(ShType));
			bcopy(&tmp, &shiptypes[i], sizeof(ShType));
		    }
		}
		nr ++;
	}
}

void FScanShowShipCap ()
{
	char *line, *ptri;
	char *bptr, buffer [BUFSIZ];
	char word [BUFSIZ];
	int nr, quant;
	char itemchar;
	int item;

	FeedEmpire ("show ship capabilities", PRINT);
	(void) SkipNLines (1, DONT_PRINT);

	MessageAtEmpire ("scanning ship capabilities");

	for (;;)
	{
		line = ReadEmpire (DONT_PRINT);

		if (StrStr("def spd vis spy rng fir", line))
		   continue;

			/* last line ? */
		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (line);
			return;
		}
		
		strncpy (buffer, line, 14);
		buffer [14] = '\0';
		bptr = buffer + 14;

		if (!ksu_version) {
			while (*bptr < 'a' || *bptr > 'z')
				bptr --;
		}
		* ++ bptr = '\0';


		nr = FindShipTypeByName (buffer, True);

		if ((! ksu_version && sscanf (line + 14, " %d %d %d %d %d %d",
			                & (shiptypes [nr]. def),
			                & (shiptypes [nr]. spd),
			                & (shiptypes [nr]. vis),
			                & (shiptypes [nr]. spy),
				        & (shiptypes [nr]. rng),
			                & (shiptypes [nr]. fir)) != 6) ||
		   ((ksu_version && sscanf (line + 14, " %d %d %d %d %d %d %d",
			                & (shiptypes [nr]. def),
			                & (shiptypes [nr]. spd),
			                & (shiptypes [nr]. vis),
			                & (shiptypes [nr]. spy),
				        & (shiptypes [nr]. rng),
			                & (shiptypes [nr]. fir),
					& (shiptypes [nr]. pla)) != 7)))
	       {
			PrintAtEmpire (Fmt ("Scanning ship failed \"%s\"",
						line));
			Bell ();
			(void) EmpireMore ();
		}

			/* Clear max cargoes */

		for (item = 0; item < V_MAX; item++)
			shiptypes [nr]. car [item] = 0;

		shiptypes [nr]. flags = 0L;

			/* Scan max cargoes */
		
		ptri = line + 37;
		if (ksu_version)
			ptri += 4;

		for (;;)
		{
			if (! ScanWord (&ptri, word))
				break;

			if (sscanf (word, "%d%c", &quant, &itemchar) == 2)
			{
				item = CharToItem (itemchar);
				shiptypes [nr]. car [item] = quant;
			}
			else if (strcmp (word, "fish") == 0)
				shiptypes [nr]. flags |= M_FISH;
			else if (strcmp (word, "oil") == 0)
				shiptypes [nr]. flags |= M_OIL;
			else if (strcmp (word, "sweep") == 0)
				shiptypes [nr]. flags |= M_SWEEP;
			else if (strcmp (word, "miss") == 0)
				shiptypes [nr]. flags |= M_MISS;
			else if (strcmp (word, "plane") == 0)
				shiptypes [nr]. flags |= M_PLANE;
			else if (strcmp (word, "sub") == 0)
				shiptypes [nr]. flags |= M_SUB;
			else if (strcmp (word, "sonar") == 0)
				shiptypes [nr]. flags |= M_SONAR;
			else if (strcmp (word, "mine") == 0)
				shiptypes [nr]. flags |= M_MINE;
			else if (strcmp (word, "dchrg") == 0)
				shiptypes [nr]. flags |= M_DCHRG;
			else if (strcmp (word, "torp") == 0)
				shiptypes [nr]. flags |= M_TORP;
			else if (strcmp (word, "spy") == 0)
				shiptypes [nr]. flags |= M_SPY;
			else if (strcmp (word, "land") == 0)
				shiptypes [nr]. flags |= M_LAND;
			else if (strcmp (word, "sub-torp") == 0)
				shiptypes [nr]. flags |= M_SUBT;
			else
			{
				PrintAtEmpire (Fmt (
					"Strange format in cargo \"%s\"",
					word));
				Bell ();
			}
		}
		shiptypes [nr]. flags |= M_KNOWN;
	}
}

void RestoreShowShip (fp)
FILE *fp;
{
	int nr;
	register int j;
	char buffer [BUFSIZ];
	char name [BUFSIZ];
	register char *ptri;

	nr = 0;
	while (fgets (buffer, BUFSIZ, fp) != (char *) 0)
	{
		if (strncmp (buffer, "END OF SHOW SHIP LIST", 21) == 0)
		{
			shiptypes [nr]. nam = (char *) 0;
			break;
		}

		buffer [strlen (buffer) - 1] = '\0';	/* no newline */
		
		if (sscanf (buffer,"%d %d %d %d %d %d %d %d %d %s %d %d %d %ld",
			& (shiptypes [nr]. lcm), & (shiptypes [nr]. hcm),
			& (shiptypes [nr]. def), & (shiptypes [nr]. spd),
			& (shiptypes [nr]. vis), & (shiptypes [nr]. spy),
			& (shiptypes [nr]. rng), & (shiptypes [nr]. fir),
			& (shiptypes [nr]. pla),
			name                   , & (shiptypes [nr]. tec),
			& (shiptypes [nr]. cos), & (shiptypes [nr]. ava),
			& (shiptypes [nr]. flags)) != 14)
		{
				PrintAtEmpire ("Bad Ship info in datafile");
				Bell ();
				continue;
		}

		for (ptri = name; *ptri != '\0'; ptri ++)
			if (*ptri == '_')
				*ptri = ' ';

		shiptypes [nr]. nam = Str (name);

		for (j = 1; j < V_MAX; j++)
			fscanf (fp, " %d ", & (shiptypes [nr]. car [j]));

		fscanf (fp, "\n");
		nr ++;
	}
}

void SaveShowShip (fp)
FILE *fp;
{
	register int i, j;
	register char *ptri, *name;;

	for (i = 0; shiptypes [i]. nam != (char *) 0; i ++)
	{
		name = Str (shiptypes [i]. nam);
		for (ptri = name; *ptri != '\0'; ptri ++)
			if (*ptri == ' ')
				*ptri = '_';

		fprintf (fp, "%d %d %d %d %d %d %d %d %d %s %d %d %d %ld\n",
			shiptypes [i]. lcm, shiptypes [i]. hcm,
			shiptypes [i]. def, shiptypes [i]. spd,
			shiptypes [i]. vis, shiptypes [i]. spy,
			shiptypes [i]. rng, shiptypes [i]. fir,
			shiptypes [i]. pla,
			name, shiptypes [i]. tec,
			shiptypes [i]. cos, shiptypes [i]. ava,
			shiptypes [i]. flags);

		for (j = 1; j < V_MAX; j++)
			fprintf (fp, "%d ", shiptypes [i]. car [j]);

		fprintf (fp, "\n");
		free (name);
	}

	fprintf (fp, "END OF SHOW SHIP LIST\n");
}
	
int DumpShips (list, flag)
char *list;
int flag;
{
	int nr;

	nr = FScanShips (list, flag);
	if (nr > 0)
		FScanCargo (list, flag);
	return (nr);
}

int FScanShips (list, flag)
char *list;
int flag;
{
	bool nr;

	FeedEmpire (Fmt ("ships %s", list), flag);
	nr = ScanShips (flag);
	(void) WaitForPrompt (flag);

	return nr;
}

int ScanShips (flag)
int flag;
{
	char *line;
	int sx, sy, nr, owner, i, nr_of_ships;
	int eff, civ, mil, uw, food, pln, mob, tech; 
	Ship new, last_ship;
	Sector to;
	bool rescan;
	char shipname[100];
	double mobcost;
	int ships;


	if (EmpireStatus () != E_PRINTING)
		return 0;

	if (flag == PRINT)
		PrintAtEmpire ("Empiretool: scanning ships");

	(void) SkipNLines (1, DONT_PRINT);

	nr_of_ships = 0;
	last_ship = (Ship) 0;

	for (;;)
	{
		line = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire (line);
			return (nr_of_ships);
		}

		if (strlen (line) < 45)
		{
			if (sscanf (line, "%d ship", & ships) == 1)
			{
				if (ships != nr_of_ships)
					PrintAtEmpire (Fmt ("%s%d%s%d%s",
						"Strange, ",
						ships,
						" ships is not ",
						nr_of_ships,
						" ships!"));
				return (nr_of_ships);
			}
			else if (strncmp (line, "command failed", 13) == 0)
				continue;
			else if (ksu_version)
			{
				if (strlen (line) > 7 && last_ship != (Ship) 0)
				{
					set_sh_name (last_ship, line + 7);
					continue;
				}
			}
			else
			{
				PrintAtEmpire (Fmt ("Skipping: %s", line));
				continue;
			}
		}

		if (deity)
		{
			owner = atoi (line);
			line += 4;
		} else
			 owner = my_cnum;

			/* read ship#  */
		nr = atoi (line);

		if ((new = NrToShip (nr)) == (Ship) 0)
		{
			new = (Ship)
				doalloc ((unsigned) sizeof (struct s_ship));

			bzero (new, sizeof (struct s_ship));
			set_sh_nr (new, nr);
			rescan = False;
		} else
			rescan = True;

		set_sh_marked (new, False);
		set_sh_owner (new, owner);

			/* read shipname */
		for (i = 5; i <= 21; i++)
			shipname [i - 5] = *(line + i);

		i -= 5;
		while (shipname [-- i] == ' ');

		shipname [i + 1] = '\0';


			/* read position */
		if (sscanf (line + 22, "%d,%d", & sx, &sy) != 2)
		{
			if (! rescan)
				free ((char *) new);
			PrintAtEmpire (Fmt ("Bad ship %s", line));
			continue;
		}
			
		set_sh_fleet (new, *(line + 33));
		if (sh_fleet (new) == ' ')
			set_sh_fleet (new, '~');

		(void) sscanf (line + 35, " %d%% %d %d %d %d %d %d %d",
			& (eff), & (civ), & (mil), & (uw), & (food),
			& (pln), & (mob), & (tech));

		set_sh_eff (new, eff);
		set_sh_civ (new, civ);
		set_sh_mil (new, mil);
		set_sh_uw  (new, uw);
		set_sh_foo (new, food);
		set_sh_pln (new, pln);
		set_sh_mob (new, mob);
		set_sh_tech (new, tech);

		mobcost = sh_eff (new) * 0.01 * shiptypes [sh_type (new)]. spd;
		mobcost = 480.0 / (mobcost + TechFact (sh_tech (new), mobcost));
		set_sh_moves (new, mob / mobcost + 0.99);

		SetShipValues (new, shipname);
		if (rescan)
		{
			MoveShip (new, World (sx, sy, S_DESIG));
		} else
		{
			to = World (sx, sy, S_DESIG);
			UpdateSectorDes (to, '.', False);
			AddShipToList (new);
			AddShipToSector (new, to);
		}

		last_ship = new;
		nr_of_ships++;
	}
}

void FScanCargo (list, flag)
char *list;
int flag;
{
	FeedEmpire (Fmt ("cargo %s", list), flag);
	ScanCargo (flag);
	(void) WaitForPrompt (flag);
}

void ScanCargo (flag)
int flag;
{
	char *line, *ptri, *tmp, *s, savechar;
	int nr;
	Ship ship;
	extern WinInfo empire_win;

	if (EmpireStatus () != E_PRINTING)
		return;

	if (flag == PRINT)
		PrintAtEmpire ("Empiretool: scanning cargo");

	(void) SkipNLines (1, DONT_PRINT);

	for (;;)
	{
		line = ptri = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () != E_PRINTING)
		{
			if (flag == PRINT)
				PrintAtEmpire (line);
			return;
		}

		if (strlen (line) < 70)
		{
			if (sscanf (line, "%d ships", & nr) == 1)
				return;
			else
				continue;
		}

		if (!ScanDigit (&ptri, &nr) || 
				(ship = NrToShip (nr)) == (Ship) 0)
		{
			PrintAtEmpire (
				Fmt ("#%d Unknown ship ? (rescan ships !)",
				nr));
			PrintAtEmpire (Fmt ("Skipping line \"%s\"", line));
			if (! deity)
			{
				Bell ();
				(void) EmpireMore ();
			}
			else
				PrintAtEmpire ("Ship sunk, cargo found :-)");

			continue;
		}

		SkipBlank (&ptri);
/* 
 *		Doesn't work error in empire prints > 999 wrongly
 * 		ptri += 16; skip shipname
 * 		nr = sscanf (ptri,
 * 		       " %*d,%*d%*[a-zA-Z~ ]%*d%% %4hd %4hd %4hd \
 *			 %4hd %4hd %4hd %4hd %4hd %4hd %4hd",
 * 			& (sh_shell (ship)),
 * 			& (sh_gun (ship)),
 * 			& (sh_pet (ship)),
 * 			& (sh_iron (ship)),
 * 			& (sh_dust (ship)),
 * 			& (sh_bar (ship)),
 * 			& (sh_oil (ship)),
 * 			& (sh_lcm (ship)),
 * 			& (sh_hcm (ship)),
 * 			& (sh_rad (ship)));
 * 
 */
		ptri = index (ptri, '%');
		if (ptri != (char *) 0) {
			ptri++;
			for (s = "sgpidbolhr"; *s; s++)
			{
				SkipBlank (&ptri);
				tmp = ptri;
				if (!ScanDigit (&tmp, &nr))
					break;

				if (tmp - ptri > 4)
				{
					savechar = *(tmp - 4);
					* (tmp - 4) = '\0';
					(void) ScanDigit (&ptri, &nr);
					* (tmp - 4) = savechar;
				} else
					(void) ScanDigit (&ptri, &nr);

				SetShipQuant (ship, *s, nr);
			}
		}

		if (ptri == (char *) 0 || *s != '\0')
		{
			PrintAtEmpire ("Bad cargo format");
			PrintAtEmpire (Fmt ("Skipping line \"%s\"", line));
			Bell ();
			(void) EmpireMore ();
			continue;
		}
	}
}

void FeedRadarShips ()
{
	char buffer [BUFSIZ];
	register char *bptr;
	register Ship sptr;
	register int num;

	bptr = buffer;
	num = 0;
	for (sptr = shiplist; sptr != (Ship) 0; sptr = sh_next (sptr))
	{
		if (!deity && ! sh_owned (sptr))
			continue;

		if (GiveShipQuant (sptr, 'R') <= 1)
			continue;

		sprintf (bptr, "%d", sptr-> nr);

		while (*bptr) bptr++;

		* bptr++ = '/';
		num ++;
	}

	if (!num)
		return;

	*--bptr = '\0';

	FScanRadar (buffer);
}

void FScanReso ()
{
	Sector sct;
	int oil, fert, x, y;
	char *ptr;

	oil = fert = -1;

	FeedEmpire ("v", PRINT);

	for (;;)
	{
		ptr = ReadEmpire (PRINT);

		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire (ptr);
			return;
		}

		SkipBlank (&ptr);
		if (strncmp (ptr, "[fert:", 6) == 0)
		{
			fert = atoi (ptr + 6);
			ptr = strchr (ptr, ']');
			ptr ++;
			SkipBlank (&ptr);
		}

		if (strncmp (ptr, "[oil:", 5) == 0)
		{
			oil = atoi (ptr + 5);
			ptr = strchr (ptr, ']');
			ptr ++;
			SkipBlank (&ptr);
		}

		if ((ptr = strchr (ptr, '@')) != (char *) 0)
			if (sscanf (++ptr, " %d, %d", &x, &y) ==  2)
			{
				sct = World (x, y, S_DESIG);

				if (fert != -1)
				{
					set_fer (sct, fert);
					SET_INFO_FER (sct);
				}

				if (oil != -1)
				{
					set_oil (sct, oil);
					SET_INFO_OIL (sct);
				}
			}
	}
}

void CheckMarkedShips ()
{
	Ship sptr;

	for (sptr = shiplist; sptr != (Ship) 0; sptr = sh_next (sptr))
	{
		if (!deity && ! sh_owned (sptr))
			continue;

		if (sh_marked (sptr))
		{
			Error (Fmt ("Your %s @ %d,%d has sunk/lost !",
				ShipName (sptr), sh_xcd (sptr), sh_ycd (sptr)));
			DeleteShip (sptr);
		}
	}
}

void SearchMarkedShips (flag)
int flag;
{
	char buffer [BUFSIZ];
	register char *bptr;
	register Ship sptr;
	register int num;

	bptr = buffer;
	num = 0;
	for (sptr = shiplist; sptr != (Ship) 0; sptr = sh_next (sptr))
	{
		if (! sh_owned (sptr) || ! sh_marked (sptr))
			continue;

		sprintf (bptr, "%d", sptr-> nr);

		while (*bptr) bptr++;

		* bptr++ = '/';
		num ++;
	}

	if (!num)
		return;

	*--bptr = '\0';

	DumpShips (buffer, flag);
	CheckMarkedShips ();
}

void MarkShipsInSct (sct)
Sector sct;
{
	Ship sptr;

	for (sptr = s_fship (sct); sptr != (Ship) 0; sptr = sh_nxtsct (sptr))
		set_sh_marked (sptr, True);
}

void MarkShip (ship)
Ship ship;
{
	set_sh_marked (ship, True);
}

void MarkAllShips ()
{
	Ship sptr;

	for (sptr = shiplist; sptr != (Ship) 0; sptr = sh_next (sptr))
		set_sh_marked (sptr, True);
}

void RedumpShip (ship, flag)
Ship ship;
int flag;
{
	char *aship;

	MarkShip (ship);
	aship = Fmt ("%d", sh_nr (ship));

	DumpShips (aship, flag);
	CheckMarkedShips ();
}

void RedumpFleet (fleet, flag)
char fleet;
int flag;
{
	char *afleet;
	Ship sptr;

	for (sptr = shiplist; sptr != (Ship) 0; sptr = sh_next (sptr))
		if (sh_fleet (sptr) == fleet)
			MarkShip (sptr);

	afleet = Fmt ("%c", fleet);

	DumpShips (afleet, flag);
	SearchMarkedShips (flag);
}

void DumpSctShips (sct, flag)
Sector sct;
int flag;
{
	MarkShipsInSct (sct);
	(void) DumpShips (CrdStr (sct), flag);
	SearchMarkedShips (flag);
}

void DumpRealmShips (realm, flag)
char *realm;
int flag;
{
	int sx, sy, ex, ey;
	Ship sptr;

	if (realm == (char *) 0)
		return;

	if (ConvRealmToCoord (realm, &sx, &ex, &sy, &ey))
		for (sptr = shiplist; sptr != (Ship) 0; sptr = sh_next (sptr))
			if (sh_xcd (sptr) >= sx && sh_xcd (sptr) <= ex &&
			    sh_ycd (sptr) >= sy && sh_ycd (sptr) <= ey)
				MarkShip (sptr);

	(void) DumpShips (realm, flag);
	SearchMarkedShips (flag);
}
