#ifndef _NUKE
#define	_NUKE

#define MAX_NUKETYPES	40

#ifndef _TYPE
#include "type.h"
#endif /* _TYPE */

struct s_nuke
{
	int nr;
	int x;
	int y;
	int owner;
	int nuke_amt [MAX_NUKETYPES];

	Stockp next;
};

#define sp_x(p)			(p)-> x
#define	sp_y(p)			(p)-> y
#define	sp_owner(p)		(p)-> owner
#define	sp_nukamt(p,q)		(p)-> nuke_amt [q]
#define sp_nr(p)		(p)-> nr

#define sp_next(p)		(p)-> next

#define set_sp_x(p,q)		(p)-> x = (q)
#define	set_sp_y(p,q)		(p)-> y = (q)
#define	set_sp_owner(p,q)	(p)-> owner = (q)
#define set_sp_nukamt(p,q,r)	(p)-> nuke_amt [q] = (r)
#define set_sp_nr(p,q)		(p)-> nr = (q)

#define set_sp_next(p,q)	(p)-> next = q

#define	NK_NEUTRON		0x01

struct s_nuketype
{
	char * name;

	int lcm;
	int hcm;
	int oil;
	int rad;
	int ava;
	int tech;
	int cost;
	int blst;
	int dam;
	int lbs;
	int abil;
};

#define nt_name(z)		nuke_type [z]. name
#define	nt_lcm(i)		nuke_type [i]. lcm
#define	nt_hcm(i)		nuke_type [i]. hcm
#define	nt_oil(i)		nuke_type [i]. oil
#define	nt_rad(i)		nuke_type [i]. rad
#define	nt_ava(i)		nuke_type [i]. ava
#define	nt_tech(i)		nuke_type [i]. tech
#define	nt_cost(i)		nuke_type [i]. cost
#define	nt_blst(i)		nuke_type [i]. blst
#define	nt_dam(i)		nuke_type [i]. dam
#define	nt_lbs(i)		nuke_type [i]. lbs
#define	nt_abil(i,j)		((nuke_type [i]. abil & j) == j)
#define nt_abils(i)		nuke_type [i]. abil

#define set_nt_name(i,z)	nuke_type [i]. name = z
#define	set_nt_lcm(i,x)		nuke_type [i]. lcm = (x)
#define set_nt_hcm(i,x)		nuke_type [i]. hcm = (x)
#define set_nt_oil(i,x)		nuke_type [i]. oil = (x)
#define set_nt_rad(i,x)		nuke_type [i]. rad = (x)
#define set_nt_ava(i,x)		nuke_type [i]. ava = (x)
#define set_nt_tech(i,x)	nuke_type [i]. tech = (x)
#define set_nt_cost(i,x)	nuke_type [i]. cost = (x)
#define set_nt_blst(i,x)	nuke_type [i]. blst = (x)
#define set_nt_dam(i,x)		nuke_type [i]. dam = (x)
#define set_nt_lbs(i,x)		nuke_type [i]. lbs = (x)
#define set_nt_abil(i,x)	nuke_type [i]. abil |= (x)

extern struct s_nuketype nuke_type [MAX_NUKETYPES];
extern int nr_nuke_types;
extern Stockp spl_head, spl_tail;

#define	NK_BUILD		0

#endif _NUKE
