#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "ship.h"

	/*
	 *	From empire
	 */

int chance(d)
double	d;
{
	double	roll;

	roll = (random() & 0x7fff);
	if (d >= roll/32768.0)
		return 1;
	return 0;
}

int roundavg(val)
double	val;
{
	int	flr;

	flr = (int) val;
	if (val < 0)
		flr -= chance(flr - val);
	else
		flr += chance(val - flr);

	return flr;
}

/*
 *	returns the number who starved, if any.
 */

int FeedSctPeople (sct, etus, upd)
Sector sct;
int etus;
bool upd;
{
	double food_eaten;
	double people_left;
	int starved;

/* mta Sun Jan  6 19:24:29 EET 1991 
 * no food on blitz games, see how it works
 */
	if (no_food)
	   return 0;		/* no people starve on blitz */

	food_eaten = etus * eatrate * (s_civ (sct) + s_mil (sct) + q_uw (sct));

	starved = 0;

	if (food_eaten > q_foo (sct))
	{
		people_left = (q_foo (sct) + 0.01) / (food_eaten + 0.01);
		starved = s_mil (sct) + s_civ (sct) + q_uw (sct);

		/* only want to starve off at most 1/2 the populace. */

		if (people_left < 0.5)
			people_left = 0.5;

		if (upd)
		{
			set_civ (sct, (int) s_civ (sct) * people_left);
			set_mil (sct, (int) s_mil (sct) * people_left);
			set_q_uw (sct, (int) q_uw (sct) * people_left);
			set_q_foo (sct, 0);

			starved -= s_civ (sct) + s_mil (sct) + q_uw (sct);
		}
		else
			starved = (1 - people_left) * starved;
	}
	else
	{
		if (upd)
			set_q_foo (sct, q_foo (sct) - roundavg (food_eaten));
	}

	return starved;
}

int FeedShipPeople (ship, etus, upd)
Ship ship;
int etus;
bool upd;
{
	double food_eaten;
	double people_left;
	int starved;

/* mta Sun Jan  6 19:24:29 EET 1991 
 * no food on blitz games, see how it works
 */
	if (no_food)
	   return 0;		/* no people starve on blitz */

	food_eaten = etus * eatrate *
		(sh_civ (ship) + sh_mil (ship) + sh_uw (ship));

	starved = 0;

	if (food_eaten > sh_foo (ship))
	{
		people_left = (sh_foo (ship) + 0.01) / (food_eaten + 0.01);
		starved = sh_mil (ship) + sh_civ (ship) + sh_uw (ship);

		/* only want to starve off at most 1/2 the populace. */

		if (people_left < 0.5)
			people_left = 0.5;

		if (upd)
		{
			set_sh_civ (ship, (int) sh_civ (ship) * people_left);
			set_sh_mil (ship, (int) sh_mil (ship) * people_left);
			set_sh_uw (ship, (int) sh_uw (ship) * people_left);
			set_sh_foo (ship, 0);
		}

		starved -= sh_civ (ship) + sh_mil (ship) + sh_uw (ship);
	}
	else
	{
		if (upd)
			set_sh_foo (ship, sh_foo (ship) - roundavg (food_eaten));
	}

	return starved;
}

int GrowPeople(sct, etus, upd, strings)
Sector sct;
int etus;
bool upd;
Strings strings;
{
	int	newciv;
	int	newuw;
	int	new_birth;
	int	new_food;

	newciv = 0;
	newuw = 0;

	if(upd && s_civ(sct) == 999) {
	    AddString(strings,
                      Fmt("Civilians in %s at %d will not grow.",
                           CrdStr(sct), s_civ(sct)));
	}

	if(upd && q_uw(sct) == 999) {
	    AddString(strings,
                      Fmt("Slaves in %s at %d will not grow.",
                           CrdStr(sct), q_uw(sct)));
	}

	if (s_civ (sct) < 999)
	{
		new_birth = roundavg (obrate * (double) (etus * s_civ (sct)));
		new_food = (int) (0.5 + q_foo (sct) / (2.0 * babyeat));
		newciv = new_birth;
		if (newciv > new_food)
			newciv = new_food;
		if (upd)
			set_civ (sct, s_civ (sct) + newciv);
	}

	if (q_uw (sct) < 999)
	{
		new_birth = roundavg (uwbrate * (double) (etus * q_uw (sct)));
		new_food = (int) (0.5 + q_foo (sct) / (2.0 * babyeat));
		newuw = new_birth;
		if (newuw > new_food)
			newuw = new_food;
		if (upd)
			set_q_uw (sct, q_uw (sct) + newuw);
	}

	if (upd)
	{
		if (s_civ (sct) > 999) {
		    AddString(strings,
			      Fmt("Over Civilian Population by %d in %s.",
				  (s_civ(sct) - 999), CrdStr(sct)));
		set_civ (sct, 999);
		}

		if (q_uw (sct) > 999) {
		     AddString(strings,
			      Fmt("Over Slave Population by %d in %s.",
				  (q_uw(sct) - 999), CrdStr(sct)));
		     set_q_uw (sct, 999);
		 }

		if (newciv || newuw)
			set_q_foo (sct, q_foo (sct) - 
					roundavg((newciv + newuw) * babyeat));
	}

	return newciv + newuw;
}

	/*
	 *	XXX: Xemp doesn't handle plague (yet)
	 *
	 *	--- infect_people
	 *	--- plague_people
	 */
