#include "include.h"
#include "token.h"

#define MAX_NESTED 10

void DelFunc (func, filename)
char * func, * filename;
{
	File fp_in, fp_out;
	TokenId tokenid;
	bool skip_br_open;
	char filebuf [100];
	char fileold [100];
	int token;
	int start_open [MAX_NESTED];
	int br_open;
	int i;

	(void) (sprintf (filebuf, "%s.new", filename));

	fp_in = fopen (filename, "r");
	if (fp_in == (File) 0)
	{
		fprintf (stderr, "DelFunc: could not open %s [r]\n", filename);
		perror ("fopen");
		exit (-1);
	}

	fp_out = fopen (filebuf, "w");
	if (fp_out == (File) 0)
	{
		fprintf (stderr, "DelFunc: could not open %s [w]\n", filebuf);
		perror ("fopen");
		exit (-1);
	}

	tokenid = NewTokenId (fp_in, filename);
	br_open = 0;
	i = -1;
	skip_br_open = False;

	while ((token = NextToken (tokenid)) != TOKEN_EOF)
	{
		if (token == TOKEN_IDENTIFIER &&
		    strcmp (TokenBuffer (tokenid), func) == 0)
		{
			start_open [++ i] = br_open;
			token = NextToken (tokenid);
			skip_br_open = True;
			continue;
		}

		if (token == TOKEN_BLANK && skip_br_open)
			continue;

		if (token == TOKEN_BR_OPEN)
		{
			br_open ++;
			if (skip_br_open)
			{
				skip_br_open = False;
				continue;
			}
		}
		
		if (token == TOKEN_BR_CLOSE)
		{
			br_open --;
			if (i >= 0 && br_open == start_open [i])
			{
				i --;
				continue;
			}
		}

		fputs (TokenBuffer (tokenid), fp_out);
	}
	
	fclose (fp_in);
	fclose (fp_out);

	(void) sprintf (fileold, "%s.old", filename);
	rename (filename, fileold);
	rename (filebuf, filename);
}
