#include <stdio.h>
#include "myopt.h"
#include "list.h"
#include "dlist.h"

char * dataf;

void ListAll (list)
List list;
{
	char * ptr;
	int i;


	for (i = 0, ptr = FirstGroup (list);
	     ptr != (char *) 0;
	     i ++, ptr = NextGroup (list))
	{
		Group group;
		User user;
		int j;

		group = GetGroup (list, ptr);

		printf ("%s: ", ptr);
		for (j = 0, user = FirstUser (group);
		     user != (User) 0;
		     j ++, user = NextUser (group))
			printf ("\n\t%s <%s>",  UserName (user),
						UserAddress (user));
		
		if (j == 0)
			printf ("No members\n");
		else
			printf ("\n");
	}
	
	if (i == 0)
		printf ("No groups.\n");
}
	
main (argc, argv)
int argc;
char ** argv;
{
	List list;
	char opt, * group;

	static char databuf [100];
	char * home, * getenv ();

	home = getenv ("HOME");
	if (home == (char *) 0)
	{
		fprintf (stderr, "HOME not set, leaving.\n");
		exit (1);
	}
	(void) sprintf (databuf, "%s/.mlist", home);
	dataf = databuf;

	init_opt (argc, argv);

	list = InitList ();
	LoadList (list, dataf);

	if (argc == 1)
	{
		Scan (list);
		SaveList (list, dataf);
	}
	else
	{
		init_opt (argc, argv);

		while ((opt = next_opt ()) != '\0')
		{

			switch (opt)
			{

			case 'i':
				Inter (list);
				break;
			
			case 's':
				group = next_arg ();
				Send (list, group);
				break;

			case 'l':
				ListAll (list);
				break;
			}
		}
	}
}
