#include "type.h"
#include "main.h"
#include "var.h"
#include "ship.h"
#include "sector.h"
#include "plane.h"

#define HOW_SELECT	0	/* via menu */
#define HOW_CURRENT	1	/* via redo */
#define HOW_BOTH	2	/* via bind */

void DoNavigate (x, y, how)
int x, y;
int how;
{
	char * ptr;

	if (last_layout == SHIP_MODE && how != HOW_SELECT)
	{
		if (! sh_owned (curship))
		{
			Message ("Not your ship!");
			Bell ();
			return;
		}

		Navigate (Fmt ("%d", sh_nr (curship)));
	}
	else if (last_layout == FLEET_MODE && how != HOW_SELECT)
		Navigate (Fmt ("%c", curfleet));
	else
	{
		if (how == HOW_CURRENT)
		{
			Message ("No current ship/fleet");
			Bell ();
			return;
		}

		ptr = SelectShips (x, y, ST_NAVIGATE, "Navigate which ships ?");
		if (ptr == (char *) 0)
			return;
		Navigate (ptr);
	}
}

void RedoNavigate ()
{
	DoNavigate (10, 10, HOW_CURRENT);
}

void BindNavigate (x, y, str)
int x, y;
char * str;
{
	static char buf [100];

	if (sscanf (str, " ( %s ) ", buf) == 1)
		Navigate (buf);
	else
		DoNavigate (x, y, HOW_BOTH);
}

void Navig (x, y)
int x, y;
{
	DoNavigate (x, y, HOW_SELECT);
}

void Navigate (nav_what)
char * nav_what;
{
	int nx, ny;
	Ship ship;
	Sector sct, next;
	char * ptr, * ptri;
	int minmob;
	double newmob;
	int rad, son;
	int button;
	char * path;
	char * answer;
	int best_rad, best_son;

	UnmarkAllShips ();
	MarkShips (nav_what);
	SetAgain (RedoNavigate);

	minmob = MinMobMarkedShips (& ship);
	if (minmob < 0)
	{
		if (ship == (Ship) 0)
		{
			Message ("No ships selected to navigate !");
			Bell ();
			return;
		}
		else	/* if (! deity) */
		{
			Message (Fmt ("%s #%d out of mobility",
				ShipName (ship), sh_nr (ship)));
			return;
		}
	}

	if (! CrewOnMarkedShips  (& ship))
	{
		Message (Fmt ("%s #%d is crewless",
				ShipName (ship), sh_nr (ship)));
		Bell ();
		return;
	}

	if (! MarkedColocated ())
	{
		Message ("Selected ships are not colocated");
		Bell ();
		return;
	}

	if (LandLockedMarked (& ship))
	{
		Message (Fmt ("%s #%d is landlocked.",
			ShipName (ship), sh_nr (ship)));
		Bell ();
		return;
	}

	sct = SctMarkedShips ();
	if (sct == (Sector) 0)
	{
		Message ("You don't know anything about this sector");
		Bell ();
		return;
	}

	UnmarkSector (cursct);
	MarkSector (sct);
	FeedEmpire (Fmt ("navigate %s", nav_what), PRINT);
	ptr = WaitForPrompt (PRINT);

	if ( EmpireStatus  () == E_COMMAND ||
				sscanf (ptr, "<%*f:%lf", & newmob) != 1)
	{

		PrintAtEmpire (ptr);
		Message ("Navigate failed");
		Bell ();
		cursct = sct;
		return;
	}
	
	rad = MaxRadarMarked (& best_rad);
	if (best_rad == -1)
		best_rad = FirstMarkedShipnr ();

	son = MaxSonarMarked (& best_son);
	FScanResoMarked (sct);

	Message (Fmt ("navigate: now at %s (mob %.1f)",
		CrdStr (sct), newmob));

	for (;;)
	{
		if (EmpireStatus () == E_COMMAND)
		{
			Message ("Navigate stopped");
			MesClearBut ();
			CheckShips (nav_what);
			DoLookout (sct, best_rad, False, PRINT, False);
			cursct = sct;
			return;
		}

		MesBut ("View", "Extended Commands", "Move");

		DoLookout (sct, best_rad, True, PRINT, False);
		FScanResoMarked (sct);

		(void) SelectSctCrd (& nx, & ny, & button);

		if (interrupt)
		{
			interrupt = False;
			FeedEmpire ("aborted", PRINT);
			continue;
		}

		if (button == RIGHT_BUTTON)
			next = World (nx, ny, S_DESIG);
		else
			next = World (nx, ny, S_EXIST);
		
		if (next == (Sector) 0)
			continue;

		if (button == LEFT_BUTTON)
		{
			CensusSct (next);
			continue;
		}
			
		if (button == MIDDLE_BUTTON)
		{
			MesBut (
				(deity || rad > 0) ? Fmt ("Radar (%d)", rad) :
					             "---",
				(deity || son > 0) ? Fmt ("Sonar (%d)", son) :
						     "---",
				"Lookout");

			WaitButtonPress (&button);
			if (interrupt)
			{
				interrupt = False;
				continue;
			}

			if (button == LEFT_BUTTON)
			{
				if (! deity && rad < 0)
					continue;

				FeedEmpire ("r", PRINT);
				ScanRadar ();
			}
			else if (button == MIDDLE_BUTTON)
			{
				if (! deity && son < 1.0)
					continue;

				FeedEmpire ("s", PRINT);
				ScanLookout ();
			}
			else if (button == RIGHT_BUTTON)
			{
				FeedEmpire ("l", PRINT);
				ScanLookout ();
				/* you should always know your neighbours */
			}

			(void) WaitForPrompt (PRINT);
			DrawMap ();

			continue;
		}

		if (button == RIGHT_BUTTON && sct == next)
		{
			FeedEmpire ("h", PRINT);
			(void) WaitForPrompt (PRINT);

			Message (Fmt ("Navigate stopped @ %s", CrdStr (sct)));
			MesClearBut ();

			CheckShips (nav_what);
			cursct = sct;
			return;
		}
		
		/* if (button == RIGHT_BUTTON)  -> true */

		if (s_mines (next) > 0  && s_des (next) != 'h' && 
		    s_des (next) != '=' && ! Confirm (
			"Captain, mines here, still go there ?", False))
					continue;

		path = BestSeaPath (sct, next);
		if (path == (char *) 0)
		{
			Message ("Couldn't find a sea-path !");
			Bell ();
			continue;
		}

		MarkPath (sct, path);
		FeedEmpire (Fmt ("%s", path), PRINT);
		UnmarkPath (sct, path);

		for (;;)
		{
			ptr = ReadEmpire (DONT_PRINT);

			if (EmpireStatus () == E_QUESTION)
			{
				PrintAtEmpire (ptr);
				if (sscanf (ptr, "<%*lf:%lf: %d,%d",
					& newmob, & nx, & ny) != 3)
				{

					answer = InputAtMessage (ptr,
								20, GS_NAME);

					if (interrupt || answer == (char *) 0)
					{
						FeedEmpire ("aborted", PRINT);
						Bell ();
						MesClearBut ();
						(void) WaitForPrompt (PRINT);
						CheckShips (nav_what);
						if (NO_INFO (next))
							FreeSector (next);
						cursct = sct;
						DoLookout (sct, best_rad,
							False, PRINT, False);
						return;
					}

					FeedEmpire (answer, PRINT);
					continue;
				} else
					break;
			}

			if (EmpireStatus () == E_COMMAND)
			{
				PrintAtEmpire (ptr);
				Message ("Navigate failed");
				Bell ();
				MesClearBut ();
				CheckShips (nav_what);
				if (NO_INFO (next))
					FreeSector (next);
				cursct = sct;
				DoLookout (sct, best_rad, False, PRINT, False);
				return;
			}

			if (StrEQ (ptr, "Sweep"))
			{
				Message ("Sweeping mines... -- MORE --");
				Bell ();
				Pause ();
				continue;
			}

			if (strncmp (ptr, "\007Kawhomp!", 9) == 0)
			{
	/* Mark sector mine was actually hit in, not originating sector */
				Sector sct1;
				int x1, y1;

				PrintAtEmpire (ptr + 1);
				sscanf(ptr+1,
	"Kawhomp! Mine detected by %*[^(](#%*d) in %d,%d!",&x1,&y1);
				sct1 = World (x1, y1, S_DESIG);
				if (s_mines (sct1) == 0)
					set_mines (sct1, 128);
				else if (s_mines (sct1) < 127)
					set_mines (sct1, s_mines (sct1) - 1);
				else
					set_mines (sct1, s_mines (sct1) + 1);
				CensusSct (sct1);
				Message ("You hit a mine !!");
				Bell ();
				Pause ();
				continue;
			}

			PrintAtEmpire (ptr);

			ptri = index (ptr, '#');
			if (ptri == (char *) 0)
				continue;
			
			ScanFmt (& ptri, (char *) 0, ")#0-9 \t");

			if (StrEQ (ptri, "can't go to")) 
			{
				if (NO_INFO (next))
					(void) UpdateSectorDes
						(next, '?', False);

				Warning ("You can't go there");
				Bell ();
				DrawSector (next);
				continue;
			}

			if (sscanf (ptri,
				"stopped at %d , %d", & nx, & ny) == 2) 
			{
				(void) UpdateSectorDes (next, '.', False);
				Message ("Out of mobility");
				Bell ();
				MesClearBut ();
				if (EmpireStatus () != E_COMMAND)
				{
					if (EmpireStatus () == E_PRINTING)
						(void) WaitForPrompt (PRINT);
					while (EmpireStatus () != E_COMMAND)
					{
						FeedEmpire ("aborted", PRINT);
						(void) WaitForPrompt (PRINT);
					}
				}
				next = World (nx, ny, S_DESIG);
				MoveMarkedTo (next);
				UnmarkSector (sct);
				MarkSector (next);
				CheckShips (nav_what);
				cursct = next;
				DoLookout (next, best_rad, False, PRINT, False);
				return;
			}
		}
					
		/* Move is oke */

		next = World (nx, ny, S_DESIG);
		(void) UpdateSectorDes (next, '.', False);
		MoveMarkedTo (next);
		FScanResoMarked (sct);
		UnmarkSector (sct);
		sct = next;
		MarkSector (sct);

		Message (Fmt ("navigate: now at %s (mob %.1f)",
			CrdStr (sct), newmob));
	}
}
