#include "type.h"
#include "main.h"
#include "plane.h"
#include "sector.h"
#include "nation.h"

Plane first_plane;

Plane NrToPlane (nr)
int nr;
{
	Plane ptr;

	for (ptr = first_plane; ptr != (Plane) 0; ptr = pl_next (ptr))
		if (pl_nr (ptr) == nr)
			return ptr;
	
	return (Plane) 0;
}

void AddPlaneToList (plane)
Plane plane;
{
	register Plane ptr;
	Plane prev;

	if (plane == (Plane) 0)
		return;

	if (NrToPlane (pl_nr (plane)) != (Plane) 0)
	{
			/* Yuck, exists already ? */
		Panic ("AddPlaneToList", "plane.c", "duplicate plane ?");
		return;
	}

	if (first_plane == (Plane) 0)
	{
		first_plane = plane;
		set_pl_next (plane, (Plane) 0);
		return;
	}

	ptr = first_plane;
	prev = (Plane) 0;
	while (ptr != (Plane) 0)
	{
		if (pl_nr (ptr) > pl_nr (plane))
		{
			if (prev == (Plane) 0)
				first_plane = plane;
			else
				set_pl_next (prev, plane);

			set_pl_next (plane, ptr);
			return;
		}

		prev = ptr;
		ptr = pl_next (ptr);
	}

	set_pl_next (prev, plane);
	set_pl_next (plane, (Plane) 0);
}

void DeletePlaneFromSector (plane)
Plane plane;
{
	Sector sct;
	Plane ptr, prv;

	sct = PlaneSector (plane);
	if (sct == (Sector) 0)
		return;

	prv = (Plane) 0;
	for (ptr = s_fplane (sct); ptr != (Plane) 0; ptr = pl_nxtsct (ptr))
	{
		if (ptr == plane)
		{
			if (prv == (Plane) 0)
				s_fplane (sct) = pl_nxtsct (ptr);
			else
				set_pl_nxtsct (prv, pl_nxtsct (ptr));
			
			dec_pla (sct);
			return;
		}

		prv = ptr;
	}

	Panic ("DeletePlaneFromSector", "plane.c",
			"plane not at internal stored position");
}

void DeletePlane (plane)
Plane plane;
{
        register Plane ptr, prv;

        if (plane == (Plane) 0)
                return;

        /* from sector list */
        DeletePlaneFromSector (plane);

        /* from global list */

        prv = (Plane) 0;
        for (ptr = first_plane; ptr != (Plane) 0; ptr = pl_next (ptr))
        {
                if (ptr == plane)
                {
                        if (prv == (Plane) 0)
                                first_plane = pl_next (first_plane);
                        else
                                set_pl_next (prv, pl_next (plane));

                        if (plane == curplane)
                                curplane = pl_nxtsct (curplane);
                        free ((char *) plane);
                        return;
                }
                prv = ptr;
        }

	Panic ("DeletePlane", "plane.c", "plane not on global list ");
}

void DeletePlanes ()
{
	Plane plane, nplane;

        for (plane = first_plane; plane != (Plane) 0; plane = nplane)
        {
		nplane = pl_next (plane);
		DeletePlane (plane);
	}
}

void AddPlaneToSector (plane, sct)
Plane plane;
Sector sct;
{
	Plane prev;
	Plane ptr;
	Sector from;

	set_pl_xcd (plane, s_xcd (sct));
	set_pl_ycd (plane, s_ycd (sct));
	inc_pla (sct);

	if (s_fplane (sct) == (Plane) 0)
	{
		set_fplane (sct, plane);
		set_pl_nxtsct (plane, (Plane) 0);
		return;
	}

	prev = (Plane) 0;
	ptr = s_fplane (sct);
	while (ptr != (Plane) 0)
	{
		if (pl_nr (ptr) > pl_nr (plane))
		{
			if (prev == (Plane) 0)
				set_fplane (sct, plane);
			else
				set_pl_nxtsct (prev, plane);

			set_pl_nxtsct (plane, ptr);
			return;
		}

		prev = ptr;
		ptr = pl_nxtsct (ptr);
	}

	set_pl_nxtsct (prev, plane);
	set_pl_nxtsct (plane, (Plane) 0);
}

char *PlaneName (plane)
Plane plane;
{
	return (planetypes [pl_type (plane)].  nam);
}

int MaxPlaneLoad (plane)
Plane plane;
{
	PlType type;

	type = planetypes [pl_type (plane)];

	if (! BIT_SET (type. flags, P_C))
		return 0;
	else
		return type. load;
}

bool PortablePlane (plane)
Plane plane;
{
	PlType type;

	type = planetypes [pl_type (plane)];

	if (! BIT_SET (type. flags, P_L) && ! BIT_SET (type. flags, P_M))
		return False;
	else
		return True;
}

char * PlaneCapNames (flags)
long flags;
{
	static char buffer [100];

	buffer [0] = '\0';

	if (BIT_SET (flags, P_B))
		strcat (buffer, " bomber");
	if (BIT_SET (flags, P_T))
		strcat (buffer, " tactical");
	if (BIT_SET (flags, P_F))
		strcat (buffer, " intercept");
	if (BIT_SET (flags, P_C))
		strcat (buffer, " cargo");
	if (BIT_SET (flags, P_V))
		strcat (buffer, " VTOL");
	if (BIT_SET (flags, P_M))
		strcat (buffer, " missile");
	if (BIT_SET (flags, P_L))
		strcat (buffer, " light");
	if (BIT_SET (flags, P_S))
		strcat (buffer, " spy");
	if (BIT_SET (flags, P_I))
		strcat (buffer, " image");
	if (BIT_SET (flags, P_O))
		strcat (buffer, " satellite");
	if (BIT_SET (flags, P_X))
		strcat (buffer, " stealth");
	if (BIT_SET (flags, P_D))
		strcat (buffer, " SDI");
	if (BIT_SET (flags, P_H))
		strcat (buffer, " half-stealth");
	if (BIT_SET (flags, P_A))
		strcat (buffer, " ASW");
	if (BIT_SET (flags, P_N))
		strcat (buffer, " mine");
	if (BIT_SET (flags, P_W))
		strcat (buffer, " sweep");
	if (BIT_SET (flags, P_h))
		strcat (buffer, " helo");
	if (BIT_SET (flags, P_E))
		strcat (buffer, " escort");
	if (BIT_SET (flags, P_P))
		strcat (buffer, " para");
	if (BIT_SET (flags, P_G))
		strcat (buffer, " x-light");
	
	return buffer;
}

static void ShowPlaneCBStrings (strings)
Strings strings;
{
	int i;
	int att, def, range;
	double maint;

	if(chainsaw_version) {
		AddString (strings, Fmt ("%s %s",
			"Name             lcm hcm cost   maint tech acc",
			"loa att def ran cre fue stlth ava flags"));
	} else {
		AddString (strings, Fmt ("%s %s",
			"Name             lcm hcm cost   maint tech acc",
			"loa att def ran cre fue ava flags"));
	}
	AddString (strings, "");

	for (i = 0; planetypes [i]. nam != (char *) 0; i ++)
	{
		if (planetypes [i]. tech > n_tech (nation))
		{
			att = planetypes [i]. att;
			def = planetypes [i]. def;
			range = planetypes [i]. range;
		}
		else
		{
			att = (int) (planetypes [i]. att * (0.75 +
				TechFact ((int) n_tech (nation) -
						planetypes [i]. tech, 2.0)));
			if (att > 127)
				att = 127;

			def = (int) (planetypes [i]. def * (0.75 +
				TechFact ((int) n_tech (nation) -
						planetypes [i]. tech, 2.0)));
			if (def > 127)
				def = 127;

			range = (int) (planetypes [i]. range * (0.75 +
				TechFact ((int) n_tech (nation) -
						planetypes [i]. tech, 2.0)));

			if (range > 127)
				range = 127;
		}

		maint = (etu_per_update *
			- dmin (planetypes [i]. cost * money_plane, -1.0));
		maint -= 5 * planetypes [i]. crew * money_mil * etu_per_update;


		AddString (strings, Fmt (
  "%-16.16s %-3d %-3d %-6s %-5s %-4d %-3d %-3d %-3d %-3d %-3d %-3d %-3d%s%-3d%s",
			planetypes [i]. nam,
			planetypes [i]. lcm,
			planetypes [i]. hcm,
			Fmt ("$%d", planetypes [i]. cost),
			Fmt ("$%d", (int) (0.5 + maint)),
			planetypes [i]. tech,
			planetypes [i]. acc,
			planetypes [i]. load,
			att,
			def,
			range,
			planetypes [i]. crew,
			planetypes [i]. fuel,
			chainsaw_version ? Fmt (" %-3d \% ",
					planetypes [i]. stlth) : "",
			planetypes [i]. ava,
			PlaneCapNames (planetypes [i]. flags)));
	}
}

void PageShowPlaneCBs ()
{
	Strings strings;

	strings = InitStrings ();
	ShowPlaneCBStrings (strings);

	if (StringsSize (strings) == 2)
	{
		Message ("You don't know about planes yet");
		Bell ();
		FreeStrings (strings);
		return;
	}

#ifdef TERMC_VERSION
	ShowStringsInPager (strings, "show plane c&b");
#else /* TERMC_VERSION */
	InitWMPager (strings, "show plane c&b");
#endif /* TERMC_VERSION */
}

bool PlaneHas (plane, flags)
Plane plane;
long flags;
{
	return BIT_SET (planetypes [pl_type (plane)]. flags, flags);
}

void MovePlaneTo (plane, sct)
Plane plane;
Sector sct;
{
        DeletePlaneFromSector (plane);
	AddPlaneToSector (plane, sct);
}

Sector PlaneSector (ptr)
Plane ptr;
{
	return World (pl_xcd (ptr), pl_ycd (ptr), S_DESIG);
}
