#include "main.h"
#include "ship.h"
#include "plane.h"
#include "sector.h"
#include "version.h"
#include "plane.h"

void UnmarkAllPlanes ()
{
	register Plane ptr;

	for ALL_PLANES (ptr)
	{
		clr_pl_20mob (ptr);
		clr_pl_marked (ptr);
		clr_pl_petrol (ptr);
		clr_pl_marked (ptr);
	}
}

void MarkPlanes (form)
char * form;
{
	Plane ptr;
	int sx, sy, ex, ey;
	int nr;

	if (strcmp (form, "*") == 0)
	{
		for ALL_PLANES (ptr)
			set_pl_marked (ptr);

		return;
	}

	if (strlen (form) == 1 && (isalpha (* form) || * form == '~'))
	{
		for ALL_PLANES (ptr)
			if (pl_wing (ptr) == * form)
				set_pl_marked (ptr);
		return;
	}

	if (ConvRealmToCoord (form, & sx, & sy, & ex, & ey))
	{
		for ALL_PLANES (ptr)
			if (pl_xcd (ptr) >= sx && pl_xcd (ptr) <= ex &&
			    pl_ycd (ptr) >= sy && pl_ycd (ptr) <= ey)
				set_pl_marked (ptr);
		return;
	}

	while (ScanDigit (& form, & nr))
	{
		ptr = NrToPlane (nr);
		if (ptr != (Plane) 0)
			set_pl_marked (ptr);
		if (* form == '/')
			form ++;
	}
}

void DeleteMarkedPlanes ()
{
	Plane ptr;
	bool found;

	do
	{
		found = False;

		for ALL_PLANES (ptr)
			if (pl_marked (ptr))
			{
				found = True;
				Error (Fmt ("%s (#%d) is lost",
					PlaneName (ptr), pl_nr (ptr)));
				DeletePlane (ptr);
				break;
			}
	}
	while (found);
}

int MaxRangeMarked (sct)
Sector sct;
{
	register Plane ptr;
	int dist;
	int max_range;

	max_range = 256;

	for ALL_PLANES (ptr)
		if (pl_marked (ptr))
		{
			dist = Dist (s_xcd (sct), pl_xcd (ptr),
				     s_ycd (sct), pl_ycd (ptr));

			if (pl_range (ptr) - dist < max_range)
				max_range = pl_range (ptr) - dist;
		}

	return max_range;
}

int LoadMarked (bomb_mission)
bool bomb_mission;
{
	Plane ptr;
	int load;

	load = 0;
	for ALL_PLANES (ptr)
		if (pl_marked (ptr))
			if ((bomb_mission && (PlaneHas(ptr,P_T)||PlaneHas(ptr,P_B)))
			    || (! bomb_mission && PlaneHas (ptr, P_C)))
				load += planetypes [pl_type (ptr)]. load;
	
	return load;
}

int NrMarkedPlanes ()
{
	Plane ptr;
	int i;

	i = 0;
	for ALL_PLANES (ptr)
		if (pl_marked (ptr))
			i ++;

	return i;
}

void MoveMarkedPlanesTo (sct)
Sector sct;
{
	register Plane ptr;

	for ALL_PLANES (ptr)
		if (pl_marked (ptr))
			MovePlaneTo (ptr, sct);
}

void UnchargePetrol ()
{
	register Plane ptr;
	Sector sct;
	Ship ship;

	for ALL_PLANES (ptr)
		if (pl_marked (ptr) && pl_petrol (ptr))
		{
			clr_pl_petrol (ptr);
			if (pl_shipnr (ptr) >= 0)
			{
				ship = NrToShip (pl_shipnr (ptr));
				if (ship == (Ship) 0)
				{
					Panic ("UnchargePetrol", "plane/mark.c",
						Fmt ("Can't find ship #%d",
							pl_shipnr (ptr)));
					continue;
				}

				set_sh_pet (ship, sh_pet (ship) +
					planetypes [pl_type (ptr)].  fuel);
			}
			else
			{
				sct = PlaneSector (ptr);
				set_q_pet (sct, q_pet (sct) +
					planetypes [pl_type (ptr)].  fuel);
			}
		}
}

bool ChargePetrol ()
{
	register Plane ptr;
	int pet;
	Sector sct;
	Ship ship;

	for ALL_PLANES (ptr)
		if (pl_marked (ptr))
		{
			pet = planetypes [pl_type (ptr)]. fuel;

			if (pl_shipnr (ptr) >= 0)
			{
				ship = NrToShip (pl_shipnr (ptr));
				if (ship == (Ship) 0)
				{
					Panic ("ChargePetrol", "plane/mark.c",
						Fmt ("Can't find ship #%d",
							pl_shipnr (ptr)));
					UnchargePetrol ();
					continue;
				}

				if (pet > sh_pet (ship))
				{
					UnchargePetrol ();
					return False;
				}
				set_sh_pet (ship, sh_pet (ship) - pet);
				set_pl_petrol (ptr);
			}
			else
			{
				sct = PlaneSector (ptr);
				if (pet > q_pet (sct))
				{
					UnchargePetrol ();
					return False;
				}
				set_q_pet (sct, q_pet (sct) - pet);
				set_pl_petrol (ptr);
			}
		}

	return True;
}

bool AllMarkedPlanesHave (flag)
int flag;
{
	register Plane ptr;

	for ALL_PLANES (ptr)
		if (pl_marked (ptr))
		  if (! PlaneHas (ptr, flag))
				return False;

	return True;
}


bool AllMarkedPlanesHaveAnyOf (flag)
int flag;
{
	register Plane ptr;

	for ALL_PLANES (ptr)
	  if (pl_marked (ptr))
	    if (! (planetypes[pl_type(ptr)].flags & flag))
	      return False;
	
	return True;
}

void MarkAs20Mob ()
{
	register Plane ptr;

	for ALL_PLANES (ptr)
		if (pl_marked (ptr))
			set_pl_20mob (ptr);
}

int PlaneMobCost (plane)
Plane plane;
{
	int cost;
	int cost1, cost2;

	if (KSUOption (MERC))
	{
		cost = pl_20mob (plane) ? 20 : 12;
		cost1 = 32 + pl_mob (plane);
		cost2 = cost * 100 / pl_eff (plane);

		return (cost1 > cost2) ? cost2 : cost1;
	}
	else
		return pl_20mob (plane) ? 20 : 12;
}

void ChargeMobility ()
{
	register Plane ptr;

	for ALL_PLANES (ptr)
		if (pl_marked (ptr))
			set_pl_mob (ptr, pl_mob (ptr) - PlaneMobCost (ptr));
}

void MoveMarkedPlanes (design, carrier)
Sector design;
int carrier;
{
	register Plane ptr;
	Plane next;
	int count = 0;

	ptr = first_plane;
	while (ptr != (Plane) 0)
		if (pl_marked (ptr))
		{
		        count++;
			next = pl_next (ptr);
			set_pl_shipnr (ptr, carrier);
			MovePlaneTo (ptr, design);
			ptr = next;
		}
		else
			ptr = pl_next (ptr);
	if(carrier >= 0)
	  inc_sh_pln(NrToShip(carrier), count);
}

void FilterPlanesMob ()
{
	register Plane ptr;

	for ALL_PLANES (ptr)
		if (pl_marked (ptr) && pl_mob (ptr) <= 0)
			clr_pl_marked (ptr);
}

void FilterPlanesHaving (flag)
int flag;
{
	register Plane ptr;

	for ALL_PLANES (ptr)
		if (pl_marked (ptr) && PlaneHas (ptr, flag))
				clr_pl_marked (ptr);
}

void FilterPlanesNotHaving (flag)
int flag;
{
	register Plane ptr;

	for ALL_PLANES (ptr)
		if (pl_marked (ptr) && ! PlaneHas (ptr, flag))
				clr_pl_marked (ptr);
}

void FilterNonBombers ()
{
	register Plane ptr;

	for ALL_PLANES (ptr)
		if (pl_marked (ptr) && ! (PlaneHas (ptr, P_B) ||
					  PlaneHas (ptr, P_T)))
				clr_pl_marked (ptr);
}

char * MarkedPlanesId (mobcost)
bool mobcost;
{
	register Plane ptr;
	static char buffer [2] [BUFSIZ];
	bool first;
	static int n = 0;

	first = True;
	n = (n + 1) % 2;
	buffer [n][0] = '\0';
	for ALL_PLANES (ptr)
		if (pl_marked (ptr))
		{
			if (mobcost == MOB20 && ! pl_20mob (ptr) ||
			    mobcost == MOB12 && pl_20mob (ptr))
				continue;

			if (first)
				first = False;
			else
				strcat (buffer [n], "/");
			
			strcat (buffer [n], Fmt ("%d", pl_nr (ptr)));
		}

	return first ? (char *) 0 : buffer [n];
}

void UnloadMarkedPlanes (itemchar, mult)
char itemchar;
int mult;
{
	Plane ptr;
	Sector sct;
	Ship ship;
	int quant;

	for ALL_PLANES (ptr)
		if (pl_marked (ptr) && pl_20mob (ptr) && pl_loaded (ptr))
		{
			quant = mult * planetypes [pl_type (ptr)]. load;
			if (pl_shipnr (ptr) >= 0)
			{
				ship = NrToShip (pl_shipnr (ptr));
				SetShipQuant (ship, itemchar, GiveShipQuant
						(ship, itemchar) + quant);
			}
			else
			{
				sct = PlaneSector (ptr);
				SetQuant (sct, itemchar, GiveQuant (sct,
					itemchar) + quant);
			}
			clr_pl_loaded (ptr);
		}
}

bool LoadMarkedPlanes (itemchar, mult)
char itemchar;
int mult;
{
	Plane ptr;
	Ship ship;
	Sector sct;
	int quant, i;
	int weight;

	weight = ItemWeight (CharToItem (itemchar), NPKG);
	if (weight <= 0)
		return False;
	for ALL_PLANES (ptr)
		if (pl_marked (ptr) && pl_20mob (ptr))
		{
			quant = (int) (mult * planetypes [pl_type (ptr)]. load /
				weight);
			if (pl_shipnr (ptr) >= 0)
			{
				ship = NrToShip (pl_shipnr (ptr));
				i = GiveShipQuant (ship, itemchar);
				if (i < quant)
				{
					UnloadMarkedPlanes (itemchar, mult);
					return False;
				}
				SetShipQuant (ship, itemchar, i - quant);
			}
			else
			{
				sct = PlaneSector (ptr);
				i = GiveQuant (sct, itemchar);
				if (i < quant)
				{
					UnloadMarkedPlanes (itemchar, mult);
					return False;
				}
				SetQuant (sct, itemchar, i - quant);
			}

			set_pl_loaded (ptr);
		}

	return True;
}

void DropMarkedPlanes (item, mult, sct)
char item;
int mult;
Sector sct;
{
	Plane ptr;
	int quant;
	int weight;

	weight = ItemWeight (CharToItem (item), NPKG);
	if (weight <= 0)
		return;
	quant = GiveQuant (sct, item);
	for ALL_PLANES (ptr)
		if (pl_marked (ptr) && pl_loaded (ptr) && pl_20mob (ptr))
		{
			quant += (int) (mult * planetypes [pl_type (ptr)]. load
				/ weight);
			clr_pl_loaded (ptr);
		}
	SetQuant (sct, item, quant);
}

