#include "type.h"
#include "main.h"
#include "sector.h"
#include "plane.h"
#include "var.h"
#include "ship.h"

static char * last_planes = (char *) 0;
static char * last_escort = (char *) 0;
static char * last_path = (char *) 0;
static int last_x, last_y;
static Sector last_sct = (Sector) 0;
static Sector last_design = (Sector) 0;
static char * last_strat = (char *) 0;

void RedoBomb ()
{
	char * new_path;

		/*
		 *	1). Still standing on your airfield?
		 *	    -> bomb the same last sector
		 *
		 *	2). Other (enemy) sector?
		 *          -> bomb this sector with same planes/escorts
		 *
		 *	3). Other (own) airfield?
		 *	    -> select planes to bomb the last target.
		 */

	if (cursct == last_sct)
	{
		DoBomb (last_x, last_y, cursct, last_planes, last_escort,
					last_path, last_strat, True);
		return;
	}

	if (last_sct == (Sector) 0)
	{
		Message ("No last sector !");
		Bell ();
		return;
	}

	if (! s_owned (cursct))
	{
		new_path = BestFlyPath (s_xcd (last_sct), s_ycd (last_sct),
					s_xcd (cursct),   s_ycd (cursct));

		if (new_path == (char *) 0)
		{
			Message ("Too far away !");
			Bell ();
			return;
		}

		DoBomb (last_x, last_y, last_sct,
			last_planes, last_escort, new_path, last_strat, False);
		return;
	}

	DoBomb (last_x, last_y, cursct, (char *) 0, (char *) 0, (char *) 0,
					(char *) 0, False);
}

void Bomb (x, y)
int x, y;
{
	DoBomb (x, y, cursct, (char *) 0, (char *) 0, (char *) 0, (char *) 0,
				False);
}

	/*
	 *	Bind key to Bomb ( stratic )
	 */

void BindBomb (x, y, str)
int x, y;
char * str;
{
	char buf [20];
	char * planes;

	if (last_layout == PLANE_MODE)
		planes = Fmt ("%d", pl_nr (curplane));
	else if (last_layout == WING_MODE)
		planes = WingId ();
	else
		planes = (char *) 0;

	if (str != (char *) 0 && sscanf (str, " ( %s )", buf) == 1)
	{
		if (index ("spn", * buf) == (char *) 0)
		{
			Message (Fmt ("Illegal bind: Bomb (%s)", buf));
			Bell ();
			return;
		}

		DoBomb (x, y, cursct, planes, (char *) 0, (char *) 0,
				buf, False);
	}
	else
		DoBomb (x, y, cursct, planes, (char *) 0, (char *) 0,
				(char *) 0, False);
}

void DoBomb (x, y, from, planes, escort, path, strat, confirm)
int x, y;
Sector from;
char * planes;
char * escort, * path;
char * strat;
bool confirm;
{
	int max_range;
	int load;
	Sector design;

	UnmarkAllPlanes ();

	if (planes == (char *) 0)
	{
		planes = SelectPlanes (x, y, from, MIS_BOMB,
							"Bomb which planes ?");
		if (planes == (char *) 0)
		{
			Message ("Bomb cancelled");
			return;
		}
	}

	MarkPlanes (planes);
	FilterPlanesMob ();
/*
	FilterPlanesHaving (P_M);
	FilterPlanesHaving (P_O);
*/
	FilterNonBombers();
	MarkAs20Mob ();
	planes = MarkedPlanesId (MOB20);

	if (planes == (char *) 0)
	{
		Message ("Nothing to Bomb with");
		Bell ();
		return;
	}

	if (last_planes != (char *) 0)
		free (last_planes);
	last_planes = Str (planes);

	load = LoadMarked (True);	/* it's a bombing mission ! */
	if (load == 0)
	{
		Message ("None of your planes can carry shells !");
		Bell ();
		return;
	}

	if (! LoadMarkedPlanes ('s', 1))
	{
		Message ("Not enough shells");
		Bell ();
		return;
	}

	if (escort == (char *) 0)
		escort = SelectPlanes (x, y, from, MIS_ESCORT,
						"Use as escort ?");

	if (escort != (char *) 0)
	{
		MarkPlanes (escort);
		FilterPlanesMob ();
		FilterPlanesHaving (P_M);
		FilterPlanesHaving (P_O);

		escort = MarkedPlanesId (MOB12);
	}

	if (escort == (char *) 0)
		escort = ".";

	if (last_escort != (char *) 0)
		free (last_escort);
	last_escort = Str (escort);

	if (! ChargePetrol ())
	{
		Message ("Not enough petrol !");
		UnloadMarkedPlanes ('s', 1);
		Bell ();
		return;
	}

	max_range = MaxRangeMarked (from); 
	SetAgain (RedoBomb);
	last_x = x;
	last_y = y;
	last_sct = from;
	if (path == (char *) 0 || confirm && ! Confirm ("Same sector", True))
	{
		path = AskFlyRoute (from, (max_range - 2) / 2, "Bomb");

		if (path == (char *) 0)
		{
			Message ("Bomb cancelled");
			UnchargePetrol ();
			UnloadMarkedPlanes ('s', 1);
			return;
		}
	}
	else
	{
		if (strlen (path) > max_range - 1)
		{
			Message ("Too far away !");
			UnchargePetrol ();
			UnloadMarkedPlanes ('s', 1);
			return;
		}
	}

	if (last_path != (char *) 0)
		free (last_path);
	last_path = Str (path);
	
	design = FollowPath (from, path);
	last_design = design;

	if (design != (Sector) 0 && s_owned (design) &&
		! Confirm ("That's your own sector, still go on", False))
	{
		Message ("bomb cancelled");
		UnchargePetrol ();
		UnloadMarkedPlanes ('s', 1);
		return;
	}

	if (strat == (char *) 0)
	{
		strat = InputAtMessage ("pinpoint, strategic, or nuclear [p]: ",
							1, "psn");

		if (strat == (char *) 0 || interrupt)
		{
			interrupt = False;
			Message ("Bomb cancelled");
			UnchargePetrol ();
			UnloadMarkedPlanes ('s', 1);
			return;
		}
	}

	if (last_strat != (char *) 0)
		free(last_strat);
	last_strat = Str (strat);

	if (* strat == 's' && s_des (design) == '.' && ! Confirm (
		"Strategic bombing sea ?? Continue ?", False))
	{
		Message ("Bomb cancelled");
		UnchargePetrol ();
		UnloadMarkedPlanes ('s', 1);
		return;
	}

	if (! FeedFly ("bomb", planes, escort,
		(* strat == '\0'  || * strat == 'p') ? "pinpoint" :
			* strat == 's' ? "strategic" : "nuclear",
		CrdStr (from), Fmt ("%sh", path), (char *) 0))
	{
		Message ("Something went wrong, bomb failed?");
		Bell ();
		UnchargePetrol ();
		UnloadMarkedPlanes ('s', 1);
		return;
	}

	ChargeMobility ();
	ParseFlyOutput (-1);
	CensusSct (from);
	DrawSector (from);
	Message ("Bomb done");
}
