#include "main.h"
#include "nuke.h"
#include "sector.h"

void AddStockToSct (sct, stock)
Sector sct;
Stockp stock;
{
	int total;
	int i;

	total = 0;
	for (i = 0; i < nr_nuke_types; i ++)
		total += sp_nukamt (stock, i);
	
	set_nuk (sct, total);
	set_stock (sct, stock);
}

void BinDumpNukes (fp)
File fp;
{
	int size;
	Stockp dummy, ptr;

	size = sizeof (struct s_nuke);
	fwrite ((char *) & size, sizeof (int), 1, fp);

	for (ptr = spl_head; ptr != (Stockp) 0; ptr = sp_next (ptr))
		(void) fwrite ((char *) ptr, size, 1, fp);

	dummy = NewStockPile ();
	set_sp_nr (dummy, -1);
	(void) fwrite ((char *) dummy, size, 1, fp);
	FreeStockPile (dummy);
}

bool BinRestoreNukes (fp)
File fp;
{
	int size;
	Stockp ptr;
	Sector sct;

	fread ((char *) & size, sizeof (size), 1, fp);
	if (size != sizeof (struct s_nuke))
		return False;

	for (;;)
	{
		ptr = NewStockPile ();
		fread ((char *) ptr, size, 1, fp);
		set_sp_next (ptr, (Stockp) 0);

		if (sp_nr (ptr) < 0)
			break;

		sct = World (sp_x (ptr), sp_y (ptr), S_EXIST);
		if (sct != (Sector) 0)
			AddStockToSct (sct, ptr);
	}

	FreeStockPile (ptr);
	return True;
}
