	/*
	 *	STRUCTURES DEFINITIONS.
	 */

typedef struct s_ipixel * IPixel;
typedef struct s_wpixel * WPixel;
typedef struct s_spixel * SPixel;

typedef struct s_wininfo
{
	/* Part 1 */

	int savelines;
	bool scrollbar;
	double mult;
	int box;
	int offset_x, offset_y;
	WinInfo parent;

	/* Part 2 */

	int si_max_x, si_max_y;
	int si_scroll_x;
	int si_start_x, si_start_y;
	int si_height, si_width;
	WPixel ** si_pixels;

	/* Part 3 */

	int wd_max_x, wd_max_y;
	int wd_start_y;
	SPixel ** wd_pixels;
}
	WININFO;

	/*
	 *	A pixel at the screen
	 */

typedef struct s_spixel
{
	char cont;
	bool reversed;
	bool underlined;
}
	SPIXEL;

	/*
	 *	A pixel in a window;
	 */

typedef struct s_wpixel
{
	char cont;
	bool reversed;
	bool underlined;

	WPixel under;
	WPixel above;
	WinInfo parent;
}
	WPIXEL;

	/*
	 *	The image of the screen (how it should look).
	 */

typedef struct s_ipixel
{
	WPixel pixel_info;
	WinInfo parent;
}
	IPIXEL;
