#ifndef _PLANE

#define _PLANE

#define MAX_PLANETYPES	200

struct s_plane
{
	int nr;
	int x, y;
	int own; 		/* owning country (deity only) */
	uchar type;		/* index in plane_type tabel */
	char eff;		/* actually "training" */
	int mob;		/* mobility */
	int tech;		/* plane's tech level */
	int stlth;
	char wing;		/* like fleet */
	uchar range;		/* total distance, not radius */
	uchar max_range;	/* maximum range (KSU - RANGEEDIT) */
	int shipnr;		/* pointer to carrier */
	uchar att;		/* plane air-air attack/defense values */
	char def;
	uchar hard;		/* for missiles */
	uchar nuketype;		/* type of nuclear armament (if any) */
	uchar nukeamt;		/* # of nukes */
	uchar flags;		/* State of the plane */
	Plane next;
	Plane nxtsct;
};

#define PB_LAUNC	0x01
#define	PB_SELL		0x02
#define PB_MARK		0x04
#define PB_PETROL	0x08
#define PB_20MOB	0x10
#define PB_LOADED	0x20

#define	MOB12		True
#define MOB20		False

#define pl_nr(p)	(p)-> nr
#define pl_xcd(p)	(p)-> x
#define pl_ycd(p)	(p)-> y
#define pl_owner(p)	(p)-> own
#define pl_owned(p)	((p)-> own == my_cnum)
#define pl_type(p)	(int) (p)-> type
#define pl_eff(p)	(int) (p)-> eff
#define pl_mob(p)	(int) (p)-> mob
#define pl_stlth(p)	(int) (p)-> stlth
#define pl_tech(p)	(p)-> tech
#define pl_wing(p)	(p)-> wing
#define pl_range(p)	(int) (p)-> range
#define pl_maxrange(p)	(int) (p)-> max_range
#define pl_shipnr(p)	(p)-> shipnr
#define pl_att(p)	(int) (p)-> att
#define pl_flags(p)	(int) (p)-> flags
#define pl_next(p)	(p)-> next
#define pl_nxtsct(p)	(p)-> nxtsct
#define pl_hard(p)	(p)-> hard
#define pl_def(p)	(p)-> def
#define pl_nukeamt(p)	(p)-> nukeamt
#define pl_nuketype(p)	(p)-> nuketype

#define pl_launc(p)	BIT_SET ((p)-> flags, PB_LAUNC)
#define pl_sell(p)	BIT_SET ((p)-> flags, PB_SELL)
#define pl_marked(p)	BIT_SET ((p)-> flags, PB_MARK)
#define pl_petrol(p)	BIT_SET ((p)-> flags, PB_PETROL)
#define pl_20mob(p)	BIT_SET ((p)-> flags, PB_20MOB)
#define pl_loaded(p)	BIT_SET ((p)-> flags, PB_LOADED)

#define set_pl_nr(p,q)		(p)-> nr = (int) q
#define set_pl_xcd(p,q)		(p)-> x = (int) q
#define set_pl_ycd(p,q)		(p)-> y = (int) q
#define set_pl_owner(p,q)	(p)-> own = (int) q
#define set_pl_owned(p)		(p)-> own = (int) my_cnum
#define set_pl_type(p,q)	(p)-> type = (uchar) q
#define set_pl_eff(p,q)		(p)-> eff = (uchar) q
#define set_pl_mob(p,q)		(p)-> mob = (int) q
#define set_pl_stlth(p,q)	(p)-> stlth = (int) q
#define set_pl_tech(p,q)	(p)-> tech = (int) q
#define set_pl_wing(p,q)	(p)-> wing = q
#define set_pl_range(p,q)	(p)-> range = (uchar) q
#define set_pl_shipnr(p,q)	(p)-> shipnr = q
#define set_pl_att(p,q)		(p)-> att = (uchar) q
#define set_pl_flags(p,q)	(p)-> flags = (uchar) q
#define set_pl_next(p,q)	(p)-> next = q
#define set_pl_nxtsct(p,q)	(p)-> nxtsct = q
#define set_pl_hard(p,q)	(p)-> hard = (uchar) q
#define inc_pl_hard(p,q)	(p)-> hard += (uchar) q
#define set_pl_def(p,q)		(p)-> def = (char) q
#define set_pl_nukeamt(p,q)	(p)-> nukeamt = (uchar) q
#define set_pl_nuketype(p,q)	(p)-> nuketype = (uchar) q

#define set_pl_launc(p)		SET_BIT ((p)-> flags, PB_LAUNC)
#define clr_pl_launc(p)		CLR_BIT ((p)-> flags, PB_LAUNC)
#define set_pl_marked(p)	SET_BIT ((p)-> flags, PB_MARK)
#define clr_pl_marked(p)	CLR_BIT ((p)-> flags, PB_MARK)
#define set_pl_sell(p)		SET_BIT ((p)-> flags, PB_SELL)
#define clr_pl_sell(p)		CLR_BIT ((p)-> flags, PB_SELL)
#define set_pl_petrol(p)	SET_BIT ((p)-> flags, PB_PETROL)
#define clr_pl_petrol(p)	CLR_BIT ((p)-> flags, PB_PETROL)
#define set_pl_20mob(p)		SET_BIT ((p)-> flags, PB_20MOB)
#define clr_pl_20mob(p)		CLR_BIT ((p)-> flags, PB_20MOB)
#define set_pl_loaded(p)	SET_BIT ((p)-> flags, PB_LOADED)
#define clr_pl_loaded(p)	CLR_BIT ((p)-> flags, PB_LOADED)

struct s_pltype
{
	char *nam;		/* plane unit name */
	int lcm;		/* costs to build */
	int hcm;
	int cost;
	int tech;		/* tech needed to build */
	int acc;		/* bombing accuracy (higher the better) */
	int load;		/* bomb load, also for carrying cargo */
	int att;		/* air-air attack/defense strengths */
	int def;
	int range;		/* how many sectors it can fly */
	int crew;		/* number of mil to crew it */
	int fuel;		/* fuel consumption */
	int stlth;
	int ava;
	long flags;		/* description of capability */
};

extern PlType planetypes [];
extern Plane first_plane;

typedef enum {
	MIS_FLY,
	MIS_BOMB,
	MIS_DROP,
	MIS_ESCORT,
	MIS_PARADROP,
	MIS_RECON,
	MIS_WINGADD,
	MIS_TRANSPORT
}
	Mission;

#define P_B	0x00001	/* bombing factor only for bombing */
#define P_T	0x00002	/* tactical bombing ability */
#define P_F	0x00004	/* interceptor/escort */
#define P_C	0x00008	/* bombing factor for transport only */
#define P_V	0x00010	/* vtol ability */
#define P_M	0x00020	/* missile, used only once, can't be intercepted */
#define P_L	0x00040	/* light plane, lands on carriers */
#define P_S	0x00080	/* Spy ability */
#define P_I	0x00100	/* Imaging ability (advanced spying) */
#define P_O	0x00200	/* Orbital ability (a satellite) */
#define P_X	0x00400	/* Stealth ability */
#define P_D	0x00800	/* KSU SDI (ABM) ability */
#define P_H     0x01000  /* Half-steath */
#define P_A     0x02000  /* ASW */
#define P_N     0x04000  /* mine */
#define P_E     0x08000  /* escort */
#define P_h     0x10000  /* Helo */
#define P_W     0x20000  /* Sweep */
#define P_P	0x40000  /* para */
#define P_G     0x80000  /* x-light */

#define P_KNOWN	0x80000	/* do we now this ship */


#define ALL_PLANES(p)	(p = first_plane; p != (Plane) 0; p = pl_next (p))

#define PCM_BOMB	0
#define	PCM_TRANSPORT	1
#define PCM_RECON	2
#define PCM_PARADROP	3
#define	PCM_LAUNCH	4
#define	PCM_SCRAP	5
#define	PCM_DROP	6
#define	PCM_HARDEN	7
#define	PCM_FLY		8
#define	PCM_ARM		9
#define	PCM_SET		10
#define	PCM_BUILD	11

#define PCM_MAX		12

extern bool pl_census_enable [];

#define	AIR_EFF		40

#endif _PLANE
