#include "main.h"
#include "nation.h"

#define UNKNOWN		-1
#define PRIMITIVE	0
#define	BACKWARD	1
#define	SIMILAR		2
#define	ADVANCED	3
#define	SUPERIOR	4

typedef struct s_repinfo REPINFO;

struct s_repinfo
{
	int tech;
	int research;
	int education;
};

static int ScanRepStatus (str)
char * str;
{
	if (strncmp (str, "superior", 8) == 0)
		return SUPERIOR;
	else if (strncmp (str, "advanced", 8) == 0)
		return ADVANCED;
	else if (strncmp (str, "similar", 7) == 0)
		return SIMILAR;
	else if (strncmp (str, "backward", 8) == 0)
		return BACKWARD;
	else if (strncmp (str, "primitive", 9) == 0)
		return PRIMITIVE;
	else 
	{
		Bell ();
		PrintAtEmpire (Fmt ("Unknown status found in report (%9.9s)",
				str));
		return UNKNOWN;
	}
}

RepInfo ScanReportAs (country)
int country;
{
	RepInfo info;
	char * ptr;

	info = (RepInfo) doalloc ((unsigned) sizeof (REPINFO));

	FeedEmpire (Fmt ("report %d", country), PRINT);
	PrintAtEmpire ("xemp: scanning report");

	for (;;)
	{
		ptr = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () == E_COMMAND)
		{
			Message ("Something went wrong...");
			Bell ();
			FreeReportInfo (info);
			return (RepInfo) 0;
		}

		if (EmpireStatus () == E_QUESTION)
		{
			if (! HandleQuestion (ptr))
			{
				Message ("Report cancellled");
				FreeReportInfo (info);
				return (RepInfo) 0;
			}
		}

		if (atoi (ptr) == 0)
			continue;
		
		info-> tech      = ScanRepStatus (ptr + 22);
		info-> research  = ScanRepStatus (ptr + 34);
		info-> education = ScanRepStatus (ptr + 46);
	
		ptr = WaitForPrompt (DONT_PRINT);
		PrintAtEmpire (ptr);
		return info;
	}
}

void FreeReportInfo (info)
RepInfo info;
{
	(void) free ((char *) info);
}

static void PrintRepStat (win, y, stat, str, yours)
WinInfo win;
int y;
int stat;
char * str;
double yours;
{
	char * strstat;

	switch (stat)
	{

	case PRIMITIVE:
		strstat = "Primitive";
		PrintN (win, 25, y, Fmt ("(X =< %.0f)", 
				dmax (yours * 0.1 - 0.9, yours - 50.0)));
		break;

	case BACKWARD:
		strstat = "Backward";
		PrintN (win, 25, y, Fmt ("(%.0f =< X < %.0f)",
				dmax (yours * 0.1 - 0.9, yours - 50.0),
				0.5 * yours));
		break;

	case SIMILAR:
		strstat = "Similar";
		PrintN (win, 25, y, Fmt ("(%.0f =< X < %.0f)",
				0.5 * yours,
				dmin (yours * 2.0 + 1.0,  yours + 50.0)));
		break;

	case ADVANCED:
		strstat = "Advanced";
		PrintN (win, 25, y, Fmt ("(%.0f =< X < %.0f)",
				dmin (yours * 2.0 + 1.0,  yours + 50.0),
				dmin (yours * 10.0 + 9.0, yours + 300.0)));
		break;

	case SUPERIOR:
		strstat = "Superior";
		PrintN (win, 25, y, Fmt ("(X >= %.0f)",
				dmin (yours * 10.0 + 9.0, yours + 300.0)));
		break;

	default:
		strstat = "Unknown";
		break;
	}

	PrintN (win, 0, y, Fmt ("%-12s %-10s", str, strstat));
}

void PrintRepInfo (win, y, info)
WinInfo win;
int y;
RepInfo info;
{
	PrintN (win, 0, y, "Report info:");
	PrintRepStat (win, y + 2, info-> tech, "Technology", n_tech (nation));
	PrintRepStat (win, y + 3, info-> research,
			"Research", n_research (nation));
	PrintRepStat (win, y + 4, info-> education,
			"Education", n_educ (nation));
}
