#include "type.h"
#include "tc_type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "ship.h"

#define MAX_BINDINGS	100

extern void RaiseEmpWin();
extern void LowerEmpWin();

typedef enum 
{
	OK,
	OWNED,		/* you should own that sector */
	OCC,		/* occupied sector */
	ENEM_NEXT,	/* next to enemy sector */
	SHIP,		/* You should have a current ship (owned) */
	SHIPS,		/* Should be ships in this sector */
	ENEM_SHIP,
	PLANE
} Condition;


static int nr_bindings = 0;

struct s_funclist 
{
	char * name;
	void (* proc) ();
	Condition cond;
};

struct s_binding
{
	struct s_funclist * fptr;
	char * args;
	char ch;
};

struct s_funclist flist [] =
{
	{ "assault",		BindAssault,		OK },
	{ "board",		BindBoard,		ENEM_SHIP },
	{ "attack",		Attack,			ENEM_NEXT },
	{ "connections",	Connections,		OK },
	{ "reconnect",		Reconnect,		OK },
	{ "global commands",	GlobalCommands,		OK },
	{ "census mode",	BindCensusMode, 	OK },
	{ "deliver",		Deliver,		OWNED },
	{ "designate",		BindDesignate,		OWNED },
	{ "distribute",		Distribute,		OWNED },
	{ "drop off",		BindDropOff,		PLANE },
	{ "distribute utility",	UtilDist,		OWNED },
	{ "expression",		BindExpression,		OK },
	{ "ferry utility",	FerryUtil,		OK },
	{ "info",		InfoCommands,		OK },
	{ "fly",		BindFly,		PLANE },
	{ "disconnect",		Disconnect,		OK },
	{ "announce",		Announce,		OK },
	{ "center map",		DoCenterMap,		OK },
	{ "news",		News,			OK },
	{ "headlines",		ShowHeadLines,		OK },
	{ "read",		BindRead,		OK },
	{ "change display",	ChangeDisplay,		OK },
	{ "goto",		GotoSct,		OK },
	{ "explore",		Explore,		OWNED },
	{ "explore util",	ExploreUtil,		OK },
	{ "build ship",		BuildShip,		OWNED },
	{ "navigate",		BindNavigate,		SHIPS },
	{ "store data",		StoreData,		OK },
	{ "highlight",		SetHighlight,		OK },
	{ "quit",		DoQuit,			OK },
	{ "move", 		BindMove,		OWNED },
	{ "reread",		BindReRead,		OK },
	{ "raise empire win",	RaiseEmpWin,		OK },
	{ "lower empire win",   LowerEmpWin,		OK },
	{ "bind key",		BindKeys,		OK },
	{ "enlist",		BindEnlist,		OWNED },
	{ "send",		BindSend,		OK },
	{ "demobilize",		BindDemob,		OWNED },
	{ "convert",		BindConvert,		OCC },
	{ "bomb",		BindBomb,		PLANE },
	{ "run program",	MultiProg,		OK },
	{ "shoot",		BindShoot,		OWNED },
	{ "multi enlist",	MultiEnlist,		OK },
	{ "multi demob",	MultiDemob,		OK },
	{ "multi convert",	MultiConvert,		OK },
	{ "check",		Check,			OK },
	{ "tend",		BindTend,		SHIP },
	{ "fast quit",		FastQuit,		OK },
	{ "page command",	WMPageCommand,		OK },
	{ "sector ferries",	ListSectorFerries,	OWNED },
	{ "goto ferry",		GotoFerry,		OK },
	{ "nation",		ShowNation,		OK },
	{ "normal display",	BindNormalDisplay,	OK },
	{ "again",		DoAgain,		OK },
	{ "mine",		BindMine,		SHIP },

		/* DEBUG */
	{ "where",		TestWhere,		OWNED },
	{ (char *) 0,		(void (*)())0,		(Condition) 0 }
};

struct s_binding bindings [MAX_BINDINGS];

static char NameToKey (name)
char * name;
{
	if (strcmp (name, "Space") == 0)
		return ' ';
	else if (strcmp (name, "Tab") == 0)
		return '\t';
	else if (strcmp (name, "Return") == 0)
		return '\n';
	else if (strcmp (name, "Backspace") == 0)
		return '\b';
	
	return '\0';
}

char * AddBindingKey (key, bind)
char * key, * bind;
{
	char ch;
	int nr, i;
	char * ptri;

	ch = NameToKey (key);
	if (ch == '\0')
	{
		if (strlen (key) > 2)
			return "Strange key!";

		if (strlen (key) == 2)
		{
			if (* key != '^')
				return "Strange key!";
			
			ch = key [1];

			if (ch >= 'a' && ch <= 'z')
				ch += 'A' - 'a';

			if (ch < 'A' || ch > 'Z')
				return "Strange control key";
			
			ch -= '@';
		}
		else
			ch = key [0];
	}

	
	for (nr = 0; nr < nr_bindings; nr ++)
		if (ch == bindings [nr]. ch)
			break;
		
	if (nr >= MAX_BINDINGS)
		return "binding table exhausted";

	bindings [nr]. ch = ch;

	ptri = index (bind, '(');
	if (ptri != (char *) 0)
	{
		bindings [nr]. args = Str (ptri);
		bind = Str (bind);
		ptri = index (bind, '(');
		* ptri = '\0';
		while (* -- ptri == ' ')
			* ptri = '\0';
	}
	else
	{
		bind = Str (bind);	/* just to keep things simple */
		bindings [nr]. args = (char *) 0;
	}
		

	for (i = 0; flist [i]. name != (char *) 0; i++)
		if (strcmp (bind, flist [i]. name) == 0)
		{
			bindings [nr]. fptr = & flist [i];

			if (nr >= nr_bindings)
			{
				nr_bindings ++;
				return (char *) 0;
			}
			else
				return "Key rebound";
		}

	free (bind);
	return "No such function";
}

void BindKeys (x, y)
int x, y;
{
	char * key, * ptr;
	int i;
	Strings strings;
	Pager pager;

	key = InputAtMessage ("Which key to bind: ", 10, GS_TEXT);

	if (key == (char *) 0 || interrupt || * key == '\0')
	{
		interrupt = False;
		Message ("Bind key cancelled");
		Bell ();
		return;
	}

	strings = InitStrings ();
	for (i = 0; flist [i]. name != (char *) 0; i++)
		AddSortStringID (strings, flist [i]. name, i);

	pager = InitPager (strings, "Which command?");

	MapPagerFromTop (pager, map_win, x, y);

	i = PagerMenu (pager);

	FreePager (pager);
	FreeStrings (strings);

	if (i < 0)
		return;

	ptr = AddBindingKey (key, flist [i]. name);

	if (ptr != (char *) 0)
	{
		Message (ptr);
		Bell ();
	}
	else
		Message ("Key bound");
}

static bool CheckBinding (cond)
Condition cond;
{
	Sector nxt;
	Neighb neighb;

	switch (cond)
	{

	case OK:
		return True;
	
	case OCC:
	case OWNED:
		if (cursct == (Sector) 0)
			return False;

		if (! KNOW_ALL (cursct))
		{
			Message ("You don't own that sector !");
			Bell ();
			return False;
		}

		if (cond == OCC && s_occ (cursct) != '*')
		{
			Message ("Sector not occupied !");
			Bell ();
			return False;
		}

		return True;

	case ENEM_NEXT:
		if (cursct == (Sector) 0)
			return False;

		if (KNOW_ALL (cursct))
		{
			Message ("That's yours !");
			Bell ();
			return False;
		}

		if (s_des (cursct) == '.' || s_des (cursct) == 's' ||
		    s_des (cursct) == '\\')
		{
			Message ("Sector is invulnerable");
			Bell ();
			return False;
		}

		InitNeighbours (cursct, & neighb);
		while (NextNeighbour (& nxt, S_EXIST, neighb))
			if (nxt != (Sector) 0 && KNOW_ALL (nxt))
				return True;
		
		Message ("No owned sectors there");
		Bell ();
		return False;

	case PLANE:
		if (s_pla (cursct) == 0)
		{
			Message ("There are no planes here !");
			Bell ();
			return False;
		}
		return True;

	case SHIP:
		if (curship == (Ship) 0)
		{
			Message ("No current ship !");
			Bell ();
			return False;
		}
		else if (! sh_owned (curship))
		{
			Message ("Hee, you don't own that ship !");
			Bell ();
			return False;
		}

		return True;
	
	case SHIPS:
		if (s_shi (cursct) == 0)
		{
			Message ("Should be ships in this sector !");
			Bell ();
			return False;
		}

		return True;

	case ENEM_SHIP:
		if (last_layout != SHIP_MODE)
		{
			Message ("Current census ain't that of a ship");
			Bell ();
			return False;
		}

		if (sh_owned (curship))
		{
			Message ("That is your ship !");
			Bell ();
			return False;
		}

		return True;

	default:
		Panic ("CheckBinding", "x/xbind.c",
			Fmt ("No such condition (%d)", (int) cond));

		return False;
	}
}
			
void GlobalKey (ch)
char ch;
{
	char buffer [BUFSIZ];
	int nr;

	for (nr = 0; nr < nr_bindings; nr ++)
	{
		if (bindings [nr]. ch == ch)
		{
			if (! CheckBinding (bindings [nr]. fptr-> cond))
				break;

			(* bindings [nr]. fptr-> proc) (
				current_x, current_y, 
				bindings [nr]. args);

			DrawSector (cursct);
			Census ();
			return;
		}
	}

	switch (ch)
	{

	case 'Q':
		DoQuit ();
		break;

	case 'B':
		BindKeys (current_x, current_y);
		break;
	}
}
